#include "visit_writer.h"
#include<math.h>
 
int
main(int argc, char *argv[])
{
#define NX 4
#define NY 5
#define NZ 3
    /* Rectilinear mesh coordinates. */
    float x[] = {0., 1., 2.5, 5.};
    float y[] = {0., 2., 2.25, 2.55,  5.};
    float z[] = {0., 1., 3.};
    int dims[] = {NX, NY, NZ};
    int ndims = 3;
    /* Zonal and Nodal variable data. */
    float zonal[NZ-1][NY-1][NX-1], nodal[NZ][NY][NX];
    float zonalvec[NZ-1][NY-1][NX-1][3], nodalvec[NZ][NY][NX][3];
    /* Info about the variables to pass to visit_writer. */
    int nvars = 2;
    int vardims[] = {1, 3};
    int centering[] = {1, 1};
    const char *varnames[] = {"nodal", "nodalvec"};
    float *vars[] = {(float*)nodal, (float*)nodalvec};
    double cc;
 
    /* Create 2 zonal variables; 1 scalar, 1 vector. */
    int i,j,k,index = 0;
    int NPTS = NZ*NY*NX;
 


    /* Create 2 nodal variables; 1 scalar, 1 vector. */
    index = 0;
    for(k = 0; k < NZ; ++k)
        for(j = 0; j < NY; ++j)
            for(i = 0; i < NX; ++i, ++index)
            {
                nodal[k][j][i] = (float)index;
		cc =(-3.14/4.0)*(double)index;
		float t = ((float)i) / ((float)(NPTS-1));
		float angle = 3.14159 * 10. * t;
 
                nodalvec[k][j][i][0] = t * cos(angle);
                nodalvec[k][j][i][1] = t * sin(angle);
                nodalvec[k][j][i][2] = t;
            }
 
    /* Pass the data to visit_writer to write a VTK file.*/
    write_rectilinear_mesh("vwrect3d.vtk", 0, dims, x, y, z, nvars,
        vardims, centering, varnames, vars);
 
    return 0;
}