#ifndef FUNCOES_2_H
#define FUNCOES_2_H

#include "visit_writer.h"
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include<math.h>
#include <sys/types.h>
#include <time.h>
#include <string.h>
#define true 1
#define false 0

#define pi 3.14159265359

/*-------------------------------------------------------*/
/*                   Gera arquivos vtk                   */
/*-------------------------------------------------------*/
void arquivoVTK(unsigned int IM,unsigned int JM,unsigned int ZM,
		  float x[],float y[],float z[],int numero,double t)
{
    unsigned int NX, NY, NZ;

    NX = IM;
    NY = JM;
    NZ = ZM;

    int dims[] = {NX, NY, NZ};
    int ndims = 3;
    
    /* densidade e velocidade. */
    float densidade[NZ][NY][NX];
    float velocidade[NZ][NY][NX][3];
    
    /* Informacoes passadas para o visit_writer. */
    int nvars = 2;
    int vardims[] = {1, 3};
    int centering[] = {1, 1};
    const char *varnames[] = {"densidade", "velocidade"};
    float *vars[] = {(float*)densidade, (float*)velocidade};
    double cc;
 
    int i,j,k,index = 0;
    int NPTS = NX*NY;
 
    /* Alimentando a quantidade escalar densidade e o vetor velocidade . */
    index = 0;
    for(k = 0; k < NZ; ++k)
        for(j = 0; j < NY; ++j)
            for(i = 0; i < NX; ++i, ++index)
            {
                densidade[k][j][i] = (-3.14/4.0)*(double)index;;
		cc =(-3.14/4.0)*(double)index;
		float t1 = ((float)i) / ((float)(NPTS-1));
		float angle = 3.14159 * 90. * t1*t;
 
		/* componente x da velocidade */
                velocidade[k][j][i][0] = t1 * cos(angle);
		
		/* componente y da velocidade */
                velocidade[k][j][i][1] = t1 * sin(angle);
		
		/* componente z da velocidade */
		velocidade[k][j][i][2] = 0.0;
            }
    char nomedoarquivo[300]="Arquivos_saida_vtk/nome_do_arquivo";
    
    sprintf(nomedoarquivo, "%s%d", nomedoarquivo, numero);/*adiciona o numero da estimativa*/
    strcat(nomedoarquivo,".vtk");/*adiciona texto ao final da string nomedoarquivo*/            
 
    /* Passa as informacoes para visit_writer escrever um arquivo VTK binario.*/
    write_rectilinear_mesh(nomedoarquivo, 1, dims, x, y, z, nvars,
        vardims, centering, varnames, vars);
}

#endif