#ifndef FUNCOES_H
#define FUNCOES_H

#include "visit_writer.h"
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include<math.h>
#include <sys/types.h>
#include <time.h>
#include <string.h>
#define true 1
#define false 0

#define pi 3.14159265359

/*-------------------------------------------------------*/
/*  Estrutura grade para os dominio fisico/computacional */
/*-------------------------------------------------------*/
typedef struct grade_struct {
	double x;
	double y;	
}grade;
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*       Estrutura para alocar as matrizes Q, E e F      */
/*-------------------------------------------------------*/
typedef struct vetor_struct {
	double v[4];
}vetor;
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*   Estrutura para alocar as matrizes Xa,Xa-1,Xb,Xb-1   */
/*-------------------------------------------------------*/
typedef struct vetorX16_struct {
	double Xa[4][4];
	double Xainv[4][4];
	double Xb[4][4];
	double Xbinv[4][4];
}vetorX16;
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*           Calcula o maximo entre dois doubles         */
/*-------------------------------------------------------*/
double max(double a_, double b_)
{
		double maximo;
		maximo = ((((a_ - b_) > 0) ? (a_) : (b_) ));
		return maximo;
}
/*-------------------------------------------------------*/





/*-------------------------------------------------------*/
/*             Calcula o minimo entre dois doubles       */
/*-------------------------------------------------------*/
double min(double a_, double b_)
{
		double minimo;
		minimo = ((((a_ - b_) > 0) ? (b_) : (a_) ));
		return minimo;
}
/*-------------------------------------------------------*/





/*-------------------------------------------------------*/
/*         valor absoluto de um double                   */
/*-------------------------------------------------------*/
double Abs(double d)
{
	double temp;
	if (d>1.0e-15)
	{
	  temp=d;
	}
	else
	{
	  temp=-d;
	}
	return temp;
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*           Calcula o maximo entre dois doubles         */
/*-------------------------------------------------------*/
double Sgn(double a_)
{
		return Abs(a_)/a_;
}
/*-------------------------------------------------------*/




/*-------------------------------------------------------*/
/*                   Calcula o minmod                    */
/*-------------------------------------------------------*/
double minmod(double a_,double b_,double c_,double d_)
{
	double mimod,S;
	
	if((Abs(a_))>1.0e-15)
	{
	  S=Sgn(a_);
	}
	else
	{
	  S=0.0; 
	}
	mimod=min(Abs(a_),S*b_);
	mimod=min(mimod,S*c_);
	mimod=min(mimod,S*d_);
	mimod=S*max(0.0,mimod);
	
	return mimod;
}
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*                    Funcao Pisi                       */
/*-------------------------------------------------------*/
double Pisi(double a_,double e_)
{
	double valor;
	
	if((e_<1.0e-15)||(e_>0.125))
	{
	    printf("\n  VALOR INADEQUADO, SUGESTAO: (0 < E < 0.125)   \n");
	    getchar();
	    getchar();
	    getchar();
	    getchar();
	}
	
	if((Abs(a_))>=e_)
	{
	    valor=Abs(a_);
	}
	else
	{
	    valor=(a_*a_+e_*e_)/(2.0*e_);
	}
	
	return valor;
}
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*                  Cond fronteira                       */
/*-------------------------------------------------------*/
void condfronteira(unsigned int IM,unsigned int JM,
		 grade **mN,grade **mE,grade **fmu,
		 grade **fmv,grade **fmp,grade **fmrho,
    		 grade **fmet,grade **fma)
{
  
    double Ex,Ey,Nx,Ny,ht_,gama_;
    double u,v,a,max1,max2,maxautovalor;
    double t1,t2,Vne, Vte;
    double Vnn, Vtn;
    double Rmais,Rmenos;
    double l1,l2,ue,ve,pe,rhoe,ae,ete;
    double ctegas,M1,Too,poo,voo,rhooo,aoo,aux1,etoo,uoo;
    double Nxbaixo, Nybaixo, Nxcima, Nycima;
    double Vnnbaixo, Vtnbaixo,Vnncima, Vtncima;
    double ubaixo, ucima,vbaixo,vcima;
    double Ci,Di,rhobaixo,rhocima,htwall;
    unsigned int I,J;
    
    
    gama_=1.4;
    ctegas=287.05; /*  constante dos gases (N.m)/kgK   */
    M1=2.0;  /*   Mach  */
    Too=300; /* Temperatura em K   */
    poo=100000.0; /*  Pa   */
    voo=0.0;
    rhooo=(poo)/(ctegas*Too);
    aoo=sqrt(gama_*((poo)/(rhooo)));/* equacao (12-229)  */
    uoo=aoo*M1;
    aux1=((aoo)*(aoo))/(gama_*(gama_-1.0));
    etoo=aux1+0.5*((uoo*uoo)+(voo*voo));
    
    
    maxautovalor=0.0;
    for(I=1;I<=IM;I++)
    {
       for(J=1;J<=JM;J++)
       {
	    Ex=mE[I-1][J-1].x;
	    Ey=mE[I-1][J-1].y;
	    Nx=mN[I-1][J-1].x;
	    Ny=mN[I-1][J-1].y;
	    
	    u=fmu[I][J].x;
	    v=fmv[I][J].x;
	   

/*-------------- Parede de cima  ---------------*/
	    if(J==JM)
	    {   
		Nxbaixo=mN[I-1][J-1-1].x;
		Nybaixo=mN[I-1][J-1-1].y;
		
		ubaixo=fmu[I][J-1].x;
		vbaixo=fmv[I][J-1].x;

		
		t1=Nxbaixo*ubaixo+Nybaixo*vbaixo;
		t2=sqrt(Nxbaixo*Nxbaixo+Nybaixo*Nybaixo);
		Vnnbaixo=t1/t2;
		

		t1=Nybaixo*ubaixo-Nxbaixo*vbaixo;
		t2=sqrt(Nxbaixo*Nxbaixo+Nybaixo*Nybaixo);
		Vtnbaixo=t1/t2;

		/* norma da velocidade de baixo */
		t1=sqrt((Vnnbaixo*Vnnbaixo)+(Vtnbaixo*Vtnbaixo));
		
		/* velocidade com normal a superficie zero e tangencial*/
		/* de mesmo modulo que a logo abaixo */
		fmu[I][J].x=(Sgn(Vtnbaixo)*t1*Ny)/(sqrt((Nx*Nx)+(Ny*Ny)));
		fmv[I][J].x=((fmu[I][J].x)*(-Nx))/(Ny);
		
		fmp[I][J].x=fmp[I][J-1].x;
		
		rhobaixo=fmrho[I][J-1].x;
		
		Ci=rhobaixo*fmu[I][J-1].x;
		Di=rhobaixo*fmv[I][J-1].x;
		
		htwall=gama_*((poo)/((gama_-1)*rhooo))+0.5*((Ci*Ci+Di*Di)/(rhooo*rhooo));
		
		
		t1=4.0*(gama_*gama_)*fmp[I][J].x*fmp[I][J].x;
		t1=sqrt(t1+8.0*htwall*(gama_-1.0)*(gama_-1.0)*(Ci*Ci+Di*Di));
		t1=2.0*(gama_)*fmp[I][J].x+t1;
		fmrho[I][J].x=(t1)/(4.0*(gama_-1.0)*htwall);
		
		if(((gama_*fmp[I][J].x)/(fmrho[I][J].x))<1.0e-15)
		{
		    printf("\n     A velocidade nao eh real         \n");
		    getchar();
		}
		
		fma[I][J].x=sqrt(((gama_*fmp[I][J].x)/(fmrho[I][J].x)));
		
		t1=((fma[I][J].x)*(fma[I][J].x))/(gama_*(gama_-1.0));
		fmet[I][J].x=t1+0.5*((fmu[I][J].x*fmu[I][J].x)+(fmv[I][J].x*fmv[I][J].x));
	
	    }
/*----------- Parede de cima fim ----------------*/	    	    
	    

/*-------------- Parede de baixo  ---------------*/
	    if(J==1)
	    {   
		Nxcima=mN[I-1][J-1+1].x;
		Nycima=mN[I-1][J-1+1].y;
		
		ucima=fmu[I][2].x;
		vcima=fmv[I][2].x;

		
		t1=Nxcima*ucima+Nycima*vcima;
		t2=sqrt(Nxbaixo*Nxcima+Nycima*Nycima);
		Vnncima=t1/t2;

		t1=Nycima*ucima-Nxcima*vcima;
		t2=sqrt(Nxcima*Nxcima+Nycima*Nycima);
		Vtncima=t1/t2;

		/* norma da velocidade de cima */
		t1=sqrt((Vnncima*Vnncima)+(Vtncima*Vtncima));
		
		/* velocidade com normal a superficie zero e tangencial*/
		/* de mesmo modulo que a logo acima */
		fmu[I][J].x=(Sgn(Vtncima)*t1*Ny)/(sqrt((Nx*Nx)+(Ny*Ny)));
		fmv[I][J].x=((fmu[IM][J].x)*(-Nx))/(Ny);	

/*		
		if(I==112&&J==1)
		{
		  printf("\ncondfronterira        fmu[I][J].x=%lf   fmv[I][J].x=%lf                      \n",fmu[I][J].x,fmv[I][J].x);
		  
		}
*/		
		
		/*pressao igual a de cima*/
		fmp[I][J].x=fmp[I][2].x;
		rhocima=fmrho[I][2].x;
		
		Ci=rhocima*fmu[I][2].x;
		Di=rhocima*fmv[I][2].x;

		
		
		htwall=gama_*((poo)/((gama_-1)*rhooo))+0.5*((Ci*Ci+Di*Di)/(rhooo*rhooo));

		
		
		t1=4.0*(gama_*gama_)*fmp[I][J].x*fmp[I][J].x;
		t1=sqrt(t1+8.0*htwall*(gama_-1.0)*(gama_-1.0)*(Ci*Ci+Di*Di));
		t1=2.0*(gama_)*fmp[I][J].x+t1;
		fmrho[I][J].x=(t1)/(4.0*(gama_-1.0)*htwall);
		
		
		if(((gama_*fmp[I][J].x)/(fmrho[I][J].x))<1.0e-15)
		{
		    printf("\n     A velocidade nao eh real         \n");
		    getchar();
		}
		
		fma[I][J].x=sqrt(((gama_*fmp[I][J].x)/(fmrho[I][J].x)));
		
		t1=((fma[I][J].x)*(fma[I][J].x))/(gama_*(gama_-1.0));
		fmet[I][J].x=t1+0.5*((fmu[I][J].x*fmu[I][J].x)+(fmv[I][J].x*fmv[I][J].x));		
	    }
/*----------- Parede de baixo fim  --------------*/	



/*-------------- Inflow entao devemos ter Vne<0 -*/
	    if(I==1)
	    {
	      
	      	t1=Ex*u+Ey*v;
		t2=sqrt(Ex*Ex+Ey*Ey);
		Vne=t1/t2;

		t1=Ey*u-Ex*v;
		t2=sqrt(Ex*Ex+Ey*Ey);
		Vte=t1/t2;

		t1=Ny*u-Nx*v;
		t2=sqrt(Nx*Nx+Ny*Ny);
		Vtn=t1/t2;

		t1=Nx*u+Ny*v;
		t2=sqrt(Nx*Nx+Ny*Ny);
		Vnn=t1/t2;
		
		
		Vne=-Abs(Vne);
		
		l1=Vne+aoo;
		
		if (l1<1.0e-15)
		{
		    fmu[0][J].x=uoo;
		    fmv[0][J].x=voo;
		    fmp[0][J].x=poo;
		    fmrho[0][J].x=rhooo;
		    fmet[0][J].x=etoo;		    
		}
		else
		{
		    ue=2.0*fmu[1][J].x-fmu[2][J].x;
		    ve=2.0*fmv[1][J].x-fmv[2][J].x;
		    pe=2.0*fmp[1][J].x-fmp[2][J].x;
		    rhoe=2.0*fmrho[1][J].x-fmrho[2][J].x;
		    ae=sqrt((gama_)*((pe)/(rhoe)));
				    
		    t1=Ex*ue+Ey*ve;
		    t2=sqrt(Ex*Ex+Ey*Ey);
		    Vne=t1/t2;

		    t1=Ey*ue-Ex*ve;
		    t2=sqrt(Ex*Ex+Ey*Ey);
		    Vte=t1/t2;

		    t1=Ny*ue-Nx*ve;
		    t2=sqrt(Nx*Nx+Ny*Ny);
		    Vtn=t1/t2;

		    t1=Nx*ue+Ny*ve;
		    t2=sqrt(Nx*Nx+Ny*Ny);
		    Vnn=t1/t2;
		    
		    Rmais=Vne+((2.0*ae)/(gama_-1.0));
		    

		    
		    t1=Ex*uoo+Ey*voo;
		    t2=sqrt(Ex*Ex+Ey*Ey);
		    Vne=t1/t2;

    		    t1=Ey*uoo-Ex*voo;
		    t2=sqrt(Ex*Ex+Ey*Ey);
		    Vte=t1/t2;


		    Rmenos=Vne-((2.0*aoo)/(gama_-1.0));
		    
		    
		    Vne=0.5*(Rmais+Rmenos);
		    
		    
		    t1=Vne*sqrt(Ex*Ex+Ey*Ey);
		    t2=Vte*sqrt(Ex*Ex+Ey*Ey);
		    ue=((t1/Ex)+((Ey*t2)/(Ex*Ex)))/(1.0 + ((Ey*Ey)/(Ex*Ex)));
		    ve=((Ex*ue)-(t2))/(Ex);
		    fmu[0][J].x=ue;
		    fmv[0][J].x=ve;
		    
		    
		    ae=(0.25)*(gama_-1.0)*(Rmais-Rmenos);
		    
		    rhoe=(pe)/(ctegas*Too);
		    pe=(ae*ae*rhoe)/(gama_);
		    
		    fmrho[0][J].x=rhoe;
		    
		    aux1=((ae)*(ae))/(gama_*(gama_-1.0));
		    fmet[0][J].x=aux1+0.5*((ue*ue)+(ve*ve));
		}
	    }
/*----------- Final do Inflow  ------------------*/	    	    




/*------ Outflow entao devemos ter Vne>0 --------*/
	    if(I==IM)
	    {
	      
	      	t1=Ex*u+Ey*v;
		t2=sqrt(Ex*Ex+Ey*Ey);
		Vne=t1/t2;

		t1=Ey*u-Ex*v;
		t2=sqrt(Ex*Ex+Ey*Ey);
		Vte=t1/t2;

		t1=Ny*u-Nx*v;
		t2=sqrt(Nx*Nx+Ny*Ny);
		Vtn=t1/t2;

		t1=Nx*u+Ny*v;
		t2=sqrt(Nx*Nx+Ny*Ny);
		Vnn=t1/t2;

		
		Vne=Abs(Vne);
		
		l2=Vne-aoo;
		
		if (l2>1.0e-15)
		{
		    ue=2.0*fmu[IM][J].x-fmu[IM-1][J].x;
		    
		
		    
		    ve=2.0*fmv[IM][J].x-fmv[IM-1][J].x;
		    pe=2.0*fmp[IM][J].x-fmp[IM-1][J].x;
		    rhoe=2.0*fmrho[IM][J].x-fmrho[IM-1][J].x;
		    ete=2.0*fmet[IM][J].x-fmet[IM-1][J].x;
		    ae=sqrt((gama_)*((pe)/(rhoe)));
				    
		    fmu[IM+1][J].x=ue;
		    fmv[IM+1][J].x=ve;
		    fmp[IM+1][J].x=pe;
		    fmrho[IM+1][J].x=rhoe;
		    fmet[IM+1][J].x=ete;
		    
		    t1=Ex*ue+Ey*ve;
		    t2=sqrt(Ex*Ex+Ey*Ey);
		    Vne=t1/t2;

		    t1=Ey*ue-Ex*ve;
		    t2=sqrt(Ex*Ex+Ey*Ey);
		    Vte=t1/t2;

		    t1=Ny*ue-Nx*ve;
		    t2=sqrt(Nx*Nx+Ny*Ny);
		    Vtn=t1/t2;

		    t1=Nx*ue+Ny*ve;
		    t2=sqrt(Nx*Nx+Ny*Ny);
		    Vnn=t1/t2;
		    
		    Rmais=Vne+((2.0*ae)/(gama_-1.0));
		    Rmenos=Vne-((2.0*ae)/(gama_-1.0));
		}
		else
		{
		    printf("\n      entrou aqui outflow       \n");
		    getchar();
		    getchar();
		    
		    ue=2.0*fmu[IM][J].x-fmu[IM-1][J].x;
		    ve=2.0*fmv[IM][J].x-fmv[IM-1][J].x;
		    pe=2.0*fmp[IM][J].x-fmp[IM-1][J].x;
		    rhoe=2.0*fmrho[IM][J].x-fmrho[IM-1][J].x;
		    ae=sqrt((gama_)*((pe)/(rhoe)));
				    
		    t1=Ex*ue+Ey*ve;
		    t2=sqrt(Ex*Ex+Ey*Ey);
		    Vne=t1/t2;

		    t1=Ey*ue-Ex*ve;
		    t2=sqrt(Ex*Ex+Ey*Ey);
		    Vte=t1/t2;

		    t1=Ny*ue-Nx*ve;
		    t2=sqrt(Nx*Nx+Ny*Ny);
		    Vtn=t1/t2;

		    t1=Nx*ue+Ny*ve;
		    t2=sqrt(Nx*Nx+Ny*Ny);
		    Vnn=t1/t2;
		    
		    Rmais=Vne+((2.0*ae)/(gama_-1.0));
		    

		    
		    t1=Ex*uoo+Ey*voo;
		    t2=sqrt(Ex*Ex+Ey*Ey);
		    Vne=t1/t2;

		    Rmenos=Vne-((2.0*aoo)/(gama_-1.0));
		    
		    
		    Vne=0.5*(Rmais+Rmenos);
		    
		    
		    t1=Vne*sqrt(Ex*Ex+Ey*Ey);
		    t2=Vte*sqrt(Ex*Ex+Ey*Ey);
		    ue=((t1/Ex)+((Ey*t2)/(Ex*Ex)))/(1.0 + ((Ey*Ey)/(Ex*Ex)));
		    ve=((Ex*ue)-(t2))/(Ex);
		    fmu[IM+1][J].x=ue;
		    fmv[IM+1][J].x=ve;
		    
		    
		    ae=(0.25)*(gama_-1.0)*(Rmais-Rmenos);
		    
		    rhoe=(pe)/(ctegas*Too);
		    pe=(ae*ae*rhoe)/(gama_);
		}
	    }
/*----------- Final do outflow  -----------------*/	    
	    


	}
    }
    
}
/*-------------------------------------------------------*/




/*-------------------------------------------------------*/
/*           Atualiza os valores em Eb e Fb              */
/*-------------------------------------------------------*/
void atualizaValores(unsigned int IM,unsigned int JM,
		     vetor **Eb,vetor **Fb,vetor **Qb,
       		     grade **mJ,grade **mN,grade **mE,
	           grade **fma,double gama,grade **mu,
		     grade **mv,grade **mp,
		     grade **mrho,grade **met,grade **fmu,
		  grade **fmv,grade **fmp,grade **fmrho,
		   grade **fmet,vetor **Ebfront,vetor **Fbfront,
		     vetor **Qampliado)
{
	unsigned int I,J;
	double rho,u,v,p,et;
	double Jacob,Ex,Ey,Nx,Ny;
	double e1,e2,e3,e4;
	double f1,f2,f3,f4;
	double q1,q2,q3,q4;
	double a;
	
	

	for(I=1;I<=IM;I++)
	{
		for(J=1;J<=JM;J++)
		{
			Jacob=mJ[I-1][J-1].x;
			Ex=mE[I-1][J-1].x;
			Ey=mE[I-1][J-1].y;
			Nx=mN[I-1][J-1].x;
			Ny=mN[I-1][J-1].y;
					
			rho=(Qb[I-1][J-1].v[1-1])*(Jacob);
			if((rho>1.0e-15)||(-rho>1.0e-15))
			{
				u=(Qb[I-1][J-1].v[2-1]*Jacob)/(rho);
				v=(Qb[I-1][J-1].v[3-1]*Jacob)/(rho);
				et=(Qb[I-1][J-1].v[4-1]*Jacob)/(rho);
			}
			else
			{
				printf("\n && O valor de rho=%lf eh zero Jacob=%lf \n",rho,Jacob);
				printf("\n I=%d  J=%d \n",I,J);
				getchar();
				getchar();
			
			}
			if((((et-0.5*(u*u+v*v))*(gama*(gama-1.0))))<1.0e-15)
			{
			   if(J==1||J==JM)
			   {
			      a=100000000;/* esse valor serah corrigido pela funcao condfronteira que estah dentro dessa funcao */
			   }
			   else
			   {
			     
				printf("\n      A aceleracao nao eh um valor real valor=%lf  u=%lf   v=%lf  et=%lf  \n",((et-0.5*(u*u+v*v))*(gama*(gama-1.0))),u,v,et);
				printf("\n      I=%d  J=%d  \n",I,J); 
				getchar();
			   }
			}
			a=sqrt(((et-0.5*(u*u+v*v))*(gama*(gama-1.0))));/*paginas 172 e 102 do cap 12*/
			p=(a*a*rho)/gama;
			
			mu[I-1][J-1].x=u;
			mv[I-1][J-1].x=v;			
			mp[I-1][J-1].x=p;
			mrho[I-1][J-1].x=rho;
			met[I-1][J-1].x=et;
			

			fmu[I][J].x=u;
			fmv[I][J].x=v;			
			fmp[I][J].x=p;
			fmrho[I][J].x=rho;
			fmet[I][J].x=et;
			fma[I][J].x=a;
			
			/*vetor E*/
			e1=rho*u;
			e2=rho*u*u+p;
			e3=rho*u*v;
			e4=(rho*et+p)*u;
			
			/*vetor F*/
			f1=rho*v;
			f2=rho*v*u;
			f3=rho*v*v+p;
			f4=(rho*et+p)*v;		

			/*vetor Q*/
			q1=rho;
			q2=rho*u;
			q3=rho*v;
			q4=rho*et;			
			

			Qampliado[I][J].v[1-1]=q1;
			Qampliado[I][J].v[2-1]=q2;
			Qampliado[I][J].v[3-1]=q3;
			Qampliado[I][J].v[4-1]=q4;


			Eb[I-1][J-1].v[1-1]=(Ex*e1+Ey*f1)/(Jacob);
			Eb[I-1][J-1].v[2-1]=(Ex*e2+Ey*f2)/(Jacob);
			Eb[I-1][J-1].v[3-1]=(Ex*e3+Ey*f3)/(Jacob);
			Eb[I-1][J-1].v[4-1]=(Ex*e4+Ey*f4)/(Jacob);
		
			Fb[I-1][J-1].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
			Fb[I-1][J-1].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
			Fb[I-1][J-1].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
			Fb[I-1][J-1].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);
		}
	}	
	
	condfronteira(IM,JM,mN,mE,fmu,fmv,fmp,fmrho,fmet,fma);


	
	for(I=1;I<=IM;I++)
	{
		for(J=1;J<=JM;J++)
		{
			
			Jacob=mJ[I-1][J-1].x;
			Ex=mE[I-1][J-1].x;
			Ey=mE[I-1][J-1].y;
			Nx=mN[I-1][J-1].x;
			Ny=mN[I-1][J-1].y;
					

			u=fmu[I][J].x;
			v=fmv[I][J].x;			
			p=fmp[I][J].x;
			rho=fmrho[I][J].x;
			et=fmet[I][J].x;
			
/*		if(I==112&&J==1)
		{
		  printf("\n atualizando        fmu[I][J].x=%lf   fmv[I][J].x=%lf                      \n",fmu[I][J].x,fmv[I][J].x);
		  
		}			
*/			
			
			mu[I-1][J-1].x=u;
			mv[I-1][J-1].x=v;			
			mp[I-1][J-1].x=p;
			
			
			
			mrho[I-1][J-1].x=rho;
			met[I-1][J-1].x=et;

			
			/*vetor E*/
			e1=rho*u;
			e2=rho*u*u+p;
			e3=rho*u*v;
			e4=(rho*et+p)*u;
			
			/*vetor F*/
			f1=rho*v;
			f2=rho*v*u;
			f3=rho*v*v+p;
			f4=(rho*et+p)*v;		
			
			/*vetor Q*/
			q1=rho;
			q2=rho*u;
			q3=rho*v;
			q4=rho*et;			

			Qampliado[I][J].v[1-1]=q1;
			Qampliado[I][J].v[2-1]=q2;
			Qampliado[I][J].v[3-1]=q3;
			Qampliado[I][J].v[4-1]=q4;			
			
			Eb[I-1][J-1].v[1-1]=(Ex*e1+Ey*f1)/(Jacob);
			Eb[I-1][J-1].v[2-1]=(Ex*e2+Ey*f2)/(Jacob);
			Eb[I-1][J-1].v[3-1]=(Ex*e3+Ey*f3)/(Jacob);
			Eb[I-1][J-1].v[4-1]=(Ex*e4+Ey*f4)/(Jacob);
		
			Fb[I-1][J-1].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
			Fb[I-1][J-1].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
			Fb[I-1][J-1].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
			Fb[I-1][J-1].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);

			Ebfront[I][J].v[1-1]=(Ex*e1+Ey*f1)/(Jacob);
			Ebfront[I][J].v[2-1]=(Ex*e2+Ey*f2)/(Jacob);
			Ebfront[I][J].v[3-1]=(Ex*e3+Ey*f3)/(Jacob);
			Ebfront[I][J].v[4-1]=(Ex*e4+Ey*f4)/(Jacob);
		
			Fbfront[I][J].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
			Fbfront[I][J].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
			Fbfront[I][J].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
			Fbfront[I][J].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);
			
			/*vetor Qb*/
			Qb[I-1][J-1].v[1-1]=(q1)/(Jacob);
			Qb[I-1][J-1].v[2-1]=(q2)/(Jacob);
			Qb[I-1][J-1].v[3-1]=(q3)/(Jacob);
			Qb[I-1][J-1].v[4-1]=(q4)/(Jacob);

		}
	}		
	
	
	
	for(J=1;J<=JM;J++)
	{		
		Jacob=2.0*mJ[0][J-1].x-mJ[1][J-1].x;
		Ex=2.0*mE[0][J-1].x-mE[1][J-1].x;
		Ey=2.0*mE[0][J-1].y-mE[1][J-1].y;
		Nx=2.0*mN[0][J-1].x-mN[1][J-1].x;
		Ny=2.0*mN[0][J-1].y-mN[1][J-1].y;
				
		u=fmu[0][J].x;
		v=fmv[0][J].x;			
		p=fmp[0][J].x;
		rho=fmrho[0][J].x;
		et=fmet[0][J].x;
		
		/*vetor E*/
		e1=rho*u;
		e2=rho*u*u+p;
		e3=rho*u*v;
		e4=(rho*et+p)*u;
		
		/*vetor F*/
		f1=rho*v;
		f2=rho*v*u;
		f3=rho*v*v+p;
		f4=(rho*et+p)*v;		
		
		/*vetor Q*/
		q1=rho;
		q2=rho*u;
		q3=rho*v;
		q4=rho*et;			
		
		Qampliado[0][J].v[1-1]=q1;
		Qampliado[0][J].v[2-1]=q2;
		Qampliado[0][J].v[3-1]=q3;
		Qampliado[0][J].v[4-1]=q4;		
		
		Ebfront[0][J].v[1-1]=(Ex*e1+Ey*f1)/(Jacob);
		Ebfront[0][J].v[2-1]=(Ex*e2+Ey*f2)/(Jacob);
		Ebfront[0][J].v[3-1]=(Ex*e3+Ey*f3)/(Jacob);
		Ebfront[0][J].v[4-1]=(Ex*e4+Ey*f4)/(Jacob);
	
		Fbfront[0][J].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
		Fbfront[0][J].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
		Fbfront[0][J].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
		Fbfront[0][J].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);
		
		/*Ebfront[2][J].v[1-1]=Ebfront[0][J].v[1-1];
		Ebfront[2][J].v[2-1]=Ebfront[0][J].v[2-1];
		Ebfront[2][J].v[3-1]=Ebfront[0][J].v[3-1];
		Ebfront[2][J].v[4-1]=Ebfront[0][J].v[4-1];*/
		
	
		
		
		
		Jacob=2.0*mJ[IM-1][J-1].x-mJ[IM-2][J-1].x;
		Ex=2.0*mE[IM-1][J-1].x-mE[IM-2][J-1].x;
		Ey=2.0*mE[IM-1][J-1].y-mE[IM-2][J-1].y;
		Nx=2.0*mN[IM-1][J-1].x-mN[IM-2][J-1].x;
		Ny=2.0*mN[IM-1][J-1].y-mN[IM-2][J-1].y;
				
		u=fmu[IM+1][J].x;
		v=fmv[IM+1][J].x;			
		p=fmp[IM+1][J].x;
		rho=fmrho[IM+1][J].x;
		et=fmet[IM+1][J].x;
		a=sqrt(((et-0.5*(u*u+v*v))*(gama*(gama-1.0))));
		
		/*vetor E*/
		e1=rho*u;
		e2=rho*u*u+p;
		e3=rho*u*v;
		e4=(rho*et+p)*u;
		
		/*vetor F*/
		f1=rho*v;
		f2=rho*v*u;
		f3=rho*v*v+p;
		f4=(rho*et+p)*v;	
		
		/*vetor Q*/
		q1=rho;
		q2=rho*u;
		q3=rho*v;
		q4=rho*et;			
		
		Qampliado[IM+1][J].v[1-1]=q1;
		Qampliado[IM+1][J].v[2-1]=q2;
		Qampliado[IM+1][J].v[3-1]=q3;
		Qampliado[IM+1][J].v[4-1]=q4;				
		
		Ebfront[IM+1][J].v[1-1]=(Ex*e1+Ey*f1)/(Jacob);
		Ebfront[IM+1][J].v[2-1]=(Ex*e2+Ey*f2)/(Jacob);
		Ebfront[IM+1][J].v[3-1]=(Ex*e3+Ey*f3)/(Jacob);
		Ebfront[IM+1][J].v[4-1]=(Ex*e4+Ey*f4)/(Jacob);
	
		Fbfront[IM+1][J].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
		Fbfront[IM+1][J].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
		Fbfront[IM+1][J].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
		Fbfront[IM+1][J].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);
		
		fma[IM+1][J].x=a;
		
	}
	

	for(I=1;I<=IM;I++)
	{		
		/*parede de cima */
		Fbfront[I][JM+1].v[1-1]=Fbfront[I][JM-1].v[1-1];
		Fbfront[I][JM+1].v[2-1]=Fbfront[I][JM-1].v[2-1];
		Fbfront[I][JM+1].v[3-1]=Fbfront[I][JM-1].v[3-1];
		Fbfront[I][JM+1].v[4-1]=Fbfront[I][JM-1].v[4-1];
		
		Qampliado[I][JM+1].v[1-1]=Qampliado[I][JM-1].v[1-1];
		Qampliado[I][JM+1].v[2-1]=Qampliado[I][JM-1].v[2-1];
		Qampliado[I][JM+1].v[3-1]=Qampliado[I][JM-1].v[3-1];
		Qampliado[I][JM+1].v[4-1]=Qampliado[I][JM-1].v[4-1];		
		
		/*parede de baixo */
		Fbfront[I][0].v[1-1]=Fbfront[I][2].v[1-1];
		Fbfront[I][0].v[2-1]=Fbfront[I][2].v[2-1];
		Fbfront[I][0].v[3-1]=Fbfront[I][2].v[3-1];
		Fbfront[I][0].v[4-1]=Fbfront[I][2].v[4-1];
		
		Qampliado[I][0].v[1-1]=Qampliado[I][2].v[1-1];
		Qampliado[I][0].v[2-1]=Qampliado[I][2].v[2-1];
		Qampliado[I][0].v[3-1]=Qampliado[I][2].v[3-1];
		Qampliado[I][0].v[4-1]=Qampliado[I][2].v[4-1];		
		
		u=fmu[I][0].x;
		v=fmv[I][0].x;			
		p=fmp[I][0].x;
		rho=fmrho[I][0].x;
		et=fmet[I][0].x;
		a=sqrt(((et-0.5*(u*u+v*v))*(gama*(gama-1.0))));

		fma[I][0].x=a;
			
		u=fmu[I][JM+1].x;
		v=fmv[I][JM+1].x;			
		p=fmp[I][JM+1].x;
		rho=fmrho[I][JM+1].x;
		et=fmet[I][JM+1].x;
		a=sqrt(((et-0.5*(u*u+v*v))*(gama*(gama-1.0))));

		fma[I][JM+1].x=a;
	}  
	
	
	
	
}
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*       Valcula as derivadas no met rk                  */
/*-------------------------------------------------------*/
void calculaDerivadas(unsigned int IM,unsigned int JM,
		      vetor **Eb,vetor **Fb,
		      vetor **DerivEb,vetor **DerivFb,
		      vetor **Ebfront,vetor **Fbfront)
{
	unsigned int I,J,k;
	
	
/*	printf("\n derivadas Ebfront[110+1][1].v[1-1] =%lf \n",Ebfront[110+1][1].v[1-1]);
	printf("\n Ebfront[I+1][J].v[k-1]=%lf     Ebfront[I-1][J].v[k-1]=%lf  \n",Ebfront[110+1][1].v[1-1],Ebfront[110-1][1].v[1-1]);*/
	for(I=1;I<=IM;I++)
	{
	    for(J=1;J<=JM;J++)
	    {
		for(k=1;k<=4;k++)
		{
		     DerivEb[I-1][J-1].v[k-1]=(Ebfront[I+1][J].v[k-1]-Ebfront[I-1][J].v[k-1])/(2.0);
		     DerivFb[I-1][J-1].v[k-1]=(Fbfront[I][J+1].v[k-1]-Fbfront[I][J-1].v[k-1])/(2.0);
	/*	     
		     if(I==112&&J==1)
		     {
		     
		     printf("\n    Ebfront[I+1][J].v[k-1]=%lf     Ebfront[I-1][J].v[k-1]=%lf   \n",Ebfront[I+1][J].v[k-1],Ebfront[I-1][J].v[k-1]);
		     		     printf("\n    Ebfront[I+1][J].v[k-1]-Ebfront[I-1][J].v[k-1]=%lf   \n",Ebfront[I+1][J].v[k-1]-Ebfront[I-1][J].v[k-1]);
		     printf("\n    Fbfront[I][J+1].v[k-1]=%lf     Fbfront[I][J-1].v[k-1]=%lf   \n",Fbfront[I][J+1].v[k-1],Fbfront[I][J-1].v[k-1]);
		     printf("\n    Fbfront[I][J+1].v[k-1]-Fbfront[I][J-1].v[k-1]=%lf   \n",Fbfront[I][J+1].v[k-1]-Fbfront[I][J-1].v[k-1]);
		     printf("\n    diferenca=%lf     I=%d   J=%d   \n",DerivEb[I-1][J-1].v[k-1]+DerivFb[I-1][J-1].v[k-1],I,J);
		     
		     }*/
		    
		}
	     }
	}	
	
	
/*	
	for(I=2;I<=IM-1;I++)
	{
	    for(k=1;k<=4;k++)
	    {
		  DerivEb[I-1][JM-1].v[k-1]=2.0*DerivEb[I-1][JM-1-1].v[k-1]-DerivEb[I-1][JM-1-2].v[k-1];
		  DerivFb[I-1][JM-1].v[k-1]=2.0*DerivFb[I-1][JM-1-1].v[k-1]-DerivFb[I-1][JM-1-2].v[k-1];
		  
		  DerivEb[I-1][1-1].v[k-1]=2.0*DerivEb[I-1][1-1+1].v[k-1]-DerivEb[I-1][1-1+2].v[k-1];
		  DerivFb[I-1][1-1].v[k-1]=2.0*DerivFb[I-1][1-1+1].v[k-1]-DerivFb[I-1][1-1+2].v[k-1];		  
	    }	  
	}
	for(J=1;J<=JM;J++)
	{
	    for(k=1;k<=4;k++)
	    {
		  DerivEb[IM-1][J-1].v[k-1]=2.0*DerivEb[IM-1-1][J-1].v[k-1]-DerivEb[IM-1-2][J-1].v[k-1];
		  DerivFb[IM-1][J-1].v[k-1]=2.0*DerivFb[IM-1-1][J-1].v[k-1]-DerivFb[IM-1-2][J-1].v[k-1];
		  
		  DerivEb[1-1][1-1].v[k-1]=2.0*DerivEb[1-1+1][1-1].v[k-1]-DerivEb[1-1+2][1-1].v[k-1];
		  DerivFb[1-1][1-1].v[k-1]=2.0*DerivFb[1-1+1][1-1].v[k-1]-DerivFb[1-1+2][1-1].v[k-1];		  
	    }	  
	}	
	*/
}
/*-------------------------------------------------------*/




/*-------------------------------------------------------*/
/*  Libera  memoria da alocacao dinamica (matriz double) */
/*-------------------------------------------------------*/
void Liberar_matriz_real_Double (unsigned int m, unsigned int n, double **v)
{
 
	unsigned int i; /* variavel auxiliar */
 
	if (m>0)
		for (i=0; i<m; i++)
	{              
		free (v[i]); /* libera as linhas da matriz */
	}
 
	free (v); /* libera a matriz (vetor de ponteiros) */
 
	/*  return (NULL);  retorna um ponteiro nulo */
}   
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/
 
 
/*-------------------------------------------------------*/
/*              Aloca memoria para matrizes              */
/*-------------------------------------------------------*/
double **NewMatrixDouble (unsigned int linha, unsigned int coluna) 
{
	int x, y;
    
	double ** matrix;
    
	/* Allocate pointer memory for the first dimension of a matrix[][]; */
	matrix = (double **) malloc(coluna * sizeof(double *));
	if(NULL == matrix)
	{
		free(matrix); 
		printf("A alocacao falhou, malloc devolveu NULL!\n Finalizando.\n"); 
		exit(-1);
	}

	/* Allocate integer memory for the second dimension of a matrix[][]; */
	for(x = 0; x < coluna; x++)
	{
		matrix[x] = (double *) malloc(linha * sizeof(double));
		if(NULL == matrix[x])
		{
			free(matrix[x]);
			printf("A alocacao falhou, malloc devolveu NULL!\n Finalizando.\n");
			exit(-1);
		}
	}
	/* Iterate through matrix (thru-row-first). */
	/* Initialize matrix to be filled with 0's. */
	for(y = 0; y < linha; y++)
		for(x = 0; x < coluna; x++)
			matrix[x][y]=0.0;
    
	return matrix;

}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*  Libera  memoria da alocacao dinamica (matriz double) */
/*-------------------------------------------------------*/
void LiberarGrade (unsigned int m,unsigned int n,grade **v)
{
 
	unsigned int i; /* variavel auxiliar */
 
	if (m>0)
		for (i=0; i<m; i++)
	{              
		free (v[i]); /* libera as linhas da matriz */
	}
 
	free (v); /* libera a matriz (vetor de ponteiros) */
 
	/*  return (NULL);  retorna um ponteiro nulo */
}   
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/


/*-------------------------------------------------------*/
/*  Libera  memoria da alocacao dinamica Mvetor */
/*-------------------------------------------------------*/
void LiberarMvetor (unsigned int m,unsigned int n,vetor **v)
{
 
	unsigned int i; /* variavel auxiliar */
 
	if (m>0)
		for (i=0; i<m; i++)
	{              
		free (v[i]); /* libera as linhas da matriz */
	}
 
	free (v); /* libera a matriz (vetor de ponteiros) */
 
	/*  return (NULL);  retorna um ponteiro nulo */
}   
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/
 

/*-------------------------------------------------------*/
/*  Libera  memoria da alocacao dinamica (matriz double) */
/*-------------------------------------------------------*/
void LiberarX16vetor(unsigned int m,unsigned int n,vetorX16 **v)
{
 
	unsigned int i; /* variavel auxiliar */
 
	if (m>0)
		for (i=0; i<m; i++)
	{              
		free (v[i]); /* libera as linhas da matriz */
	}
 
	free (v); /* libera a matriz (vetor de ponteiros) */
 
	/*  return (NULL);  retorna um ponteiro nulo */
}   
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*              Aloca memoria para grade                 */
/*-------------------------------------------------------*/
grade **NewMatrixGrade (unsigned int coluna,unsigned int linha) 
{
	int x, y;
	grade **matrix;  
	
	/* Allocate pointer memory for the first dimension of a matrix[][]; */
	matrix = (grade **) malloc(coluna * sizeof(grade *));
	if(NULL == matrix)
	{
		free(matrix); 
		printf("A alocacao falhou, malloc devolveu NULL!\n Finalizando.\n"); 
		exit(-1);
	}
	
	/* Allocate integer memory for the second dimension of a matrix[][]; */
	for(x = 0; x < coluna; x++)
	{
		matrix[x] = (grade *) malloc(linha * sizeof(grade));
		if(NULL == matrix[x])
		{
			free(matrix[x]);
			printf("A alocacao falhou, malloc devolveu NULL!\n Finalizando.\n");
			exit(-1);
		}
	}
	/* Iterate through matrix (thru-row-first). */
	/* Initialize matrix to be filled with 0's. */
	for(y = 0; y < linha; y++)
	{
		for(x = 0; x < coluna; x++)
		{
			matrix[x][y].x=0.0;
			matrix[x][y].y=0.0;	
		}
	}
	return matrix;

}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/


/*-------------------------------------------------------*/
/* Aloca memoria p/ matrizes cujos elementos sao vetores */
/*-------------------------------------------------------*/
vetor **NewMatrixVetor (unsigned int coluna,unsigned int linha) 
{
	int x, y, i;
	vetor **matrix;  
	
	/* Allocate pointer memory for the first dimension of a matrix[][]; */
	matrix = (vetor **) malloc(coluna * sizeof(vetor *));
	if(NULL == matrix)
	{
		free(matrix); 
		printf("A alocacao falhou, malloc devolveu NULL!\n Finalizando.\n"); 
		exit(-1);
	}
	
	/* Allocate integer memory for the second dimension of a matrix[][]; */
	for(x = 0; x < coluna; x++)
	{
		matrix[x] = (vetor *) malloc(linha * sizeof(vetor));
		if(NULL == matrix[x])
		{
			free(matrix[x]);
			printf("A alocacao falhou, malloc devolveu NULL!\n Finalizando.\n");
			exit(-1);
		}
	}
	/* Iterate through matrix (thru-row-first). */
	/* Initialize matrix to be filled with 0's. */
	for(y = 0; y < linha; y++)
	{
		for(x = 0; x < coluna; x++)
		{
		  for(i=0;i<=3;i++)
		  {
			matrix[x][y].v[i]=0.0;
		  }
		}
	}
	return matrix;

}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/* Aloca memoria p/ matrizes cujos elementos sao vetores */
/*-------------------------------------------------------*/
vetorX16 **NewMatrixvetorX16 (unsigned int coluna,unsigned int linha) 
{
	int x, y, i,j;
	vetorX16 **matrix;  
	
	/* Allocate pointer memory for the first dimension of a matrix[][]; */
	matrix = (vetorX16 **) malloc(coluna * sizeof(vetorX16 *));
	if(NULL == matrix)
	{
		free(matrix); 
		printf("A alocacao falhou, malloc devolveu NULL!\n Finalizando.\n"); 
		exit(-1);
	}
	
	/* Allocate integer memory for the second dimension of a matrix[][]; */
	for(x = 0; x < coluna; x++)
	{
		matrix[x] = (vetorX16 *) malloc(linha * sizeof(vetorX16));
		if(NULL == matrix[x])
		{
			free(matrix[x]);
			printf("A alocacao falhou, malloc devolveu NULL!\n Finalizando.\n");
			exit(-1);
		}
	}
	/* Iterate through matrix (thru-row-first). */
	/* Initialize matrix to be filled with 0's. */
	for(y = 0; y < linha; y++)
	{
		for(x = 0; x < coluna; x++)
		{
		  for(i=1;i<=4;i++)
		  {
		    for(j=1;j<=4;j++)
		    {
			matrix[x][y].Xa[i-1][j-1]=0.0;
			matrix[x][y].Xainv[i-1][j-1]=0.0;
			matrix[x][y].Xb[i-1][j-1]=0.0;
			matrix[x][y].Xbinv[i-1][j-1]=0.0;
		    }
		  }
		}
	}
	return matrix;
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*  Libera  memoria da alocacao dinamica (vetor double)  */
/*-------------------------------------------------------*/
double *Liberar_vetor_real_Double (double *v)
{
	if (v == NULL)
	{
		return (NULL);
	}
	free(v); /* libera o vetor */
	v = NULL;
	return (NULL); /* retorna o ponteiro */
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*           Alocacao dinamica (vetor double)            */
/*-------------------------------------------------------*/
double *mallocXdouble (unsigned int max) 
{
	double *ptr;
	unsigned int i;
	ptr = (double *) malloc(max * sizeof (double));
	if (ptr == NULL) 
	{
		printf ("A alocacao falhou, malloc devolveu NULL!\n Finalizando.");
		exit (EXIT_FAILURE);
	}
	for (i = 0; i < max; i++ )
	{
		ptr[i] = 0;
	}
	return ptr;
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*                 Funcao Potenciacao                    */
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/
/*                        A^(x)                          */
/*-------------------------------------------------------*/
double potencia(double A,double x)
{
	double resposta;
	
	resposta=exp(x*log(A));
	
	return resposta;
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/


/*-------------------------------------------------------*/
/*                Clustering function                    */
/*-------------------------------------------------------*/
double fclustering(double L,/*comprimento do dom fisico */
		   double B,  /*parametro de cluster    */
     double Etha/*n=0.0 ateh n=1.0*/)
{
	double temp01,temp02,temp03,temp04,temp05,temp06;

	temp01=(B+1.0)/(B-1.0);
	temp02=Etha;
	temp03=potencia(temp01,temp02);

	
	temp04=temp03-1.0;
	temp05=temp03+1.0;

	if((temp05>=1.0e-15)||(-temp05<=1.0e-15))
	{

		temp06=1.0-B*(temp04/temp05);
	}
	else
	{
		printf("\n\nDivisao por zero em x"); 
		printf(" temp05: %lf \n\n",temp05);
		printf(" temp03: %lf \n\n",temp03);
		printf(" L:%lf  B:%lf  Etha:%lf \n\n",L,B,Etha);
		printf(" temp01:%lf  temp02:%lf  temp03:%lf \n\n",temp01,temp02,temp03);								

		getchar();
	}
	
	return L*temp06;
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/


/*-------------------------------------------------------*/
/*               Abrindo arquivo saida                   */
/*-------------------------------------------------------*/

int OUTPUT(FILE **OUP, int numero)
{
	char filename[300];
    
	strcpy(filename,"./Estimativas/file");/*inicializa string name*/
	/*strcpy(filename, "/home/wellington/Documentos/GeracaodeMalhas/out/Estimativa");*/
	sprintf(filename, "%s%d", filename, numero);/*adiciona o numero da estimativa*/
	strcat(filename,".dat");/*adiciona texto ao final da string name*/


	*OUP = fopen(filename, "w");
	if(*OUP == NULL)
	{
		printf("ERRO NO ARQUIVO DE SAIDA LOCALIZACAO 02");
		getchar();
		exit(-1);
	}
		
	return 0;
}   
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*                     Graficando                        */
/*-------------------------------------------------------*/
void Graficando(int n, double x0, double xf,int numero)
{
	int j,i;
 
	FILE *out;
	char str[350], cmd[300], filename[300];

	for(j=1;j<2;j++)
	{

		strcpy(str, "/afs/labmap.ime.usp.br/usr/wcjesus/BibliotecaGeral/CFD/EDPNumericaLuis/EP02/GeracaodeMalhas/out/comandos_saida_gnuplot.txt");
/*		strcpy(str, "/home/wellington/Documentos/GeracaodeMalhas/out/comandos_saida_gnuplot.txt");*/

		sprintf(cmd, "gnuplot %s", str);/*comando do gnuplot para Linux*/
		/*    sprintf(cmd,"wgnuplot.exe %s", str); comando do gnuplot para Windows*/

		strcpy(filename, "Estimativa");
		sprintf(filename, "%s%d", filename, numero);/*adiciona o numero da estimativa*/
		strcat(filename,".dat");/*adiciona texto ao final da string name*/
    

		out = fopen(str, "w");
		if(out == NULL)
		{
			printf("ERRO NO ARQUIVO DE SAIDA LOCALIZACAO 01");
			getchar();
			exit(-1);
		}
    
		/*fprintf(out, "set size square\nset grid");*/

		/*    fprintf(out, "set parametric\n"); // usado quando plotamos uma curva parametrica*/

		/* tamanho da tela onde sera plotado*/
		/*fprintf(out, "set xrange [%lf:%lf]\n", -3.0, 243.0); 
		fprintf(out, "set yrange [%lf:%lf]\n", -3.0, 133.0); */

		/*	fprintf(out, "plot cos(t), sin(t) w l 1 ");*/




		/*fprintf(out, "cd '/home/wellington/Documentos/CFD/EP_EDP_Luis'");*/
		/*fprintf(out, "cd '/afs/labmap.ime.usp.br/usr/wcjesus/BibliotecaGeral/CFD/EDPNumericaLuis/EP02/GeracaodeMalhas/out/'");*/
		fprintf(out, "/home/wellington/Documentos/GeracaodeMalhas/out");
		for (i=0;i<=numero;i++)
		{	  
			if(i>0)fprintf(out,",");
			if(i==0)fprintf(out,"\nset nokey ");
			if(i==0)fprintf(out,"\nplot ");	
			fprintf(out, "'Estimativa%d.txt'using 1:2 w l %d",i,7);
		}
		fprintf(out, " \npause mouse \"Clique em algum lugar do grafico para sair\"\n");
		fprintf(out, "pause mouse \"Clique em algum lugar do grafico para sair\"\n");
				fprintf(out, " \npause mouse \"Clique em algum lugar do grafico para sair\"\n");
		fprintf(out, "pause mouse \"Clique em algum lugar do grafico para sair\"\n");
				fprintf(out, " \npause mouse \"Clique em algum lugar do grafico para sair\"\n");
		fprintf(out, "pause mouse \"Clique em algum lugar do grafico para sair\"\n");
				fprintf(out, " \npause mouse \"Clique em algum lugar do grafico para sair\"\n");
		fprintf(out, "pause mouse \"Clique em algum lugar do grafico para sair\"\n");
				fprintf(out, " \npause mouse \"Clique em algum lugar do grafico para sair\"\n");
		fprintf(out, "pause mouse \"Clique em algum lugar do grafico para sair\"\n");

		fclose(out);


		system(cmd);
    //system("echo rodarodaroda");
	}

}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*                Geracao de malha                       */
/*-------------------------------------------------------*/
void geramalha(double L, /*comprimento do canal*/
	       double H, /*altura do canal*/
	double B, /*parametros de cluster largura*/
 double B1, /*parametros de cluster altura*/
 double E, /*comp L no dominio comput*/
 double N, /*alt H no dominio comput*/	       
 double *x,/*vetor na dir x*/
 double *Ei,/*vetor na dir x no dom comput*/
 double *y,/*vetor na dir y*/
 double *Ni,/*vetor na dir y no dom comput*/               
 unsigned int IM,/*ultimo indice na dir x*/
 unsigned int JM /*ultimo indice na dir y*/)
{
	unsigned int i;
	double temp01,temp02,temp03,temp04,temp05,temp06;

	temp01=(B+1.0)/(B-1.0);
	for(i=1;i<=IM;i++)
	{
		temp02=1.0-(Ei[i]/E);
		temp03=potencia(temp01,temp02);
		temp04=temp03-1.0;
		temp05=temp03+1.0;
		if((temp05>=1.0e-15)||(-temp05<=1.0e-15))
		{
			temp06=1.0-B*(temp04/temp05);
			x[i]=L-L*temp06;
		}
		else
		{
			printf("\n\nDivisao por zero em x"); 
			printf(" temp05: %lf \n\n",temp05);
			getchar();
		}
	}
	temp01=(B1+1.0)/(B1-1.0);
	for(i=1;i<=JM;i++)
	{
		temp02=2.0*((Ni[i]/N)-1.0);
		temp03=potencia(temp01,temp02);
		temp04=(1.0+B1)*temp03+1.0-B1;
		temp05=temp03+1.0;
		if((temp05>=1.0e-15)||(-temp05<=1.0e-15))
		{
			temp06=1.0-B*(temp04/temp05);
			y[i]=(H/2.0)*temp06;
		}
		else
		{
			printf("\n\nDivisao por zero em y"); 
			printf("temp05: %lf \n\n",temp05);
			getchar();
		}
	}
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/
/*                Geracao de malha completo              */
/*-------------------------------------------------------*/
void geramalhaa(grade **dxy,
		/*vetor dxy(i,j).x e dxy(i,j).y do dom fisico*/
		grade **den,
  /*vetor den(i,j).x e den(i,j).y do dom comput*/
  double *phe,/*Delta E do dom comput*/               
  double *phn,/*Delta N do dom comput*/
  unsigned int IM,/*ultimo indice na dir x*/
  unsigned int JM /*ultimo indice na dir y*/)
{
	unsigned int i,j,I1,I2,I4;
	double L1,L2,L3,L4,L5,L,alpha,he,hn;
	double E1,E2,E3,E4,E5,N1,H1,H2;
	double CompX,CompY;
	double hx,hy;

	L1=10.0;
	L2=20.0;
	L3=40.0;
	L4=28.0;
	L5=42.0;
	H1=20.0;
	alpha=10.0;/*angulo em graus da inclinacao*/
	H2=H1-tan((alpha*pi)/180.0)*L2;
	L=L1+L2+L3;	

	IM=241;
	JM=131;
	I1=21;
	I2=90;
	I4=61;

	E1=I1*1.0;
	E2=I2*1.0;
	E3=(IM-I1-I2)*1.0;
	E4=I4*1.0;
	E5=(IM-I4)*1.0;
	N1=JM*1.0;

	he=1.0;
	hn=1.0;	
	hx=L/(IM-1);
	hy=H1/(JM-1);

	
	
	
	
	for(i=1;i<=IM;i++)
	{
		for(j=1;j<=JM;j++)
		{
			den[i-1][j-1].x=(i-1)*he;
			den[i-1][j-1].y=(j-1)*hn;
		}
	}
	
	/* Contorno superior e inferior para x*/
	/* Contorno superior para y e parte do inferior*/
	for(i=1;i<=IM;i++)
	{
		dxy[i-1][JM-1].x=(i-1)*hx;
		dxy[i-1][0].x=(i-1)*hx;
	
		dxy[i-1][JM-1].y=(JM-1)*hy;
		dxy[i-1][0].y=0.0;
	}
	
	/* Contorno inferior de y para E1<=E<=E1+E2*/	
	for(i=36;i<=103;i++)
	{
		dxy[i-1][0].y=tan((alpha*pi)/180.0)*(dxy[i-1][0].x-L1);	
	}
	
	/* Contorno inferior de y para E1+E2<=E<=L*/	
	for(i=104;i<=IM;i++)
	{
		dxy[i-1][0].y=tan((alpha*pi)/180.0)*(L2);	
	}
	
	for(i=1;i<=IM;i++)
	{
		for(j=2;j<JM;j++)
		{
			CompX=dxy[i-1][JM-1].x-dxy[i-1][0].x;
			CompY=dxy[i-1][JM-1].y-dxy[i-1][0].y;
			dxy[i-1][j-1].x=dxy[i-1][0].x+(CompX)*((j-1.0)/(JM-1));
			dxy[i-1][j-1].y=dxy[i-1][0].y+(CompY)*((j-1.0)/(JM-1));
		}
	}
	
	*phe=he;
	*phn=hn;

}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*             Geracao de malha com vetor                */
/*-------------------------------------------------------*/
void geramalhab(double L, /*comprimento do canal*/
		double H, /*altura do canal (maior medida)*/
  grade **c,/*vetor c(i,j).x e c(i,j).y do dom fisico*/
  double *Ei,/*vetor na dir x no dom comput*/
  double *Ni,/*vetor na dir y no dom comput*/               
  double *Hi,/*vet diametro y do dom comput*/               
  unsigned int IM,/*ultimo indice na dir x*/
  unsigned int JM /*ultimo indice na dir y*/)
{
	unsigned int i,j,I1,I2,I4;
	double L1,L2,L3,L4,L5,B1,B2,B3,B4,B5,B6;
	double E1,E2,E3,E4,E5,N1,Etha,H1,H2,He,Hn;
	double alpha,B7,B8,B9;
	double temp,Hx,Hy,CompX,CompY;
	double y,b0,a1,a0,b1,mm;

	L1=10.0;
	L2=20.0;
	L3=40.0;
	L4=28.0;
	L5=42.0;
	H1=20.0;
	alpha=10.0;/*angulo em graus da inclinacao*/
	H2=H1-tan((alpha*pi)/180.0)*L2;
	L=L1+L2+L3;	

	IM=241;
	JM=131;
	I1=21;
	I2=90;
	I4=61;

	E1=I1*1.0;
	E2=I2*1.0;
	E3=(IM-I1-I2)*1.0;
	E4=I4*1.0;
	E5=(IM-I4)*1.0;
	N1=JM*1.0;
	
	B1=2.0;
	B2=5.0;
	B3=1.1;
	B4=2.0;
	B5=1.2;
	B6=2.0;
	B7=1.7;
	B8=2.0;
	B9=2.0;

	He=1.0;
	for (i=1;i<=IM;i++) 
	{
		Ei[i-1]=(i-1)*He;
		/*printf("\nEi[%d]=%lf\n",i-1,Ei[i-1]);*/
	}	
	
	Hn=1.0;
	for (i=1;i<=JM;i++) 
	{
		Ni[i-1]=(i-1)*Hn;
	}
	temp=L2/(2.0*cos((alpha*pi)/180.0));		
	for(i=1;i<=IM;i++)
	{
		/*Trecho 01) 1 <= i <= I1 */
		if((1<=i)&&(i<=I1))
		{
			Etha=1.0-(Ei[i-1]/(E1-1.0));
			/*printf("\n Ei[i-1]=%lf    E1=%lf    Ei[I1]=%lf  i=%d  He=%lf  Etha=%lf\n",Ei[i-1],E1,Ei[I1],i,He,Etha);*/
			
			c[i-1][0].x=fclustering(L1,B1,Etha);
			
			/*printf("\n c[%d][0].x=%lf   Etha=%lf   Ei[%d]=%lf \n",i-1,c[i-1][0].x,Etha,i-1,Ei[i-1]);*/
			
			
			c[i-1][0].y=0.0;
			
		}
		
		/*Trecho 02) I1 <= i <=  I1 + I2/2 */	
		
		if((I1<i)&&(i<=I1+(I2/2)))
		{
			Etha=1.0-2.0*((1.0+Ei[i-1]-E1)/(E2));
			c[i-1][0].x=fclustering(temp,B2,Etha);
			c[i-1][0].x=L1+cos((alpha*pi)/180.0)*c[i-1][0].x;
			/*printf("\n I) c[%d][0].x=%lf    E1=%lf    Ei[i-1]=%lf  i=%d  He=%lf  Etha=%lf\n",i-1,c[i-1][0].x,E1,Ei[i-1],i,He,Etha);*/
			/*printf("\n I) c[%d][0].x=%lf    Etha=%lf  \n",i-1,c[i-1][0].x,Etha);*/
			
			c[i-1][0].y=tan((alpha*pi)/180.0)*(c[i-1][0].x-L1);
		}	
		
		/*Trecho 03) I1 + I2/2 <= i <= I1 + I2 */	
		if(((I1+(I2/2))<i)&&(i<=I1+I2))
		{
			Etha=1.0-2.0*((1.0+Ei[i-1]-E1-(E2/2.0))/(E2));
			c[i-1][0].x=fclustering(temp,B7,Etha);
			c[i-1][0].x=L1+(L2/2.0)+cos((alpha*pi)/180.0)*c[i-1][0].x;
			/*printf("\n II) c[%d][0].x=%lf    E1=%lf    Ei[i-1]=%lf  i=%d  He=%lf  Etha=%lf\n",i-1,c[i-1][0].x,E1,Ei[i-1],i,He,Etha);*/
			/*printf("\nEi[%d]=%lf\n",i-1,Ei[i-1]);*/
			/*printf("\n II) c[%d][0].x=%lf    Etha=%lf\n",i-1,c[i-1][0].x,Etha);*/
			c[i-1][0].y=c[I1+(I2/2)-1][0].y+tan((alpha*pi)/180.0)*(c[i-1][0].x-L1-L2/2.0);
			
		}
		/*Trecho 04) I1 + I2 <= i <= IM */	
		
		if(((I1+I2)<i)&&(i<=IM))
		{	
			Etha=1.0-((Ei[i-1]-E1-E2+1.0)/(E3));
			c[i-1][0].x=L1+L2+fclustering(L3,B3,Etha);	
/*			printf("\n III) c[%d][0].x=%lf    E1=%lf    Ei[i-1]=%lf  i=%d  He=%lf  Etha=%lf\n",i-1,c[i-1][0].x,E1,Ei[i-1],i,He,Etha);*/
			/*printf("\n III) c[%d][0].x=%lf    Etha=%lf\n",i-1,c[i-1][0].x,Etha);*/
					
			c[i-1][0].y=H1-H2;
			
			
		}
	}

	for(i=1;i<=IM;i++)
	{
		/*Trecho 05) 1 <= i <= I4 */	
		if((1<=i)&&(i<=I4))
		{
			Etha=1.0-((Ei[i-1])/(E4));
			c[i-1][JM-1].x=fclustering(L4,B4,Etha);
			/*printf("\n  Etha=%lf   Ei[%d]=%lf   c[i-1][JM-1].x=%lf \n",Etha,i-1,Ei[i-1],c[i-1][JM-1].x);*/
			c[i-1][JM-1].y=H1;
			/*printf("\n Ei[%d]=%lf\n",i-1,Ei[i-1]);*/
			/*printf("\n IV) c[%d][JM-1].x=%lf    Etha=%lf\n",i-1,c[i-1][JM-1].x,Etha);*/
			
		}
		/*Trecho 06) I4 <= i <= IM */	
		if((I4<i)&&(i<=IM))
		{
			Etha=1.0-((Ei[i-1]-E4)/(E5));
			c[i-1][JM-1].x=L4+fclustering(L5,B5,Etha);
			/*printf("\n  Etha=%lf   Ei[%d]=%lf   c[i-1][JM-1].x=%lf \n",Etha,i-1,Ei[i-1],c[i-1][JM-1].x);*/
			c[i-1][JM-1].y=H1;
			/*printf("\n V) c[%d][JM-1].x=%lf    Etha=%lf\n",i-1,c[i-1][JM-1].x,Etha);*/
		
		}
	}
	printf("\n\nsaiu do loop inicial \n\n");
	for(i=1;i<=IM;i++)
	{
		/*Calculando a distancia entre os xi de mesmo i*/
		temp=pow(c[i-1][0].x-c[i-1][JM-1].x,2.0);
		temp=temp+pow(c[i-1][0].y-c[i-1][JM-1].y,2.0);
		Hi[i-1]=sqrt(temp);
		/*printf("\n\nvalor de Hi[%d]=%lf ",i-1,Hi[i-1]);
		getchar();*/
	}
	for(i=1;i<=IM;i++)
	{
		for(j=2;j<JM;j++)
		{
			CompX=c[i-1][JM-1].x-c[i-1][0].x;
			CompY=c[i-1][JM-1].y-c[i-1][0].y;
			c[i-1][j-1].x=c[i-1][0].x+(CompX)*((j-1.0)/(JM-1));
			c[i-1][j-1].y=c[i-1][0].y+(CompY)*((j-1.0)/(JM-1));
		}

	}
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*-------------------------------------------------------*/


/*-------------------------------------------------------*/
/*               Gera arquivo para plotar                */
/*-------------------------------------------------------*/
void arqmalha(double A, double B, int N, FILE **OUP)
{ 

	unsigned int I,J,k;
	double Hx,Ht;
	double L,H,*Ei,*Ni,*Hi;
	grade **c;/*vetor c(i,j).x e c(i,j).y do dom fisico*/
	unsigned int IM;/*ultimo indice na dir x*/
	unsigned int JM;/*ultimo indice na dir y*/

	L=70.0;	

	IM=241;
	JM=131;
   
	c=NewMatrixGrade (IM,JM);


	Ei=mallocXdouble (241);
	Ni=mallocXdouble (131);
	Hi=mallocXdouble (241);
	geramalhab(L,H,c,Ei,Ni,Hi,IM,JM);
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
		
	if (1==1) 
	{
		OUTPUT(OUP,0);
		fprintf(*OUP, "t \t y\n");      

		for (I=1; I<=IM; I++) 
		{
			fprintf(*OUP, "%5.3f %11.7f \n",c[I-1][0].x,c[I-1][0].y);
		}
		
		/* STEP 5 */
		fclose(*OUP);
		OUTPUT(OUP,1);
		fprintf(*OUP, "t \t y\n");      

		for (I=1; I<=IM; I++) 
		{
			fprintf(*OUP, "%5.3f %11.7f  \n",c[I-1][JM-1].x,c[I-1][JM-1].y);
		}
		/* STEP 5 */
      
		fclose(*OUP);
		OUTPUT(OUP,2);
		fprintf(*OUP, "t \t y\n");      

		for (I=1; I<=JM; I++) 
		{
			fprintf(*OUP, "%5.3f %11.7f \n",c[0][0].x,c[0][I-1].y);
		}
		/* STEP 5 */
      
      
		fclose(*OUP);
      
		OUTPUT(OUP,3);
		fprintf(*OUP, "t \t y\n");      

		for (I=1; I<=JM; I++) 
		{
			fprintf(*OUP, "%5.3f %11.7f\n",c[IM-1][JM-1].x,c[IM-1][I-1].y);
		}
		/* STEP 5 */ 
		fclose(*OUP);
      
          
      
		for(I=2;I<IM;I++)
		{
			OUTPUT(OUP,I+2);      
			for (J=1; J<=JM; J++) 
			{
				fprintf(*OUP, "%5.3f %11.7f\n",c[I-1][J-1].x,c[I-1][J-1].y);
			}
			fclose(*OUP);      
		}

		for(J=2;J<JM;J++)
		{
			OUTPUT(OUP,J+IM);      
			for (I=1; I<=IM; I++) 
			{
				fprintf(*OUP, "%5.3f %11.7f\n",c[I-1][J-1].x,c[I-1][J-1].y);
			}
			fclose(*OUP);      
		}
      
      
      
		/*Graficando( N, A, B,JM+IM-1);*/
		
		
	}
   
	Liberar_vetor_real_Double (Ei);
	Liberar_vetor_real_Double (Ni);   
	Liberar_vetor_real_Double (Hi);   	
	LiberarGrade (IM,JM,c);	
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/
/*               Gera arquivo para plotar                */
/*-------------------------------------------------------*/
void arqmalha02(double A, double B, int N, FILE **OUP)
{ 

	unsigned int I,J;
	double he,hn;				;
	double L,H,*Ei,*Ni,*Hi;
	grade **dxy, **den;/*vetores dom fisico e comput*/
	unsigned int IM;/*ultimo indice na dir x*/
	unsigned int JM; /*ultimo indice na dir y*/
		
	L=70.0;	

	IM=241;
	JM=131;
   
	dxy=NewMatrixGrade (IM,JM);
	den=NewMatrixGrade (IM,JM);


	Ei=mallocXdouble (241);
	Ni=mallocXdouble (131);
	Hi=mallocXdouble (241);
	geramalhaa(dxy,den,&he,&hn,IM,JM);
		
	/*----------------------------------------------------------------*/
	OUTPUT(OUP,0);
	fprintf(*OUP, "t \t y\n");      
	for (I=1; I<=IM; I++) 
	{
		fprintf(*OUP, "%5.3f %11.7f \n",dxy[I-1][0].x,dxy[I-1][0].y);
	}
	fclose(*OUP);
	/*----------------------------------------------------------------*/
	
	/*----------------------------------------------------------------*/
	OUTPUT(OUP,1);
	fprintf(*OUP, "t \t y\n");      
	for (I=1; I<=IM; I++) 
	{
		fprintf(*OUP, "%5.3f %11.7f \n",dxy[I-1][JM-1].x,dxy[I-1][JM-1].y);
	}
	fclose(*OUP);
	/*----------------------------------------------------------------*/
	
	/*----------------------------------------------------------------*/
	OUTPUT(OUP,2);
	fprintf(*OUP, "t \t y\n");      
	for (I=1; I<=JM; I++) 
	{
		fprintf(*OUP, "%5.3f %11.7f \n",dxy[0][0].x,dxy[0][I-1].y);
	}
	fclose(*OUP);
	/*----------------------------------------------------------------*/
	
	
	/*----------------------------------------------------------------*/
	OUTPUT(OUP,3);
	fprintf(*OUP, "t \t y\n");      
	for (I=1; I<=JM; I++) 
	{
		fprintf(*OUP, "%5.3f %11.7f \n",dxy[IM-1][JM-1].x,dxy[IM-1][I-1].y);
	}
	fclose(*OUP);
	/*----------------------------------------------------------------*/
	
	
	for(I=2;I<IM;I++)
	{
		OUTPUT(OUP,I+2);      
		for (J=1; J<=JM; J++) 
		{
			fprintf(*OUP, "%5.3f %11.7f \n",dxy[I-1][J-1].x,dxy[I-1][J-1].y);
		}
		fclose(*OUP);      
	}

	for(J=2;J<JM;J++)
	{
		OUTPUT(OUP,J+IM);      
		for (I=1; I<=IM; I++) 
		{
			fprintf(*OUP, "%5.3f %11.7f \n",dxy[I-1][J-1].x,dxy[I-1][J-1].y);
		}
		fclose(*OUP);      
	}
      
      
      
	/*Graficando( N, A, B,JM+IM-1);*/
	
	printf("\nvalor de he=%lf  total=%lf\n",he,he*(IM-1));
	printf("\nvalor de hn=%lf  total=%lf\n",hn,hn*(JM-1));
	
	Liberar_vetor_real_Double (Ei);
	Liberar_vetor_real_Double (Ni);   
	Liberar_vetor_real_Double (Hi);   	
	LiberarGrade (IM,JM,den);	
	LiberarGrade (IM,JM,dxy);	
}
/*-------------------------------------------------------*/
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*           Computa as matrizes de autovetores          */
/*-------------------------------------------------------*/
void compMAutovetores(unsigned int IM,unsigned int JM,
		      vetorX16 **X,vetor **Qb,grade **mJ,
			grade **mN,grade **mE,grade **fma,
		      double gama,grade **fmu,grade **fmv,
		      grade **fmp,grade **fmrho,
		      grade **fmet)
{
	unsigned int I,J;
	double rho,u,v,p,et,a;
	double Jacob,Ex,Ey,Nx,Ny;
	double e11,e12,e13,e14;
	double e21,e22,e23,e24;
	double e31,e32,e33,e34;
	double e41,e42,e43,e44;
	double t1,t2,t3,t4,t5,t6,t7,t8;
	
	
	
	for(I=0;I<=IM+1;I++)
	{
	    for(J=1;J<=JM;J++)
	    {
		if((I!=0)&&(I!=IM+1))
		{
		  Jacob=mJ[I-1][J-1].x;
		  Ex=mE[I-1][J-1].x;
		  Ey=mE[I-1][J-1].y;
		  Nx=mN[I-1][J-1].x;
		  Ny=mN[I-1][J-1].y;
		}

		if(I==0)
		{
		  Jacob=2.0*mJ[I][J-1].x-mJ[I+1][J-1].x;
		  Ex=2.0*mE[I][J-1].x-mE[I+1][J-1].x;;
		  Ey=2.0*mE[I][J-1].y-mE[I+1][J-1].y;
		  Nx=2.0*mN[I][J-1].x-mN[I+1][J-1].x;
		  Ny=2.0*mN[I][J-1].y-mN[I+1][J-1].y;	      
		}

		if(I==IM+1)
		{
		  Jacob=2.0*mJ[IM-1][J-1].x-mJ[IM-2][J-1].x;
		  Ex=2.0*mE[IM-1][J-1].x-mE[IM-2][J-1].x;;
		  Ey=2.0*mE[IM-1][J-1].y-mE[IM-2][J-1].y;
		  Nx=2.0*mN[IM-1][J-1].x-mN[IM-2][J-1].x;
		  Ny=2.0*mN[IM-1][J-1].y-mN[IM-2][J-1].y;	      
		}
		
				
		rho=fmrho[I][J].x;		
		u=fmu[I][J].x;
		v=fmv[I][J].x;
		et=fmet[I][J].x;

		a=fma[I][J].x;
		p=fmp[I][J].x;
		
		if((Abs(Ex))>1.0e-15)
		{
		    t1=u*Ex+v*Ey;
		    t4=Ex*Ex+Ey*Ey;
		    t2=sqrt(t4);
		    t6=u*u+v*v;
		    t3=((t6)/(2.0))+((a*a)/(gama-1.0));
		    t5=gama-1.0;
		    t7=(1.0-gama)/(2.0*a*a);
		  
		    /*Matriz de Autovalores Xa*/
		    e11=0.0;
		    e12=e13=e14=1.0;
		    
		    e21=-Ey/Ex;
		    e22=t1/Ex;
		    e23=u+((a*Ex)/(t2));
		    e24=u-((a*Ex)/(t2));
		    
		    e31=1.0;
		    e32=0.0;
		    e33=v+((a*Ey)/(t2));
		    e34=v-((a*Ey)/(t2));
		    
		    e41=(v*Ex-u*Ey)/Ex;
		    e42=((2.0*u*v*Ey)+((u*u-v*v)*Ex))/(2.0*Ex);
		    e43=(t3)+((a*t1)/(t2));
		    e44=(t3)-((a*t1)/(t2));
		    
		    X[I][J].Xa[1-1][1-1]=e11;
		    X[I][J].Xa[1-1][2-1]=e12;
		    X[I][J].Xa[1-1][3-1]=e13;
		    X[I][J].Xa[1-1][4-1]=e14;
		    
		    X[I][J].Xa[2-1][1-1]=e21;
		    X[I][J].Xa[2-1][2-1]=e22;
		    X[I][J].Xa[2-1][3-1]=e23;
		    X[I][J].Xa[2-1][4-1]=e24;
		    
		    X[I][J].Xa[3-1][1-1]=e31;
		    X[I][J].Xa[3-1][2-1]=e32;
		    X[I][J].Xa[3-1][3-1]=e33;
		    X[I][J].Xa[3-1][4-1]=e34;
		    
		    X[I][J].Xa[4-1][1-1]=e41;
		    X[I][J].Xa[4-1][2-1]=e42;
		    X[I][J].Xa[4-1][3-1]=e43;
		    X[I][J].Xa[4-1][4-1]=e44;

		    /*Matriz de Autovalores Xa^(-1)*/
		    e11=(t7*v*t6)+((Ey*t1)/(t4));
		    e12=((t5*u*v)/(a*a))-((Ex*Ey)/(t4));
		    e13=((t5*v*v)/(a*a))+((Ex*Ex)/(t4));
		    e14=-(t5*v)/(a*a);
		    
		    e21=1.0+(t7*t6);
		    e22=(t5*u)/(a*a);
		    e23=(t5*v)/(a*a);
		    e24=-(t5)/(a*a);
		    
		    e31=(-(t7*t6)/(2.0))-((t1)/(2.0*a*t2));
		    e32=(t7*u)+((Ex)/(2.0*a*t2));
		    e33=(t7*v)+((Ey)/(2.0*a*t2));
		    e34=(t5)/(2.0*a*a);
		    
		    e41=((t5*t6)/(4.0*a*a))+((t1)/(2.0*a*t2));
		    e42=(t7*u)-((Ex)/(2.0*a*t2));
		    e43=(t7*v)-((Ey)/(2.0*a*t2));
		    e44=(t5)/(2.0*a*a);
		    
		    X[I][J].Xainv[1-1][1-1]=e11;
		    X[I][J].Xainv[1-1][2-1]=e12;
		    X[I][J].Xainv[1-1][3-1]=e13;
		    X[I][J].Xainv[1-1][4-1]=e14;
		    
		    X[I][J].Xainv[2-1][1-1]=e21;
		    X[I][J].Xainv[2-1][2-1]=e22;
		    X[I][J].Xainv[2-1][3-1]=e23;
		    X[I][J].Xainv[2-1][4-1]=e24;
		    
		    X[I][J].Xainv[3-1][1-1]=e31;
		    X[I][J].Xainv[3-1][2-1]=e32;
		    X[I][J].Xainv[3-1][3-1]=e33;
		    X[I][J].Xainv[3-1][4-1]=e34;
		    
		    X[I][J].Xainv[4-1][1-1]=e41;
		    X[I][J].Xainv[4-1][2-1]=e42;
		    X[I][J].Xainv[4-1][3-1]=e43;
		    X[I][J].Xainv[4-1][4-1]=e44;		    
		}/*final do if Ex dif de zero*/
		else
		{
		    t1=u*Ex+v*Ey;
		    t4=Ex*Ex+Ey*Ey;
		    t2=sqrt(t4);
		    t6=u*u+v*v;
		    t3=((t6)/(2.0))+((a*a)/(gama-1.0));
		    t5=gama-1.0;
		    t7=(1.0-gama)/(2.0*a*a);
		  
		    e11=0.0;
		    e12=e13=e14=1.0;
		    
		    e21=1.0;
		    e22=0.0;
		    e23=u;
		    e24=u;
		    
		    e31=0.0;
		    e32=v;
		    e33=v+a;
		    e34=v-a;
		    
		    e41=u;
		    e42=(v*v-u*u)/(2.0);
		    e43=((a*a)/(t5))+((u*u+v*v+2.0*a*v)/(2.0));
		    e44=((a*a)/(t5))+((u*u+v*v-2.0*a*v)/(2.0));
		    
		    X[I][J].Xa[1-1][1-1]=e11;
		    X[I][J].Xa[1-1][2-1]=e12;
		    X[I][J].Xa[1-1][3-1]=e13;
		    X[I][J].Xa[1-1][4-1]=e14;
		    
		    X[I][J].Xa[2-1][1-1]=e21;
		    X[I][J].Xa[2-1][2-1]=e22;
		    X[I][J].Xa[2-1][3-1]=e23;
		    X[I][J].Xa[2-1][4-1]=e24;
		    
		    X[I][J].Xa[3-1][1-1]=e31;
		    X[I][J].Xa[3-1][2-1]=e32;
		    X[I][J].Xa[3-1][3-1]=e33;
		    X[I][J].Xa[3-1][4-1]=e34;
		    
		    X[I][J].Xa[4-1][1-1]=e41;
		    X[I][J].Xa[4-1][2-1]=e42;
		    X[I][J].Xa[4-1][3-1]=e43;
		    X[I][J].Xa[4-1][4-1]=e44;

		    e11=-((t5)*(u*u*u+u*v*v))/(2.0*a*a);
		    e12=(1.0)+((t5*u*u)/(a*a));
		    e13=(t5*u*v)/(a*a);
		    e14=-(t5*u)/(a*a);
		    
		    e21=1.0-((t5*t6)/(2.0*a*a));
		    e22=(t5*u)/(a*a);
		    e23=(t5*v)/(a*a);
		    e24=-(t5*u)/(a*a);
		    
		    e31=((t5*t6-2.0*a*v)/(4.0*a*a));
		    e32=-(t5*u)/(2.0*a*a);
		    e33=(a-t5*v)/(2.0*a*a);
		    e34=(t5)/(2.0*a*a);
		    
		    e41=((t5*t6+2.0*a*v)/(4.0*a*a));
		    e42=-(t5*u)/(2.0*a*a);
		    e43=-(a+t5*v)/(2.0*a*a);
		    e44=(t5)/(2.0*a*a);

		    X[I][J].Xainv[1-1][1-1]=e11;
		    X[I][J].Xainv[1-1][2-1]=e12;
		    X[I][J].Xainv[1-1][3-1]=e13;
		    X[I][J].Xainv[1-1][4-1]=e14;
		    
		    X[I][J].Xainv[2-1][1-1]=e21;
		    X[I][J].Xainv[2-1][2-1]=e22;
		    X[I][J].Xainv[2-1][3-1]=e23;
		    X[I][J].Xainv[2-1][4-1]=e24;
		    
		    X[I][J].Xainv[3-1][1-1]=e31;
		    X[I][J].Xainv[3-1][2-1]=e32;
		    X[I][J].Xainv[3-1][3-1]=e33;
		    X[I][J].Xainv[3-1][4-1]=e34;
		    
		    X[I][J].Xainv[4-1][1-1]=e41;
		    X[I][J].Xainv[4-1][2-1]=e42;
		    X[I][J].Xainv[4-1][3-1]=e43;
		    X[I][J].Xainv[4-1][4-1]=e44; 
		}/*final do else*/
		if((Abs(Nx))>1.0e-15)
		{
		    t1=u*Nx+v*Ny;
		    t2=Nx*Nx+Ny*Ny;
		    t3=sqrt(t2);
		    t4=u*u+v*v;
		    t5=t4/2.0;
		    t6=(a*a)/(gama-1.0);
		    t7=gama-1.0;
		    t8=2.0*a*t3;

		    e11=0.0;
		    e12=1.0;
		    e13=1.0;
		    e14=1.0;
			
		    e21=-(Ny)/(Nx);
		    e22=t1/Nx;
		    e23=u+((a*Nx)/(t3));
		    e24=u-((a*Nx)/(t3));
			
		    e31=1.0;
		    e32=0.0;
		    e33=v+((a*Ny)/(t3));
		    e34=v-((a*Ny)/(t3));
			
		    e41=(v*Nx-u*Ny)/(Nx);
		    e42=(2.0*u*v*Ny+(u*u-v*v)*Nx)/(2.0*Nx);
		    e43=(t5+t6)+((a*t1)/(t3));
		    e44=(t5+t6)-((a*t1)/(t3));

		    X[I][J].Xb[1-1][1-1]=e11;
		    X[I][J].Xb[1-1][2-1]=e12;
		    X[I][J].Xb[1-1][3-1]=e13;
		    X[I][J].Xb[1-1][4-1]=e14;
			
		    X[I][J].Xb[2-1][1-1]=e21;
		    X[I][J].Xb[2-1][2-1]=e22;
		    X[I][J].Xb[2-1][3-1]=e23;
		    X[I][J].Xb[2-1][4-1]=e24;
			
		    X[I][J].Xb[3-1][1-1]=e31;
		    X[I][J].Xb[3-1][2-1]=e32;
		    X[I][J].Xb[3-1][3-1]=e33;
		    X[I][J].Xb[3-1][4-1]=e34;
			
		    X[I][J].Xb[4-1][1-1]=e41;
		    X[I][J].Xb[4-1][2-1]=e42;
		    X[I][J].Xb[4-1][3-1]=e43;
		    X[I][J].Xb[4-1][4-1]=e44;
		    
		    e11=(-(t7*v*t4)/(2.0*a*a))+((Ny*t1)/(t2));
		    e12=((t7*u*v)/(a*a))-((Nx*Ny)/(t2));
		    e13=((t7*v*v)/(a*a))+((Nx*Nx)/(t2));
		    e14=-(t7*v)/(a*a);
		    
		    e21=1.0+(((-t7)*t4)/(2.0*a*a));
		    e22=(t7*u)/(a*a);
		    e23=(t7*v)/(a*a);
		    e24=-(t7)/(a*a);
		    
		    e31=((t7*t4)/(4.0*a*a))-((t1)/(t8));
		    e32=(((-t7)*u)/(2.0*a*a))+((Nx)/(t8));
		    e33=(((-t7)*v)/(2.0*a*a))+((Ny)/(t8));
		    e34=(t7)/(2.0*a*a);
		    
		    e41=((t7*t4)/(4.0*a*a))+((t1)/(t8));
		    e42=(((-t7)*u)/(2.0*a*a))-((Nx)/(t8));
		    e43=(((-t7)*v)/(2.0*a*a))-((Ny)/(t8));
		    e44=(t7)/(2.0*a*a);

		    X[I][J].Xbinv[1-1][1-1]=e11;
		    X[I][J].Xbinv[1-1][2-1]=e12;
		    X[I][J].Xbinv[1-1][3-1]=e13;
		    X[I][J].Xbinv[1-1][4-1]=e14;
		    
		    X[I][J].Xbinv[2-1][1-1]=e21;
		    X[I][J].Xbinv[2-1][2-1]=e22;
		    X[I][J].Xbinv[2-1][3-1]=e23;
		    X[I][J].Xbinv[2-1][4-1]=e24;
		    
		    X[I][J].Xbinv[3-1][1-1]=e31;
		    X[I][J].Xbinv[3-1][2-1]=e32;
		    X[I][J].Xbinv[3-1][3-1]=e33;
		    X[I][J].Xbinv[3-1][4-1]=e34;
		    
		    X[I][J].Xbinv[4-1][1-1]=e41;
		    X[I][J].Xbinv[4-1][2-1]=e42;
		    X[I][J].Xbinv[4-1][3-1]=e43;
		    X[I][J].Xbinv[4-1][4-1]=e44;
		}/*  final do if se Nx!=0 */
		else
		{
		    t1=u*Ex+v*Ey;
		    t4=Ex*Ex+Ey*Ey;
		    t2=sqrt(t4);
		    t6=u*u+v*v;
		    t3=((t6)/(2.0))+((a*a)/(gama-1.0));
		    t5=gama-1.0;
		    t7=(1.0-gama)/(2.0*a*a);
		  
		    e11=0.0;
		    e12=e13=e14=1.0;
		    
		    e21=1.0;
		    e22=0.0;
		    e23=u;
		    e24=u;
		    
		    e31=0.0;
		    e32=v;
		    e33=v+a;
		    e34=v-a;
		    
		    e41=u;
		    e42=(v*v-u*u)/(2.0);
		    e43=((a*a)/(t5))+((u*u+v*v+2.0*a*v)/(2.0));
		    e44=((a*a)/(t5))+((u*u+v*v-2.0*a*v)/(2.0));


		    
		    X[I][J].Xb[1-1][1-1]=e11;
		    X[I][J].Xb[1-1][2-1]=e12;
		    X[I][J].Xb[1-1][3-1]=e13;
		    X[I][J].Xb[1-1][4-1]=e14;
		    
		    X[I][J].Xb[2-1][1-1]=e21;
		    X[I][J].Xb[2-1][2-1]=e22;
		    X[I][J].Xb[2-1][3-1]=e23;
		    X[I][J].Xb[2-1][4-1]=e24;
		    
		    X[I][J].Xb[3-1][1-1]=e31;
		    X[I][J].Xb[3-1][2-1]=e32;
		    X[I][J].Xb[3-1][3-1]=e33;
		    X[I][J].Xb[3-1][4-1]=e34;
		    
		    X[I][J].Xb[4-1][1-1]=e41;
		    X[I][J].Xb[4-1][2-1]=e42;
		    X[I][J].Xb[4-1][3-1]=e43;
		    X[I][J].Xb[4-1][4-1]=e44;

		    e11=-((t5)*(u*u*u+u*v*v))/(2.0*a*a);
		    e12=(1.0)+((t5*u*u)/(a*a));
		    e13=(t5*u*v)/(a*a);
		    e14=-(t5*u)/(a*a);
		    
		    e21=1.0-((t5*t6)/(2.0*a*a));
		    e22=(t5*u)/(a*a);
		    e23=(t5*v)/(a*a);
		    e24=-(t5*u)/(a*a);
		    
		    e31=((t5*t6-2.0*a*v)/(4.0*a*a));
		    e32=-(t5*u)/(2.0*a*a);
		    e33=(a-t5*v)/(2.0*a*a);
		    e34=(t5)/(2.0*a*a);
		    
		    e41=((t5*t6+2.0*a*v)/(4.0*a*a));
		    e42=-(t5*u)/(2.0*a*a);
		    e43=-(a+t5*v)/(2.0*a*a);
		    e44=(t5)/(2.0*a*a);

		    X[I][J].Xbinv[1-1][1-1]=e11;
		    X[I][J].Xbinv[1-1][2-1]=e12;
		    X[I][J].Xbinv[1-1][3-1]=e13;
		    X[I][J].Xbinv[1-1][4-1]=e14;
		    
		    X[I][J].Xbinv[2-1][1-1]=e21;
		    X[I][J].Xbinv[2-1][2-1]=e22;
		    X[I][J].Xbinv[2-1][3-1]=e23;
		    X[I][J].Xbinv[2-1][4-1]=e24;
		    
		    X[I][J].Xbinv[3-1][1-1]=e31;
		    X[I][J].Xbinv[3-1][2-1]=e32;
		    X[I][J].Xbinv[3-1][3-1]=e33;
		    X[I][J].Xbinv[3-1][4-1]=e34;
		    
		    X[I][J].Xbinv[4-1][1-1]=e41;
		    X[I][J].Xbinv[4-1][2-1]=e42;
		    X[I][J].Xbinv[4-1][3-1]=e43;
		    X[I][J].Xbinv[4-1][4-1]=e44; 
		}/*final do else*/

		if(I==1191&&J==2)
		{
		    printf("\n  X[I+1][J].Xa[4-1][1-1]=%lf    X[I][J].Xa[4-1][1-1]=%lf  u=%lf   v=%lf  a=%lf  Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf \n",X[I+1][J].Xa[4-1][1-1],X[I][J].Xa[4-1][1-1],u,v,a,Ex,Ey,Nx,Ny);
		    printf("\n  X[I+1][J].Xa[4-1][2-1]=%lf    X[I][J].Xa[4-1][2-1]=%lf  u=%lf   v=%lf  a=%lf  Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n",X[I+1][J].Xa[4-1][1-1],X[I][J].Xa[4-1][2-1],u,v,a,Ex,Ey,Nx,Ny);
		    printf("\n  X[I+1][J].Xa[4-1][3-1]=%lf    X[I][J].Xa[4-1][3-1]=%lf  u=%lf   v=%lf  a=%lf  Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n",X[I+1][J].Xa[4-1][1-1],X[I][J].Xa[4-1][3-1],u,v,a,Ex,Ey,Nx,Ny);
		    printf("\n  X[I+1][J].Xa[4-1][4-1]=%lf    X[I][J].Xa[4-1][4-1]=%lf  u=%lf   v=%lf  a=%lf  Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n",X[I+1][J].Xa[4-1][1-1],X[I][J].Xa[4-1][4-1],u,v,a,Ex,Ey,Nx,Ny);
		     printf("\n Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n",Ex,Ey,Nx,Ny);
		     printf("\n Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n\n\n",mE[I-1][J-1].x,mE[I-1][J-1].y,mN[I-1][J-1].x,mN[I-1][J-1].y);
		}
		     
		if(I==1991&&J==2)
		{
		    printf("\n  X[I+1][J].Xb[4-1][1-1]=%lf    X[I][J].Xb[4-1][1-1]=%lf  u=%lf   v=%lf  a=%lf  Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf \n",X[I+1][J].Xb[4-1][1-1],X[I][J].Xb[4-1][1-1],u,v,a,Ex,Ey,Nx,Ny);
		    printf("\n  X[I+1][J].Xb[4-1][2-1]=%lf    X[I][J].Xb[4-1][2-1]=%lf  u=%lf   v=%lf  a=%lf  Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n",X[I+1][J].Xb[4-1][1-1],X[I][J].Xb[4-1][2-1],u,v,a,Ex,Ey,Nx,Ny);
		    printf("\n  X[I+1][J].Xb[4-1][3-1]=%lf    X[I][J].Xb[4-1][3-1]=%lf  u=%lf   v=%lf  a=%lf  Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n",X[I+1][J].Xb[4-1][1-1],X[I][J].Xb[4-1][3-1],u,v,a,Ex,Ey,Nx,Ny);
		    printf("\n  X[I+1][J].Xb[4-1][4-1]=%lf    X[I][J].Xb[4-1][4-1]=%lf  u=%lf   v=%lf  a=%lf  Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n",X[I+1][J].Xb[4-1][1-1],X[I][J].Xb[4-1][4-1],u,v,a,Ex,Ey,Nx,Ny);
		     printf("\n Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n",Ex,Ey,Nx,Ny);
		     printf("\n Ex=%lf  Ey=%lf  Nx=%lf  Ny=%lf   \n",mE[I-1][J-1].x,mE[I-1][J-1].y,mN[I-1][J-1].x,mN[I-1][J-1].y);
		     
		     getchar();
		}

	    }/*final for em J*/
	}/*final for em I*/
}
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*       Faz a media dos vetors Xa,Xb,Xinva e Xinvb      */
/*-------------------------------------------------------*/
void Xmeio(unsigned int IM,unsigned int JM,vetorX16 **X,
	   vetorX16 **Ximeio,vetorX16 **Xjmeio)
{
	unsigned int I,J,k;
	
	for(I=0;I<=IM;I++)
	{
		for(J=1;J<=JM;J++)
		{
			for(k=1;k<=4;k++)
			{
				Ximeio[I][J].Xa[k-1][1-1]=0.5*(X[I+1][J].Xa[k-1][1-1]+X[I][J].Xa[k-1][1-1]);
				Ximeio[I][J].Xa[k-1][2-1]=0.5*(X[I+1][J].Xa[k-1][2-1]+X[I][J].Xa[k-1][2-1]);
				Ximeio[I][J].Xa[k-1][3-1]=0.5*(X[I+1][J].Xa[k-1][3-1]+X[I][J].Xa[k-1][3-1]);
				Ximeio[I][J].Xa[k-1][4-1]=0.5*(X[I+1][J].Xa[k-1][4-1]+X[I][J].Xa[k-1][4-1]);

				Ximeio[I][J].Xainv[k-1][1-1]=0.5*(X[I+1][J].Xainv[k-1][1-1]+X[I][J].Xainv[k-1][1-1]);
				Ximeio[I][J].Xainv[k-1][2-1]=0.5*(X[I+1][J].Xainv[k-1][2-1]+X[I][J].Xainv[k-1][2-1]);
				Ximeio[I][J].Xainv[k-1][3-1]=0.5*(X[I+1][J].Xainv[k-1][3-1]+X[I][J].Xainv[k-1][3-1]);
				Ximeio[I][J].Xainv[k-1][4-1]=0.5*(X[I+1][J].Xainv[k-1][4-1]+X[I][J].Xainv[k-1][4-1]);
	
				Ximeio[I][J].Xb[k-1][1-1]=0.5*(X[I+1][J].Xb[k-1][1-1]+X[I][J].Xb[k-1][1-1]);
				Ximeio[I][J].Xb[k-1][2-1]=0.5*(X[I+1][J].Xb[k-1][2-1]+X[I][J].Xb[k-1][2-1]);
				Ximeio[I][J].Xb[k-1][3-1]=0.5*(X[I+1][J].Xb[k-1][3-1]+X[I][J].Xb[k-1][3-1]);
				Ximeio[I][J].Xb[k-1][4-1]=0.5*(X[I+1][J].Xb[k-1][4-1]+X[I][J].Xb[k-1][4-1]);
		
				Ximeio[I][J].Xbinv[k-1][1-1]=0.5*(X[I+1][J].Xbinv[k-1][1-1]+X[I][J].Xbinv[k-1][1-1]);
				Ximeio[I][J].Xbinv[k-1][2-1]=0.5*(X[I+1][J].Xbinv[k-1][2-1]+X[I][J].Xbinv[k-1][2-1]);
				Ximeio[I][J].Xbinv[k-1][3-1]=0.5*(X[I+1][J].Xbinv[k-1][3-1]+X[I][J].Xbinv[k-1][3-1]);
				Ximeio[I][J].Xbinv[k-1][4-1]=0.5*(X[I+1][J].Xbinv[k-1][4-1]+X[I][J].Xbinv[k-1][4-1]);
				if(I==1911&&J==2)
				{
				    printf("\n Ximeio[I][J].Xa[k-1][1-1]=%lf      X[I+1][J].Xa[k-1][1-1]=%lf    X[I][J].Xa[k-1][1-1]=%lf     \n",Ximeio[I][J].Xa[k-1][1-1],X[I+1][J].Xa[k-1][1-1],X[I][J].Xa[k-1][1-1]);
				    printf("\n Ximeio[I][J].Xa[k-1][1-1]=%lf      X[I+1][J].Xa[k-1][1-1]=%lf    X[I][J].Xa[k-1][1-1]=%lf     \n",Ximeio[I][J].Xa[k-1][2-1],X[I+1][J].Xa[k-1][1-1],X[I][J].Xa[k-1][1-1]);
				    printf("\n Ximeio[I][J].Xa[k-1][1-1]=%lf      X[I+1][J].Xa[k-1][1-1]=%lf    X[I][J].Xa[k-1][1-1]=%lf     \n",Ximeio[I][J].Xa[k-1][3-1],X[I+1][J].Xa[k-1][1-1],X[I][J].Xa[k-1][1-1]);
				    printf("\n Ximeio[I][J].Xa[k-1][1-1]=%lf      X[I+1][J].Xa[k-1][1-1]=%lf    X[I][J].Xa[k-1][1-1]=%lf     \n\n\n",Ximeio[I][J].Xa[k-1][4-1],X[I+1][J].Xa[k-1][1-1],X[I][J].Xa[k-1][1-1]);
				    
				    printf("\n Ximeio[I][J].Xb[k-1][1-1]=%lf      X[I+1][J].Xb[k-1][1-1]=%lf    X[I][J].Xb[k-1][1-1]=%lf     \n",Ximeio[I][J].Xb[k-1][1-1],X[I+1][J].Xb[k-1][1-1],X[I][J].Xb[k-1][1-1]);
				    printf("\n Ximeio[I][J].Xb[k-1][1-1]=%lf      X[I+1][J].Xb[k-1][1-1]=%lf    X[I][J].Xb[k-1][1-1]=%lf     \n",Ximeio[I][J].Xb[k-1][2-1],X[I+1][J].Xb[k-1][2-1],X[I][J].Xb[k-1][2-1]);				    
				    printf("\n Ximeio[I][J].Xb[k-1][1-1]=%lf      X[I+1][J].Xb[k-1][1-1]=%lf    X[I][J].Xb[k-1][1-1]=%lf     \n",Ximeio[I][J].Xb[k-1][3-1],X[I+1][J].Xb[k-1][3-1],X[I][J].Xb[k-1][3-1]);				    
				    printf("\n Ximeio[I][J].Xb[k-1][1-1]=%lf      X[I+1][J].Xb[k-1][1-1]=%lf    X[I][J].Xb[k-1][1-1]=%lf     \n",Ximeio[I][J].Xb[k-1][4-1],X[I+1][J].Xb[k-1][4-1],X[I][J].Xb[k-1][4-1]);				    
				    getchar();
				}
			}
		}
	}	      
/*	for(J=1;J<=JM;J++)
	{
		I=IM;
		for(k=1;k<=4;k++)
		{
			Ximeio[I][J].Xa[k-1][1-1]=2.0*(X[I][J].Xa[k-1][1-1])-X[I-1][J].Xa[k-1][1-1];
			Ximeio[I][J].Xa[k-1][2-1]=2.0*(X[I][J].Xa[k-1][2-1])-X[I-1][J].Xa[k-1][2-1];
			Ximeio[I][J].Xa[k-1][3-1]=2.0*(X[I][J].Xa[k-1][3-1])-X[I-1][J].Xa[k-1][3-1];
			Ximeio[I][J].Xa[k-1][4-1]=2.0*(X[I][J].Xa[k-1][4-1])-X[I-1][J].Xa[k-1][4-1];
		
			Ximeio[I][J].Xainv[k-1][1-1]=2.0*(X[I][J].Xainv[k-1][1-1])-X[I-1][J].Xainv[k-1][1-1];
			Ximeio[I][J].Xainv[k-1][2-1]=2.0*(X[I][J].Xainv[k-1][2-1])-X[I-1][J].Xainv[k-1][2-1];
			Ximeio[I][J].Xainv[k-1][3-1]=2.0*(X[I][J].Xainv[k-1][3-1])-X[I-1][J].Xainv[k-1][3-1];
			Ximeio[I][J].Xainv[k-1][4-1]=2.0*(X[I][J].Xainv[k-1][4-1])-X[I-1][J].Xainv[k-1][4-1];
	
			Ximeio[I][J].Xb[k-1][1-1]=2.0*(X[I][J].Xb[k-1][1-1])-X[I-1][J].Xb[k-1][1-1];
			Ximeio[I][J].Xb[k-1][2-1]=2.0*(X[I][J].Xb[k-1][2-1])-X[I-1][J].Xb[k-1][2-1];
			Ximeio[I][J].Xb[k-1][3-1]=2.0*(X[I][J].Xb[k-1][3-1])-X[I-1][J].Xb[k-1][3-1];
			Ximeio[I][J].Xb[k-1][4-1]=2.0*(X[I][J].Xb[k-1][4-1])-X[I-1][J].Xb[k-1][4-1];
		
			Ximeio[I][J].Xbinv[k-1][1-1]=2.0*(X[I][J].Xbinv[k-1][1-1])-X[I-1][J].Xbinv[k-1][1-1];
			Ximeio[I][J].Xbinv[k-1][2-1]=2.0*(X[I][J].Xbinv[k-1][2-1])-X[I-1][J].Xbinv[k-1][2-1];
			Ximeio[I][J].Xbinv[k-1][3-1]=2.0*(X[I][J].Xbinv[k-1][3-1])-X[I-1][J].Xbinv[k-1][3-1];
			Ximeio[I][J].Xbinv[k-1][4-1]=2.0*(X[I][J].Xbinv[k-1][4-1])-X[I-1][J].Xbinv[k-1][4-1];
		}
	}
	*/
	for(I=1;I<=IM;I++)
	{
		for(J=1;J<=JM-1;J++)
		{
			for(k=1;k<=4;k++)
			{
				Xjmeio[I][J].Xa[k-1][1-1]=0.5*(X[I][J+1].Xa[k-1][1-1]+X[I][J].Xa[k-1][1-1]);
				Xjmeio[I][J].Xa[k-1][2-1]=0.5*(X[I][J+1].Xa[k-1][2-1]+X[I][J].Xa[k-1][2-1]);
				Xjmeio[I][J].Xa[k-1][3-1]=0.5*(X[I][J+1].Xa[k-1][3-1]+X[I][J].Xa[k-1][3-1]);
				Xjmeio[I][J].Xa[k-1][4-1]=0.5*(X[I][J+1].Xa[k-1][4-1]+X[I][J].Xa[k-1][4-1]);
		    
				Xjmeio[I][J].Xainv[k-1][1-1]=0.5*(X[I][J+1].Xainv[k-1][1-1]+X[I][J].Xainv[k-1][1-1]);
				Xjmeio[I][J].Xainv[k-1][2-1]=0.5*(X[I][J+1].Xainv[k-1][2-1]+X[I][J].Xainv[k-1][2-1]);
				Xjmeio[I][J].Xainv[k-1][3-1]=0.5*(X[I][J+1].Xainv[k-1][3-1]+X[I][J].Xainv[k-1][3-1]);
				Xjmeio[I][J].Xainv[k-1][4-1]=0.5*(X[I][J+1].Xainv[k-1][4-1]+X[I][J].Xainv[k-1][4-1]);
		    
				Xjmeio[I][J].Xb[k-1][1-1]=0.5*(X[I][J+1].Xb[k-1][1-1]+X[I][J].Xb[k-1][1-1]);
				Xjmeio[I][J].Xb[k-1][2-1]=0.5*(X[I][J+1].Xb[k-1][2-1]+X[I][J].Xb[k-1][2-1]);
				Xjmeio[I][J].Xb[k-1][3-1]=0.5*(X[I][J+1].Xb[k-1][3-1]+X[I][J].Xb[k-1][3-1]);
				Xjmeio[I][J].Xb[k-1][4-1]=0.5*(X[I][J+1].Xb[k-1][4-1]+X[I][J].Xb[k-1][4-1]);
		    
				Xjmeio[I][J].Xbinv[k-1][1-1]=0.5*(X[I][J+1].Xbinv[k-1][1-1]+X[I][J].Xbinv[k-1][1-1]);
				Xjmeio[I][J].Xbinv[k-1][2-1]=0.5*(X[I][J+1].Xbinv[k-1][2-1]+X[I][J].Xbinv[k-1][2-1]);
				Xjmeio[I][J].Xbinv[k-1][3-1]=0.5*(X[I][J+1].Xbinv[k-1][3-1]+X[I][J].Xbinv[k-1][3-1]);
				Xjmeio[I][J].Xbinv[k-1][4-1]=0.5*(X[I][J+1].Xbinv[k-1][4-1]+X[I][J].Xbinv[k-1][4-1]);
			}
		}
	}	
	for(I=1;I<=IM;I++)
	{
		J=JM;
		for(k=1;k<=4;k++)
		{
			Xjmeio[I][J].Xa[k-1][1-1]=2.0*(X[I][J].Xa[k-1][1-1])-X[I][J-1].Xa[k-1][1-1];
			Xjmeio[I][J].Xa[k-1][2-1]=2.0*(X[I][J].Xa[k-1][2-1])-X[I][J-1].Xa[k-1][2-1];
			Xjmeio[I][J].Xa[k-1][3-1]=2.0*(X[I][J].Xa[k-1][3-1])-X[I][J-1].Xa[k-1][3-1];
			Xjmeio[I][J].Xa[k-1][4-1]=2.0*(X[I][J].Xa[k-1][4-1])-X[I][J-1].Xa[k-1][4-1];

			Xjmeio[I][J].Xainv[k-1][1-1]=2.0*(X[I][J].Xainv[k-1][1-1])-X[I][J-1].Xainv[k-1][1-1];
			Xjmeio[I][J].Xainv[k-1][2-1]=2.0*(X[I][J].Xainv[k-1][2-1])-X[I][J-1].Xainv[k-1][2-1];
			Xjmeio[I][J].Xainv[k-1][3-1]=2.0*(X[I][J].Xainv[k-1][3-1])-X[I][J-1].Xainv[k-1][3-1];
			Xjmeio[I][J].Xainv[k-1][4-1]=2.0*(X[I][J].Xainv[k-1][4-1])-X[I][J-1].Xainv[k-1][4-1];
		
			Xjmeio[I][J].Xb[k-1][1-1]=2.0*(X[I][J].Xb[k-1][1-1])-X[I][J-1].Xb[k-1][1-1];
			Xjmeio[I][J].Xb[k-1][2-1]=2.0*(X[I][J].Xb[k-1][2-1])-X[I][J-1].Xb[k-1][2-1];
			Xjmeio[I][J].Xb[k-1][3-1]=2.0*(X[I][J].Xb[k-1][3-1])-X[I][J-1].Xb[k-1][3-1];
			Xjmeio[I][J].Xb[k-1][4-1]=2.0*(X[I][J].Xb[k-1][4-1])-X[I][J-1].Xb[k-1][4-1];
		      
			Xjmeio[I][J].Xbinv[k-1][1-1]=2.0*(X[I][J].Xbinv[k-1][1-1])-X[I][J-1].Xbinv[k-1][1-1];
			Xjmeio[I][J].Xbinv[k-1][2-1]=2.0*(X[I][J].Xbinv[k-1][2-1])-X[I][J-1].Xbinv[k-1][2-1];
			Xjmeio[I][J].Xbinv[k-1][3-1]=2.0*(X[I][J].Xbinv[k-1][3-1])-X[I][J-1].Xbinv[k-1][3-1];
			Xjmeio[I][J].Xbinv[k-1][4-1]=2.0*(X[I][J].Xbinv[k-1][4-1])-X[I][J-1].Xbinv[k-1][4-1];
		}
	}	
		
	for(J=1;J<=JM;J++)
	{
		I=IM+1;
		for(k=1;k<=4;k++)
		{
			Ximeio[I][J].Xa[k-1][1-1]=2.0*(Ximeio[I-1][J].Xa[k-1][1-1])-Ximeio[I-2][J].Xa[k-1][1-1];
			Ximeio[I][J].Xa[k-1][2-1]=2.0*(Ximeio[I-1][J].Xa[k-1][2-1])-Ximeio[I-2][J].Xa[k-1][2-1];
			Ximeio[I][J].Xa[k-1][3-1]=2.0*(Ximeio[I-1][J].Xa[k-1][3-1])-Ximeio[I-2][J].Xa[k-1][3-1];
			Ximeio[I][J].Xa[k-1][4-1]=2.0*(Ximeio[I-1][J].Xa[k-1][4-1])-Ximeio[I-2][J].Xa[k-1][4-1];

			Ximeio[I][J].Xainv[k-1][1-1]=2.0*(Ximeio[I-1][J].Xainv[k-1][1-1])-Ximeio[I-2][J].Xainv[k-1][1-1];
			Ximeio[I][J].Xainv[k-1][2-1]=2.0*(Ximeio[I-1][J].Xainv[k-1][2-1])-Ximeio[I-2][J].Xainv[k-1][2-1];
			Ximeio[I][J].Xainv[k-1][3-1]=2.0*(Ximeio[I-1][J].Xainv[k-1][3-1])-Ximeio[I-2][J].Xainv[k-1][3-1];
			Ximeio[I][J].Xainv[k-1][4-1]=2.0*(Ximeio[I-1][J].Xainv[k-1][4-1])-Ximeio[I-2][J].Xainv[k-1][4-1];
		
			Ximeio[I][J].Xb[k-1][1-1]=2.0*(Ximeio[I-1][J].Xb[k-1][1-1])-Ximeio[I-2][J].Xb[k-1][1-1];
			Ximeio[I][J].Xb[k-1][2-1]=2.0*(Ximeio[I-1][J].Xb[k-1][2-1])-Ximeio[I-2][J].Xb[k-1][2-1];
			Ximeio[I][J].Xb[k-1][3-1]=2.0*(Ximeio[I-1][J].Xb[k-1][3-1])-Ximeio[I-2][J].Xb[k-1][3-1];
			Ximeio[I][J].Xb[k-1][4-1]=2.0*(Ximeio[I-1][J].Xb[k-1][4-1])-Ximeio[I-2][J].Xb[k-1][4-1];
		      
			Ximeio[I][J].Xbinv[k-1][1-1]=2.0*(Ximeio[I-1][J].Xbinv[k-1][1-1])-Ximeio[I-2][J].Xbinv[k-1][1-1];
			Ximeio[I][J].Xbinv[k-1][2-1]=2.0*(Ximeio[I-1][J].Xbinv[k-1][2-1])-Ximeio[I-2][J].Xbinv[k-1][2-1];
			Ximeio[I][J].Xbinv[k-1][3-1]=2.0*(Ximeio[I-1][J].Xbinv[k-1][3-1])-Ximeio[I-2][J].Xbinv[k-1][3-1];
			Ximeio[I][J].Xbinv[k-1][4-1]=2.0*(Ximeio[I-1][J].Xbinv[k-1][4-1])-Ximeio[I-2][J].Xbinv[k-1][4-1];
		}
/*		I=0;
		for(k=1;k<=4;k++)
		{
			Ximeio[I][J].Xa[k-1][1-1]=2.0*(Ximeio[I+1][J].Xa[k-1][1-1])-Ximeio[I+2][J].Xa[k-1][1-1];
			Ximeio[I][J].Xa[k-1][2-1]=2.0*(Ximeio[I+1][J].Xa[k-1][2-1])-Ximeio[I+2][J].Xa[k-1][2-1];
			Ximeio[I][J].Xa[k-1][3-1]=2.0*(Ximeio[I+1][J].Xa[k-1][3-1])-Ximeio[I+2][J].Xa[k-1][3-1];
			Ximeio[I][J].Xa[k-1][4-1]=2.0*(Ximeio[I+1][J].Xa[k-1][4-1])-Ximeio[I+2][J].Xa[k-1][4-1];

			Ximeio[I][J].Xainv[k-1][1-1]=2.0*(Ximeio[I+1][J].Xainv[k-1][1-1])-Ximeio[I+2][J].Xainv[k-1][1-1];
			Ximeio[I][J].Xainv[k-1][2-1]=2.0*(Ximeio[I+1][J].Xainv[k-1][2-1])-Ximeio[I+2][J].Xainv[k-1][2-1];
			Ximeio[I][J].Xainv[k-1][3-1]=2.0*(Ximeio[I+1][J].Xainv[k-1][3-1])-Ximeio[I+2][J].Xainv[k-1][3-1];
			Ximeio[I][J].Xainv[k-1][4-1]=2.0*(Ximeio[I+1][J].Xainv[k-1][4-1])-Ximeio[I+2][J].Xainv[k-1][4-1];
		
			Ximeio[I][J].Xb[k-1][1-1]=2.0*(Ximeio[I+1][J].Xb[k-1][1-1])-Ximeio[I+2][J].Xb[k-1][1-1];
			Ximeio[I][J].Xb[k-1][2-1]=2.0*(Ximeio[I+1][J].Xb[k-1][2-1])-Ximeio[I+2][J].Xb[k-1][2-1];
			Ximeio[I][J].Xb[k-1][3-1]=2.0*(Ximeio[I+1][J].Xb[k-1][3-1])-Ximeio[I+2][J].Xb[k-1][3-1];
			Ximeio[I][J].Xb[k-1][4-1]=2.0*(Ximeio[I+1][J].Xb[k-1][4-1])-Ximeio[I+2][J].Xb[k-1][4-1];
		      
			Ximeio[I][J].Xbinv[k-1][1-1]=2.0*(Ximeio[I+1][J].Xbinv[k-1][1-1])-Ximeio[I+2][J].Xbinv[k-1][1-1];
			Ximeio[I][J].Xbinv[k-1][2-1]=2.0*(Ximeio[I+1][J].Xbinv[k-1][2-1])-Ximeio[I+2][J].Xbinv[k-1][2-1];
			Ximeio[I][J].Xbinv[k-1][3-1]=2.0*(Ximeio[I+1][J].Xbinv[k-1][3-1])-Ximeio[I+2][J].Xbinv[k-1][3-1];
			Ximeio[I][J].Xbinv[k-1][4-1]=2.0*(Ximeio[I+1][J].Xbinv[k-1][4-1])-Ximeio[I+2][J].Xbinv[k-1][4-1];
		}*/
		
	}
	for(I=1;I<=IM;I++)
	{
		J=JM+1;
		for(k=1;k<=4;k++)
		{
			Xjmeio[I][J].Xa[k-1][1-1]=2.0*(Xjmeio[I][J-1].Xa[k-1][1-1])-Xjmeio[I][J-2].Xa[k-1][1-1];
			Xjmeio[I][J].Xa[k-1][2-1]=2.0*(Xjmeio[I][J-1].Xa[k-1][2-1])-Xjmeio[I][J-2].Xa[k-1][2-1];
			Xjmeio[I][J].Xa[k-1][3-1]=2.0*(Xjmeio[I][J-1].Xa[k-1][3-1])-Xjmeio[I][J-2].Xa[k-1][3-1];
			Xjmeio[I][J].Xa[k-1][4-1]=2.0*(Xjmeio[I][J-1].Xa[k-1][4-1])-Xjmeio[I][J-2].Xa[k-1][4-1];

			Xjmeio[I][J].Xainv[k-1][1-1]=2.0*(Xjmeio[I][J-1].Xainv[k-1][1-1])-Xjmeio[I][J-2].Xainv[k-1][1-1];
			Xjmeio[I][J].Xainv[k-1][2-1]=2.0*(Xjmeio[I][J-1].Xainv[k-1][2-1])-Xjmeio[I][J-2].Xainv[k-1][2-1];
			Xjmeio[I][J].Xainv[k-1][3-1]=2.0*(Xjmeio[I][J-1].Xainv[k-1][3-1])-Xjmeio[I][J-2].Xainv[k-1][3-1];
			Xjmeio[I][J].Xainv[k-1][4-1]=2.0*(Xjmeio[I][J-1].Xainv[k-1][4-1])-Xjmeio[I][J-2].Xainv[k-1][4-1];
		
			Xjmeio[I][J].Xb[k-1][1-1]=2.0*(Xjmeio[I][J-1].Xb[k-1][1-1])-Xjmeio[I][J-2].Xb[k-1][1-1];
			Xjmeio[I][J].Xb[k-1][2-1]=2.0*(Xjmeio[I][J-1].Xb[k-1][2-1])-Xjmeio[I][J-2].Xb[k-1][2-1];
			Xjmeio[I][J].Xb[k-1][3-1]=2.0*(Xjmeio[I][J-1].Xb[k-1][3-1])-Xjmeio[I][J-2].Xb[k-1][3-1];
			Xjmeio[I][J].Xb[k-1][4-1]=2.0*(Xjmeio[I][J-1].Xb[k-1][4-1])-Xjmeio[I][J-2].Xb[k-1][4-1];

			Xjmeio[I][J].Xbinv[k-1][1-1]=2.0*(Xjmeio[I][J-1].Xbinv[k-1][1-1])-Xjmeio[I][J-2].Xbinv[k-1][1-1];
			Xjmeio[I][J].Xbinv[k-1][2-1]=2.0*(Xjmeio[I][J-1].Xbinv[k-1][2-1])-Xjmeio[I][J-2].Xbinv[k-1][2-1];
			Xjmeio[I][J].Xbinv[k-1][3-1]=2.0*(Xjmeio[I][J-1].Xbinv[k-1][3-1])-Xjmeio[I][J-2].Xbinv[k-1][3-1];
			Xjmeio[I][J].Xbinv[k-1][4-1]=2.0*(Xjmeio[I][J-1].Xbinv[k-1][4-1])-Xjmeio[I][J-2].Xbinv[k-1][4-1];
		}
		J=0;
		for(k=1;k<=4;k++)
		{
			Xjmeio[I][J].Xa[k-1][1-1]=2.0*(Xjmeio[I][J+1].Xa[k-1][1-1])-Xjmeio[I][J+2].Xa[k-1][1-1];
			Xjmeio[I][J].Xa[k-1][2-1]=2.0*(Xjmeio[I][J+1].Xa[k-1][2-1])-Xjmeio[I][J+2].Xa[k-1][2-1];
			Xjmeio[I][J].Xa[k-1][3-1]=2.0*(Xjmeio[I][J+1].Xa[k-1][3-1])-Xjmeio[I][J+2].Xa[k-1][3-1];
			Xjmeio[I][J].Xa[k-1][4-1]=2.0*(Xjmeio[I][J+1].Xa[k-1][4-1])-Xjmeio[I][J+2].Xa[k-1][4-1];

			Xjmeio[I][J].Xainv[k-1][1-1]=2.0*(Xjmeio[I][J+1].Xainv[k-1][1-1])-Xjmeio[I][J+2].Xainv[k-1][1-1];
			Xjmeio[I][J].Xainv[k-1][2-1]=2.0*(Xjmeio[I][J+1].Xainv[k-1][2-1])-Xjmeio[I][J+2].Xainv[k-1][2-1];
			Xjmeio[I][J].Xainv[k-1][3-1]=2.0*(Xjmeio[I][J+1].Xainv[k-1][3-1])-Xjmeio[I][J+2].Xainv[k-1][3-1];
			Xjmeio[I][J].Xainv[k-1][4-1]=2.0*(Xjmeio[I][J+1].Xainv[k-1][4-1])-Xjmeio[I][J+2].Xainv[k-1][4-1];
		
			Xjmeio[I][J].Xb[k-1][1-1]=2.0*(Xjmeio[I][J+1].Xb[k-1][1-1])-Xjmeio[I][J+2].Xb[k-1][1-1];
			Xjmeio[I][J].Xb[k-1][2-1]=2.0*(Xjmeio[I][J+1].Xb[k-1][2-1])-Xjmeio[I][J+2].Xb[k-1][2-1];
			Xjmeio[I][J].Xb[k-1][3-1]=2.0*(Xjmeio[I][J+1].Xb[k-1][3-1])-Xjmeio[I][J+2].Xb[k-1][3-1];
			Xjmeio[I][J].Xb[k-1][4-1]=2.0*(Xjmeio[I][J+1].Xb[k-1][4-1])-Xjmeio[I][J+2].Xb[k-1][4-1];

			Xjmeio[I][J].Xbinv[k-1][1-1]=2.0*(Xjmeio[I][J+1].Xbinv[k-1][1-1])-Xjmeio[I][J+2].Xbinv[k-1][1-1];
			Xjmeio[I][J].Xbinv[k-1][2-1]=2.0*(Xjmeio[I][J+1].Xbinv[k-1][2-1])-Xjmeio[I][J+2].Xbinv[k-1][2-1];
			Xjmeio[I][J].Xbinv[k-1][3-1]=2.0*(Xjmeio[I][J+1].Xbinv[k-1][3-1])-Xjmeio[I][J+2].Xbinv[k-1][3-1];
			Xjmeio[I][J].Xbinv[k-1][4-1]=2.0*(Xjmeio[I][J+1].Xbinv[k-1][4-1])-Xjmeio[I][J+2].Xbinv[k-1][4-1];
		}
	}	
}

/*-------------------------------------------------------*/





/*-------------------------------------------------------*/
/*          Alimenta os vetores DeltaE e DeltaN          */
/*-------------------------------------------------------*/
void deltasTVD(unsigned int IM,unsigned int JM,
	      vetorX16 **X,vetor **Qb,vetor **Q,
	       grade **mJ,grade **mN,grade **mE,
	  double gama,grade **mimeioJ,
	       grade **mjmeioJ,vetor **DeltaEimeio,
	vetor **DeltaNjmeio,vetor **Qampliado,
 	vetorX16 **Ximeio,vetorX16 **Xjmeio)
{
	unsigned int I,J,k;
	double t1,t2;
	double Deltaimeio,Deltajmeio;
	double xainvl1,xainvl2,xainvl3,xainvl4;
	double xbinvl1,xbinvl2,xbinvl3,xbinvl4;
	double xq1,xq2,xq3,xq4;
	double yq1,yq2,yq3,yq4;
	double imeioJacob,jmeioJacob;

	Xmeio(IM,JM,X,Ximeio,Xjmeio);
	for(I=0;I<=IM;I++) 
	{
	  for(J=1;J<=JM;J++)
	  {
	    imeioJacob=mimeioJ[I][J].x;
	    for(k=1;k<=4;k++)
	    {
		xq1=(Qampliado[I+1][J].v[1-1]-Qampliado[I][J].v[1-1]);
		xq2=(Qampliado[I+1][J].v[2-1]-Qampliado[I][J].v[2-1]);
		xq3=(Qampliado[I+1][J].v[3-1]-Qampliado[I][J].v[3-1]);
		xq4=(Qampliado[I+1][J].v[4-1]-Qampliado[I][J].v[4-1]);
		
		xainvl1=Ximeio[I][J].Xainv[k-1][1-1];
		xainvl2=Ximeio[I][J].Xainv[k-1][2-1];
		xainvl3=Ximeio[I][J].Xainv[k-1][3-1];
		xainvl4=Ximeio[I][J].Xainv[k-1][4-1];
		
		  if(I==11771&&J==2)
		  {
		  
		      printf("\n  xainvl1=%lf    k=%d    \n",xainvl1,k);
		      printf("\n  xainvl2=%lf    k=%d    \n",xainvl2,k);
		      printf("\n  xainvl3=%lf    k=%d    \n",xainvl3,k);
		      printf("\n  xainvl4=%lf    k=%d    \n",xainvl4,k);
		      printf("\n  imeioJacob=%lf    k=%d    \n",imeioJacob,k);
		      
		      printf("\n  xq1=%lf   xq2=%lf   xq3=%lf   xq4=%lf    k=%d    \n",xq1,xq2,xq3,xq4,k);
		      
		     
		      
		      
		      getchar();
		  }		  		
		
		DeltaEimeio[I][J].v[k-1]=(xainvl1*xq1+xainvl2*xq2+xainvl3*xq3+xainvl4*xq4)/(imeioJacob);
		  if(I==1167671&&J==2)
		  {
		  
		      printf("\n  DeltaEimeio[I][J].v[k-1]=%lf    k=%d    \n",DeltaEimeio[I][J].v[k-1],k);
		     
		      
		      
		      getchar();
		  }		  		
	    }
	  }
	}

	/*  extrapolando para obter delta em I=IM+1   */
	for(J=1;J<=JM;J++)
	{
	  for(k=1;k<=4;k++)
	  {
	      DeltaEimeio[IM+1][J].v[k-1]=2.0*DeltaEimeio[IM][J].v[k-1]-DeltaEimeio[IM-1][J].v[k-1];
	      
/*	      DeltaEimeio[0][J].v[k-1]=2.0*DeltaEimeio[1][J].v[k-1]-DeltaEimeio[2][J].v[k-1];	      */
	  }
	}


	for(I=1;I<=IM;I++)
	{
	  for(J=0;J<=JM;J++)
	  {
	    jmeioJacob=mjmeioJ[I][J].x;
	    for(k=1;k<=4;k++)
	    {
		yq1=(Qampliado[I][J+1].v[1-1]-Qampliado[I][J].v[1-1]);
		yq2=(Qampliado[I][J+1].v[2-1]-Qampliado[I][J].v[2-1]);
		yq3=(Qampliado[I][J+1].v[3-1]-Qampliado[I][J].v[3-1]);
		yq4=(Qampliado[I][J+1].v[4-1]-Qampliado[I][J].v[4-1]);
		
		xbinvl1=Xjmeio[I][J].Xbinv[k-1][1-1];
		xbinvl2=Xjmeio[I][J].Xbinv[k-1][2-1];
		xbinvl3=Xjmeio[I][J].Xbinv[k-1][3-1];
		xbinvl4=Xjmeio[I][J].Xbinv[k-1][4-1];
		
		  if(I==11566567561&&J==2)
		  {
		  
		      printf("\n  xbinvl1=%lf    k=%d    \n",xbinvl1,k);
		      printf("\n  xbinvl2=%lf    k=%d    \n",xbinvl2,k);
		      printf("\n  xbinvl3=%lf    k=%d    \n",xbinvl3,k);
		      printf("\n  xbinvl4=%lf    k=%d    \n",xbinvl4,k);
		      printf("\n  jmeioJacob=%lf    k=%d    \n",jmeioJacob,k);
		      
		     
		      printf("\n  yq1=%lf   yq2=%lf   yq3=%lf   yq4=%lf    k=%d    \n",yq1,yq2,yq3,yq4,k);
		      
		      getchar();
		  }			
		
		DeltaNjmeio[I][J].v[k-1]=(xbinvl1*yq1+xbinvl2*yq2+xbinvl3*yq3+xbinvl4*yq4)/(jmeioJacob);
		
		  if(I==1176561&&J==2)
		  {
		  
		      printf("\n  DeltaNjmeio[I][J].v[k-1]=%lf    k=%d    \n",DeltaNjmeio[I][J].v[k-1],k);
		     
		      
		      
		      getchar();
		  }		  
	    }
	  }
	}

	/*  extrapolando para obter delta em J=JM+1   */
	for(I=1;I<=IM;I++)
	{
	  for(k=1;k<=4;k++)
	  {
	      DeltaEimeio[I][JM+1].v[k-1]=2.0*DeltaEimeio[I][JM].v[k-1]-DeltaEimeio[I][JM-1].v[k-1];
/*	      DeltaEimeio[I][0].v[k-1]=2.0*DeltaEimeio[I][1].v[k-1]-DeltaEimeio[I][2].v[k-1];*/
	  }
	}
}
/*-------------------------------------------------------*/




/*-------------------------------------------------------*/
/*          Alimenta os vetores Ge e Gn                  */
/*-------------------------------------------------------*/
void termosG(unsigned int IM,unsigned int JM,
	      vetorX16 **X,vetor **Qb,vetor **Q,
	       grade **mJ,grade **mN,grade **mE,
	       double gama,grade **mimeioJ,
	       grade **mjmeioJ,vetor **DeltaEimeio,
	       vetor **DeltaNjmeio,vetor **Gn,
	       vetor **Ge)
{
	unsigned int I,J,k;
	double t1,t2,t3,t4;

	
	for(I=1;I<=IM;I++)
	{
	  for(J=1;J<=JM;J++)
	  {
	    for(k=1;k<=4;k++)
	    {
		t1=2.0*DeltaEimeio[I-1][J].v[k-1];
		t2=2.0*DeltaEimeio[I][J].v[k-1];
		t3=2.0*DeltaEimeio[I+1][J].v[k-1];
		t4=0.5*(DeltaEimeio[I-1][J].v[k-1]+DeltaEimeio[I+1][J].v[k-1]);
		
		Ge[I][J].v[k-1]=minmod(t1,t2,t3,t4);				  
		
		  if(I==1543645612&&J==3)
		  {
		  
		      printf("\n  termos g  t1=%lf  t2=%lf   t3=%lf   t4=%lf        \n",t1,t2,t3,t4);
		      
		      printf("\n  Ge[I][J].v[k-1]=%lf        \n",Ge[I][J].v[k-1]);
		      
		      
		      getchar();
		  }		  

		
	    }/*final do for I*/
	  }/*final do for J*/
	}/*final do for k*/

	for(I=1;I<=IM;I++)
	{
	  for(J=1;J<=JM;J++)
	  {
	    for(k=1;k<=4;k++)
	    {
		t1=2.0*DeltaNjmeio[I][J-1].v[k-1];
		t2=2.0*DeltaNjmeio[I][J].v[k-1];
		t3=2.0*DeltaNjmeio[I][J+1].v[k-1];
		t4=0.5*(DeltaNjmeio[I][J-1].v[k-1]+DeltaNjmeio[I][J+1].v[k-1]);
		
		Gn[I][J].v[k-1]=minmod(t1,t2,t3,t4);				  
		
	    }/*final do for I*/
	  }/*final do for J*/
	}/*final do for k*/




	for(I=1;I<=IM;I++)
	{
	  for(k=1;k<=4;k++)
	  {
	      Ge[I][JM+1].v[k-1]=Ge[I][JM].v[k-1];
	      Ge[I][0].v[k-1]=Ge[I][1].v[k-1];
	  }
	}

	for(J=1;J<=JM;J++)
	{
	  for(k=1;k<=4;k++)
	  {
	      Ge[IM+1][J].v[k-1]=Ge[IM][J].v[k-1];
	      Ge[0][J].v[k-1]=Ge[1][J].v[k-1];
	  }
	}

	for(I=1;I<=IM;I++)
	{
	  for(k=1;k<=4;k++)
	  {
	      Gn[I][JM+1].v[k-1]=Gn[I][JM].v[k-1];
	      Gn[I][0].v[k-1]=Gn[I][1].v[k-1];
	  }
	}

	for(J=1;J<=JM;J++)
	{
	  for(k=1;k<=4;k++)
	  {
	      Gn[IM+1][J].v[k-1]=Gn[IM][J].v[k-1];
	      Gn[0][J].v[k-1]=Gn[1][J].v[k-1];
	  }
	}
}
/*-------------------------------------------------------*/




/*-------------------------------------------------------*/
/*                 Funcao para ht                        */
/*-------------------------------------------------------*/
void funcaoht(unsigned int I,unsigned int J,
		 grade **mN,grade **mE,grade **fmu,
   		 grade **fmv,double *ht,double CFL,
      		 grade **fma)
{
  
    double Ex,Ey,Nx,Ny,ht_,a;
    double u,v,max1,max2,maxautovalor;
    double lambdaE1,lambdaE2,lambdaE3,lambdaE4;
    double lambdaN1,lambdaN2,lambdaN3,lambdaN4;
    unsigned int guardaI,guardaJ;
    
	    Ex=mE[I-1][J-1].x;
	    Ey=mE[I-1][J-1].y;
	    Nx=mN[I-1][J-1].x;
	    Ny=mN[I-1][J-1].y;

	    
	    u=fmu[I][J].x;
	    v=fmv[I][J].x;
	    a=fma[I][J].x;
	    
	    if((Abs(Ex))>1.0e-15)
	    {
		lambdaE1=Ex*u+Ey*v;
		lambdaE2=Ex*u+Ey*v;	    
		lambdaE3=Ex*u+Ey*v+a*sqrt(Ex*Ex+Ey*Ey);
		lambdaE4=Ex*u+Ey*v-a*sqrt(Ex*Ex+Ey*Ey);
	    }
	    else
	    {
		lambdaE1=Ey*v;
		lambdaE2=Ey*v;	    
		lambdaE3=(v+a)*Ey;
		lambdaE4=(v-a)*Ey;
	    }

	    if((Abs(Nx))>1.0e-15)
	    {
		lambdaN1=Nx*u+Ny*v;
		lambdaN2=Nx*u+Ny*v;	    
		lambdaN3=Nx*u+Ny*v+a*sqrt(Nx*Nx+Ny*Ny);
		lambdaN4=Nx*u+Ny*v-a*sqrt(Nx*Nx+Ny*Ny);
	    }
	    else
	    {
		lambdaN1=Ny*v;
		lambdaN2=Ny*v;	    
		lambdaN3=(v+a)*Ny;
		lambdaN4=(v-a)*Ny; 
	    }

	    max1=max(Abs(lambdaE1),Abs(lambdaE2));
	    max2=max(Abs(lambdaE3),Abs(lambdaN1));
	    max1=max(max1,max2);
	    max2=max(Abs(lambdaN2),Abs(lambdaN3));
	    max1=max(max1,max2);
	    
	    if(max1>maxautovalor)
	    {
		maxautovalor=max1;
	    }


    ht_=(CFL)/(max1);
    *ht=ht_;
}
/*-------------------------------------------------------*/






/*-------------------------------------------------------*/
/* Alimenta os vetores com autovalores autvalE e autvalN */
/*-------------------------------------------------------*/
void autvalor(unsigned int IM,unsigned int JM,
	      grade **mN,grade **mE,
	      grade **fmu,grade **fmv,
        grade **fma,vetor **autvalE,
	       vetor **autvalN)
{
    vetor **tautvalE,**tautvalN;
    	
    tautvalE=NewMatrixVetor(IM+2,JM+2);
    tautvalN=NewMatrixVetor(IM+2,JM+2);

	  
    double Ex,Ey,Nx,Ny;
    double u,v,a;
    double lambdaE1,lambdaE2,lambdaE3,lambdaE4;
    double lambdaN1,lambdaN2,lambdaN3,lambdaN4;
    unsigned int I,J;
    
    for(I=0;I<=IM+1;I++)
    {
       for(J=1;J<=JM;J++)
       {

	    if((I!=0)&&(I!=IM+1))
	    {
	      Ex=mE[I-1][J-1].x;
	      Ey=mE[I-1][J-1].y;
	      Nx=mN[I-1][J-1].x;
	      Ny=mN[I-1][J-1].y;
	    }

	    if(I==0)
	    {
	      Ex=2.0*mE[I][J-1].x-mE[I+1][J-1].x;;
	      Ey=2.0*mE[I][J-1].y-mE[I+1][J-1].y;
	      Nx=2.0*mN[I][J-1].x-mN[I+1][J-1].x;
	      Ny=2.0*mN[I][J-1].y-mN[I+1][J-1].y;	      
	    }

    	    if(I==IM+1)
	    {
	      Ex=2.0*mE[IM-1][J-1].x-mE[IM-2][J-1].x;;
	      Ey=2.0*mE[IM-1][J-1].y-mE[IM-2][J-1].y;
	      Nx=2.0*mN[IM-1][J-1].x-mN[IM-2][J-1].x;
	      Ny=2.0*mN[IM-1][J-1].y-mN[IM-2][J-1].y;	      
	    }

	    u=fmu[I][J].x;
	    v=fmv[I][J].x;
	    a=fma[I][J].x;
	    
	    if((Abs(Ex))>1.0e-15)
	    {
		lambdaE1=Ex*u+Ey*v;
		lambdaE2=Ex*u+Ey*v;	    
		lambdaE3=Ex*u+Ey*v+a*sqrt(Ex*Ex+Ey*Ey);
		lambdaE4=Ex*u+Ey*v-a*sqrt(Ex*Ex+Ey*Ey);
		
		tautvalE[I][J].v[1-1]=lambdaE1;
		tautvalE[I][J].v[2-1]=lambdaE2;
		tautvalE[I][J].v[3-1]=lambdaE3;
		tautvalE[I][J].v[4-1]=lambdaE4;
		

	    }
	    else
	    {
		lambdaE1=Ey*v;
		lambdaE2=Ey*v;	    
		lambdaE3=(v+a)*Ey;
		lambdaE4=(v-a)*Ey;
		
		tautvalE[I][J].v[1-1]=lambdaE1;
		tautvalE[I][J].v[2-1]=lambdaE2;
		tautvalE[I][J].v[3-1]=lambdaE3;
		tautvalE[I][J].v[4-1]=lambdaE4;		
	    }

	    if((Abs(Nx))>1.0e-15)
	    {
		lambdaN1=Nx*u+Ny*v;
		lambdaN2=Nx*u+Ny*v;	    
		lambdaN3=Nx*u+Ny*v+a*sqrt(Nx*Nx+Ny*Ny);
		lambdaN4=Nx*u+Ny*v-a*sqrt(Nx*Nx+Ny*Ny);
		    
		tautvalN[I][J].v[1-1]=lambdaN1;
		tautvalN[I][J].v[2-1]=lambdaN2;
		tautvalN[I][J].v[3-1]=lambdaN3;
		tautvalN[I][J].v[4-1]=lambdaN4;
	    }
	    else
	    {
		lambdaN1=Ny*v;
		lambdaN2=Ny*v;	    
		lambdaN3=(v+a)*Ny;
		lambdaN4=(v-a)*Ny;
		    
		tautvalN[I][J].v[1-1]=lambdaN1;
		tautvalN[I][J].v[2-1]=lambdaN2;
		tautvalN[I][J].v[3-1]=lambdaN3;
		tautvalN[I][J].v[4-1]=lambdaN4;	      
	    }
	
       }
    }	
    
    for(I=1;I<=IM;I++)
    {
       for(J=0;J<=JM+1;J++)
       {
	
	    if((J!=0)&&(J!=JM+1))
	    {
	      Ex=mE[I-1][J-1].x;
	      Ey=mE[I-1][J-1].y;
	      Nx=mN[I-1][J-1].x;
	      Ny=mN[I-1][J-1].y;
	    }
	  
	    if(J==0)
	    {
	      Ex=2.0*mE[I-1][J].x-mE[I-1][J+1].x;;
	      Ey=2.0*mE[I-1][J].y-mE[I-1][J+1].y;
	      Nx=2.0*mN[I-1][J].x-mN[I-1][J+1].x;
	      Ny=2.0*mN[I-1][J].y-mN[I-1][J+1].y;	      
	    }
    	    if(J==JM+1)
	    {
	      Ex=2.0*mE[I-1][J-2].x-mE[I-1][J-3].x;;
	      Ey=2.0*mE[I-1][J-2].y-mE[I-1][J-3].y;
	      Nx=2.0*mN[I-1][J-2].x-mN[I-1][J-3].x;
	      Ny=2.0*mN[I-1][J-2].y-mN[I-1][J-3].y;	      
	    }

	    u=fmu[I][J].x;
	    v=fmv[I][J].x;
	    a=fma[I][J].x;
	    
	    if((Abs(Ex))>1.0e-15)
	    {
		lambdaE1=Ex*u+Ey*v;
		lambdaE2=Ex*u+Ey*v;	    
		lambdaE3=Ex*u+Ey*v+a*sqrt(Ex*Ex+Ey*Ey);
		lambdaE4=Ex*u+Ey*v-a*sqrt(Ex*Ex+Ey*Ey);
		
		tautvalE[I][J].v[1-1]=lambdaE1;
		tautvalE[I][J].v[2-1]=lambdaE2;
		tautvalE[I][J].v[3-1]=lambdaE3;
		tautvalE[I][J].v[4-1]=lambdaE4;
		
		  if((I==117710&&J==2)||(I==1177792&&J==2))
		  {
		  
		      printf("\n      autvalE[I-1][J-1].v[k-1]=%lf     \n",tautvalE[I][J].v[1-1]);
		      printf("\n      autvalE[I-1][J-1].v[k-1]=%lf     \n",tautvalE[I][J].v[2-1]);
		      printf("\n      autvalE[I-1][J-1].v[k-1]=%lf     \n",tautvalE[I][J].v[3-1]);
		      printf("\n      autvalE[I-1][J-1].v[k-1]=%lf     \n",tautvalE[I][J].v[4-1]);
		      
		      printf("\n      u=%lf    v=%lf     \n",u,v);
		      
		      printf("\n      Ex=%lf    Ey=%lf   Nx=%lf  Ny=%lf    \n",Ex,Ey,Nx,Ny);
		      
		      
		      
		      getchar();
		  }		  		
	    }
	    else
	    {
		lambdaE1=Ey*v;
		lambdaE2=Ey*v;	    
		lambdaE3=(v+a)*Ey;
		lambdaE4=(v-a)*Ey;
		
		tautvalE[I][J].v[1-1]=lambdaE1;
		tautvalE[I][J].v[2-1]=lambdaE2;
		tautvalE[I][J].v[3-1]=lambdaE3;
		tautvalE[I][J].v[4-1]=lambdaE4;		
	    }

	    if((Abs(Nx))>1.0e-15)
	    {
		lambdaN1=Nx*u+Ny*v;
		lambdaN2=Nx*u+Ny*v;	    
		lambdaN3=Nx*u+Ny*v+a*sqrt(Nx*Nx+Ny*Ny);
		lambdaN4=Nx*u+Ny*v-a*sqrt(Nx*Nx+Ny*Ny);
		    
		tautvalN[I][J].v[1-1]=lambdaN1;
		tautvalN[I][J].v[2-1]=lambdaN2;
		tautvalN[I][J].v[3-1]=lambdaN3;
		tautvalN[I][J].v[4-1]=lambdaN4;
	    }
	    else
	    {
		lambdaN1=Ny*v;
		lambdaN2=Ny*v;	    
		lambdaN3=(v+a)*Ny;
		lambdaN4=(v-a)*Ny;
		    
		tautvalN[I][J].v[1-1]=lambdaN1;
		tautvalN[I][J].v[2-1]=lambdaN2;
		tautvalN[I][J].v[3-1]=lambdaN3;
		tautvalN[I][J].v[4-1]=lambdaN4;	      
	    }
       }
    }	    
    
    
    
    
    for(I=0;I<=IM;I++)
    {
	for(J=1;J<=JM;J++)
	{
	    autvalE[I][J].v[1-1]=0.5*(tautvalE[I+1][J].v[1-1]+tautvalE[I][J].v[1-1]);
	    autvalE[I][J].v[2-1]=0.5*(tautvalE[I+1][J].v[2-1]+tautvalE[I][J].v[2-1]);
	    autvalE[I][J].v[3-1]=0.5*(tautvalE[I+1][J].v[3-1]+tautvalE[I][J].v[3-1]);
	    autvalE[I][J].v[4-1]=0.5*(tautvalE[I+1][J].v[4-1]+tautvalE[I][J].v[4-1]);
	}
    }
    
    for(I=1;I<=IM;I++)
    {
	for(J=0;J<=JM;J++)
	{
	    autvalN[I][J].v[1-1]=0.5*(tautvalN[I][J+1].v[1-1]+tautvalN[I][J].v[1-1]);
	    autvalN[I][J].v[2-1]=0.5*(tautvalN[I][J+1].v[2-1]+tautvalN[I][J].v[2-1]);
	    autvalN[I][J].v[3-1]=0.5*(tautvalN[I][J+1].v[3-1]+tautvalN[I][J].v[3-1]);
	    autvalN[I][J].v[4-1]=0.5*(tautvalN[I][J+1].v[4-1]+tautvalN[I][J].v[4-1]);
	}
    }
    
    
    
 /*   		  I=111;
		  J=2;
		  {
		  
		      printf("\n      autvalE[I][J].v[k-1]=%lf     \n",autvalE[I][J].v[1-1]);
		      printf("\n      autvalE[I][J].v[k-1]=%lf     \n",autvalE[I][J].v[2-1]);
		      printf("\n      autvalE[I][J].v[k-1]=%lf     \n",autvalE[I][J].v[3-1]);
		      printf("\n      autvalE[I][J].v[k-1]=%lf     \n",autvalE[I][J].v[4-1]);
		      
		      printf("\n      u=%lf    v=%lf     \n",u,v);
		      
		      printf("\n      Ex=%lf    Ey=%lf   Nx=%lf  Ny=%lf    \n",Ex,Ey,Nx,Ny);
		      
		      
		      
		      getchar();
		  }		  		
    */
    
    
    
    
 /*   
    for(J=1;J<=JM;J++)
    {
	I=IM;
	autvalE[I][J].v[1-1]=2.0*(tautvalE[I-1][J].v[1-1])-tautvalE[I-2][J].v[1-1];
	autvalE[I][J].v[2-1]=2.0*(tautvalE[I-1][J].v[2-1])-tautvalE[I-2][J].v[2-1];
	autvalE[I][J].v[3-1]=2.0*(tautvalE[I-1][J].v[3-1])-tautvalE[I-2][J].v[3-1];
	autvalE[I][J].v[4-1]=2.0*(tautvalE[I-1][J].v[4-1])-tautvalE[I-2][J].v[4-1];
    }
    
    for(I=1;I<=IM;I++)
    {
	J=JM;	    
	autvalN[I][J].v[1-1]=2.0*(tautvalN[I][J-1].v[1-1])-tautvalN[I][J-2].v[1-1];
	autvalN[I][J].v[2-1]=2.0*(tautvalN[I][J-1].v[2-1])-tautvalN[I][J-2].v[2-1];
	autvalN[I][J].v[3-1]=2.0*(tautvalN[I][J-1].v[3-1])-tautvalN[I][J-2].v[3-1];
	autvalN[I][J].v[4-1]=2.0*(tautvalN[I][J-1].v[4-1])-tautvalN[I][J-2].v[4-1];
    }
    
    for(J=1;J<=JM;J++)
    {
	    I=IM+1;
	    autvalE[I][J].v[1-1]=2.0*(autvalE[I-1][J].v[1-1])-autvalE[I-2][J].v[1-1];
	    autvalE[I][J].v[2-1]=2.0*(autvalE[I-1][J].v[2-1])-autvalE[I-2][J].v[2-1];
	    autvalE[I][J].v[3-1]=2.0*(autvalE[I-1][J].v[3-1])-autvalE[I-2][J].v[3-1];
	    autvalE[I][J].v[4-1]=2.0*(autvalE[I-1][J].v[4-1])-autvalE[I-2][J].v[4-1];
    }
    
    for(I=1;I<=IM;I++)
    {
	    J=JM+1;
	    autvalN[I][J].v[1-1]=2.0*(autvalN[I][J-1].v[1-1])-autvalN[I][J-2].v[1-1];
	    autvalN[I][J].v[2-1]=2.0*(autvalN[I][J-1].v[2-1])-autvalN[I][J-2].v[2-1];
	    autvalN[I][J].v[3-1]=2.0*(autvalN[I][J-1].v[3-1])-autvalN[I][J-2].v[3-1];
	    autvalN[I][J].v[4-1]=2.0*(autvalN[I][J-1].v[4-1])-autvalN[I][J-2].v[4-1];
    }
    */
    
    LiberarMvetor(IM+2,JM+2,tautvalN);
    LiberarMvetor(IM+2,JM+2,tautvalE); 
}
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*          Alimenta os vetores Phie e Phin               */
/*-------------------------------------------------------*/
void termosPhi(unsigned int IM,unsigned int JM,
	      vetorX16 **X,vetor **Qb,vetor **Q,
	       grade **mJ,grade **mN,grade **mE,
	grade **fma,double gama,grade **mimeioJ,
	    grade **mjmeioJ,vetor **DeltaEimeio,
	       vetor **DeltaNjmeio,vetor **Gn,
	   vetor **Ge,vetor **Phie,vetor **Phin,
	       grade **fmu,grade **fmv,double ht)
{
	unsigned int I,J,k;
	double t1,t2,t3,t4;
	vetor **autvalE,**autvalN;
	
	autvalE=NewMatrixVetor(IM+2,JM+2);
	autvalN=NewMatrixVetor(IM+2,JM+2);
	
	
	
	autvalor(IM,JM,mN,mE,fmu,fmv,fma,autvalE,autvalN);
	
	for(I=0;I<=IM+1;I++)
	{
	  for(J=1;J<=JM;J++)
	  {
	    
	    
	    

	    
	    /*
	    if(I==0)funcaoht(1,J,mN,mE,fmu,fmv,&ht,0.2,fma);
	    if(I==IM+1)funcaoht(IM,J,mN,mE,fmu,fmv,&ht,0.2,fma);
	    if((I!=0)&&(I!=IM+1))funcaoht(I,J,mN,mE,fmu,fmv,&ht,0.2,fma);*/
	    for(k=1;k<=4;k++)
	    {
	      
	      
		  if(I==11251&&J==-1)
		  {
		  
		      printf("\n     autvalN[I][J].v[k-1]=%lf   \n",autvalN[I][J].v[k-1]);
		      
		      
		      getchar();
		  }		 
		  
		  
	      t1=(ht)*((autvalE[I][J].v[k-1])*(autvalE[I][J].v[k-1])*(Ge[I][J].v[k-1]));
	      t2=Pisi(autvalE[I][J].v[k-1],0.0625);
	      t3=(DeltaEimeio[I][J].v[k-1]-Ge[I][J].v[k-1]);

	      Phie[I][J].v[k-1]=-(t1+t2*t3);
		  if(I==14544511&&J==2)
		  {
 
		      printf("\n     t1=%lf  t2=%lf   t3=%lf  t4=%lf   autvalE[I][J].v[k-1]=%lf  ht=%lf     Ge[I][J].v[k-1]=%lf \n",t1,t2,t3,t4,autvalE[I][J].v[k-1],ht,Ge[I][J].v[k-1]);
		      printf("\n     Phie[I][J].v[k-1]=%lf \n",Phie[I][J].v[k-1]);

		      getchar();
		  }		  		  
	    }
	  }
	}
	
/*
	for(I=1;I<=IM;I++)
	{
	  {
	    t1=ht*(autvalE[I][JM].v[k-1])*(autvalE[I][JM].v[k-1])*Ge[I][JM].v[k-1];
	    t2=Pisi(autvalE[I][JM].v[k-1],0.0625);
	    t3=DeltaEimeio[I][JM+1].v[k-1]-Ge[I][JM+1].v[k-1];
	    
	    Phie[I][JM+1].v[k-1]=-(t1+t2*t3);
	    
	    t1=ht*(autvalE[I][1].v[k-1])*(autvalE[I][0].v[k-1])*Ge[I][0].v[k-1];
	    t2=Pisi(autvalE[I][1].v[k-1],0.0625);
	    t3=DeltaEimeio[I][0].v[k-1]-Ge[I][0].v[k-1];
	    
	    Phie[I][0].v[k-1]=-(t1+t2*t3);
	    
	  }
	}
	

	for(J=1;J<=JM;J++)
	{
	  {
	      t1=ht*(autvalE[IM][J].v[k-1])*(autvalE[IM][J].v[k-1])*Ge[IM+1][J].v[k-1];
	      t2=Pisi(autvalE[IM][J].v[k-1],0.0625);
	      t3=DeltaEimeio[IM+1][J].v[k-1]-Ge[IM+1][J].v[k-1];
	      
	      Phie[IM+1][J].v[k-1]=-(t1+t2*t3);
	      
	      t1=ht*(autvalE[1][J].v[k-1])*(autvalE[1][J].v[k-1])*Ge[0][J].v[k-1];
	      t2=Pisi(autvalE[1][J].v[k-1],0.0625);
	      t3=DeltaEimeio[0][J].v[k-1]-Ge[0][J].v[k-1];
	      
	      Phie[0][J].v[k-1]=-(t1+t2*t3);
	      
	  }
	}

*/	
	for(I=1;I<=IM;I++)
	{
	  for(J=0;J<=JM+1;J++)
	  {
	    /*if(J==0)funcaoht(I,1,mN,mE,fmu,fmv,&ht,0.2,fma);
	    if(J==JM+1)funcaoht(I,JM,mN,mE,fmu,fmv,&ht,0.2,fma);
	    if((J!=0)&&(J!=JM+1))funcaoht(I,J,mN,mE,fmu,fmv,&ht,0.2,fma);*/
	    for(k=1;k<=4;k++)
	    {
	      t1=(ht)*(autvalN[I][J].v[k-1])*(autvalN[I][J].v[k-1])*(Gn[I][J].v[k-1]);
	      t2=Pisi(autvalN[I][J].v[k-1],0.0625);
	      t3=(DeltaNjmeio[I][J].v[k-1]-Gn[I][J].v[k-1]);
	      
	      Phin[I][J].v[k-1]=-(t1+t2*t3);
	      
		  if(I==1121211&&J==1)
		  {
		      printf("\n     t1=%lf  t2=%lf   t3=%lf  t4=%lf   autvalN[I][J].v[k-1]=%lf  ht=%lf     Gn[I][J].v[k-1]=%lf  k=%d \n",t1,t2,t3,t4,autvalN[I][J].v[k-1],ht,Gn[I][J].v[k-1],k);
		      printf("\n     Phin[I][J].v[k-1]=%lf \n",Phin[I][J].v[k-1]);
		      
		      
		      getchar();
		  }		      
	      
	    }
	  }
	}
	
/*	
	
	for(I=1;I<=IM;I++)
	{
	  {
	    t1=ht*(autvalN[I-1][JM-1].v[k-1])*(autvalN[I-1][JM-1].v[k-1])*Gn[I][JM+1].v[k-1];
	    t2=Pisi(autvalN[I-1][JM-1].v[k-1],0.0625);
	    t3=DeltaNjmeio[I][JM+1].v[k-1]-Gn[I][JM+1].v[k-1];
	    
	    Phin[I][JM+1].v[k-1]=-(t1+t2*t3);
	    
	    t1=ht*(autvalN[I-1][0].v[k-1])*(autvalN[I-1][0].v[k-1])*Gn[I][0].v[k-1];
	    t2=Pisi(autvalN[I-1][0].v[k-1],0.0625);
	    t3=DeltaNjmeio[I][0].v[k-1]-Gn[I][0].v[k-1];
	    
	    Phin[I][0].v[k-1]=-(t1+t2*t3);
	    
	  }
	}
	

	for(J=1;J<=JM;J++)
	{
	  {
	      t1=ht*(autvalN[IM-1][J-1].v[k-1])*(autvalN[IM-1][J-1].v[k-1])*Gn[IM+1][J].v[k-1];
	      t2=Pisi(autvalN[IM-1][J-1].v[k-1],0.0625);
	      t3=DeltaNjmeio[IM+1][J].v[k-1]-Gn[IM+1][J].v[k-1];
	      
	      Phin[IM+1][J].v[k-1]=-(t1+t2*t3);
	      
	      t1=ht*(autvalN[0][J-1].v[k-1])*(autvalN[0][J-1].v[k-1])*Gn[0][J].v[k-1];
	      t2=Pisi(autvalN[0][J-1].v[k-1],0.0625);
	      t3=DeltaNjmeio[0][J].v[k-1]-Gn[0][J].v[k-1];
	      
	      Phin[0][J].v[k-1]=-(t1+t2*t3);
	      
	  }
	}
	
*/	
	LiberarMvetor(IM+2,JM+2,autvalN);
	LiberarMvetor(IM+2,JM+2,autvalE);
	
}
/*-------------------------------------------------------*/




		
		
/*-------------------------------------------------------*/
/*                       TVD                             */
/*-------------------------------------------------------*/
void TVD(unsigned int IM,unsigned int JM,
	 vetor **Qb,vetor **Q,grade **mJ,grade **mN,
  	grade **mE,grade **fma,double gama,double ht,
	 grade **mimeioJ,grade **mjmeioJ,
	 vetor **Qampliado,grade **mu,grade **mv,
	 grade **fmu,grade **fmv,grade **fmp,
	 grade **fmrho,grade **fmet,vetor **difTVD)
{
	unsigned int I,J,k;
	double t1,t2,t3,t4;
	double Deltaimeio,Deltajmeio;
	double xal1,xal2,xal3,xal4;
	double xbl1,xbl2,xbl3,xbl4;
	double Ephi1,Ephi2,Ephi3,Ephi4;
	double Nphi1,Nphi2,Nphi3,Nphi4;
	double xq1,xq2,xq3,xq4;
	double yq1,yq2,yq3,yq4;
	vetor **DeltaEimeio,**DeltaNjmeio;
	vetor **Gn,**Ge;
	vetor **Phin,**Phie;
	vetorX16 **X,**Ximeio,**Xjmeio;
	
	Phin=NewMatrixVetor(IM+2,JM+2);
	Phie=NewMatrixVetor(IM+2,JM+2);	
	
	Gn=NewMatrixVetor(IM+2,JM+2);
	
	Ge=NewMatrixVetor(IM+2,JM+2);
	
	DeltaEimeio=NewMatrixVetor(IM+2,JM+2);
	DeltaNjmeio=NewMatrixVetor(IM+2,JM+2);
	
	X=NewMatrixvetorX16(IM+2,JM+2);
	Ximeio=NewMatrixvetorX16(IM+2,JM+2);
	Xjmeio=NewMatrixvetorX16(IM+2,JM+2);
	
	
	compMAutovetores(IM,JM,X,Qb,mJ,mN,mE,fma,gama,fmu,fmv,fmp,fmrho,fmet);

	
	deltasTVD(IM,JM,X,Qb,Q,mJ,mN,mE,gama,mimeioJ,mjmeioJ,DeltaEimeio,DeltaNjmeio,Qampliado,Ximeio,Xjmeio);
	
	
	termosG(IM,JM,X,Qb,Q,mJ,mN,mE,gama,mimeioJ,mjmeioJ,DeltaEimeio,DeltaNjmeio,Gn,Ge);	
	
	
	termosPhi(IM,JM,X,Qb,Q,mJ,mN,mE,fma,gama,mimeioJ,mjmeioJ,DeltaEimeio,DeltaNjmeio,Gn,Ge,Phie,Phin,fmu,fmv,ht);
	
	for(I=1;I<=IM;I++)
	{
	    for(J=1;J<=JM;J++)
	    {
	      for(k=1;k<=4;k++)
	      {
		  xal1=Ximeio[I][J].Xa[k-1][1-1];
		  xal2=Ximeio[I][J].Xa[k-1][2-1];
		  xal3=Ximeio[I][J].Xa[k-1][3-1];
		  xal4=Ximeio[I][J].Xa[k-1][4-1];

		  Ephi1=Phie[I][J].v[1-1];
		  Ephi2=Phie[I][J].v[2-1];
		  Ephi3=Phie[I][J].v[3-1];
		  Ephi4=Phie[I][J].v[4-1];
		  
		  /*Xa*Phie i+1/2*/
		  t1=((xal1*Ephi1)+(xal2*Ephi2)+(xal3*Ephi3)+(xal4*Ephi4));
		  
		  if(I==11454521&&J==2)
		  {
		  
		      printf("\n     Ephi1=%lf  Ephi2=%lf   Ephi3=%lf   Ephi4=%lf  t1=%lf    k=%d   \n",Ephi1,Ephi2,Ephi3,Ephi4,t1,k);
		      printf("\n     xal1=%lf  xal2=%lf   xal3=%lf   xal4=%lf        \n",xal1,xal2,xal3,xal4);
		      
		      
		      
		  }		  

		  xal1=Ximeio[I-1][J].Xa[k-1][1-1];
		  xal2=Ximeio[I-1][J].Xa[k-1][2-1];
		  xal3=Ximeio[I-1][J].Xa[k-1][3-1];
		  xal4=Ximeio[I-1][J].Xa[k-1][4-1];		  
		  
		  Ephi1=Phie[I-1][J].v[1-1];
		  Ephi2=Phie[I-1][J].v[2-1];
		  Ephi3=Phie[I-1][J].v[3-1];
		  Ephi4=Phie[I-1][J].v[4-1];

		  /*Xa*Phie i-1/2*/
		  t2=((xal1*Ephi1)+(xal2*Ephi2)+(xal3*Ephi3)+(xal4*Ephi4));
	  
			  
		  if(I==1155545251&&J==2)
		  {
		  
		      printf("\n     Ephi1 -1/2=%lf  Ephi2 -1/2=%lf   Ephi3 -1/2=%lf   Ephi4 -1/2=%lf  t2=%lf    k=%d   \n",Ephi1,Ephi2,Ephi3,Ephi4,t2,k);
		      printf("\n     xal1=%lf  xal2=%lf   xal3=%lf   xal4=%lf        \n",xal1,xal2,xal3,xal4);
		      
		      
		      
		  }		  	  
		  
		  xbl1=Xjmeio[I][J].Xb[k-1][1-1];
		  xbl2=Xjmeio[I][J].Xb[k-1][2-1];
		  xbl3=Xjmeio[I][J].Xb[k-1][3-1];
		  xbl4=Xjmeio[I][J].Xb[k-1][4-1];


		  
		  Nphi1=Phin[I][J].v[1-1];
		  Nphi2=Phin[I][J].v[2-1];
		  Nphi3=Phin[I][J].v[3-1];
		  Nphi4=Phin[I][J].v[4-1];
		  
		  /*Xb*Phin j+1/2*/
		  t3=((xbl1*Nphi1)+(xbl2*Nphi2)+(xbl3*Nphi3)+(xbl4*Nphi4));
		  
		  if(I==112452471&&J==2)
		  {
		  
		      printf("\n     Nphi1=%lf   Nphi2=%lf   Nphi3=%lf   Nphi4=%lf   t3=%lf     \n",Nphi1,Nphi2,Nphi3,Nphi4,t3);
		      printf("\n     xbl1=%lf  xbl2=%lf   xbl3=%lf   xbl4=%lf        \n",xbl1,xbl2,xbl3,xbl4);
		      
		      
		      
		  }		  
		  
		  xbl1=Xjmeio[I][J-1].Xb[k-1][1-1];
		  xbl2=Xjmeio[I][J-1].Xb[k-1][2-1];
		  xbl3=Xjmeio[I][J-1].Xb[k-1][3-1];
		  xbl4=Xjmeio[I][J-1].Xb[k-1][4-1];

		  Nphi1=Phin[I][J-1].v[1-1];
		  Nphi2=Phin[I][J-1].v[2-1];
		  Nphi3=Phin[I][J-1].v[3-1];
		  Nphi4=Phin[I][J-1].v[4-1];
		  
		  /*Xb*Phin j-1/2*/
		  t4=((xbl1*Nphi1)+(xbl2*Nphi2)+(xbl3*Nphi3)+(xbl4*Nphi4));
		  
		  if(I==11452451&&J==2)
		  {
		  
		      printf("\n     Nphi1=%lf   Nphi2=%lf   Nphi3=%lf   Nphi4=%lf   t4=%lf     \n",Nphi1,Nphi2,Nphi3,Nphi4,t4);
		      printf("\n     xbl1=%lf  xbl2=%lf   xbl3=%lf   xbl4=%lf        \n",xbl1,xbl2,xbl3,xbl4);
		      
		      
		      getchar();
		  }		  
		  
		  /*funcaoht(I,J,mN,mE,fmu,fmv,&ht,CFL,fma);*/
		  difTVD[I][J].v[k-1]=-((0.5*ht)*(t1-t2))-((0.5*ht)*(t3-t4));
		  
		  if(I==156546343412&&J==3)
		  {
			  printf("\n diferencial=%lf     difE=%lf     difN=%lf    k=%d         \n",-((0.5*ht)*(t1-t2))-((0.5*ht)*(t3-t4)),-((0.5*ht)*(t1-t2)),-((0.5*ht)*(t3-t4)),k);
			  getchar();
		  }

		  if(I==11544451&&J==2)
		  {
			  printf("\n        I=%d  J=%d  k=%d         \n",I,J,k);	 			  
		      printf("\n         diferencial=%lf        I=%d  J=%d  k=%d         \n",-(0.5*ht)*(t1-t2)-(0.5*ht)*(t3-t4),I,J,k);
		      printf("\n     t1=%lf   t2=%lf   t3=%lf   t4=%lf        \n",t1,t2,t3,t4);
		      printf("\n     Nphi1=%lf   Nphi2=%lf   Nphi3=%lf   Nphi4=%lf        \n",Nphi1,Nphi2,Nphi3,Nphi4);
		      printf("\n     xal1=%lf  xal2=%lf   xal3=%lf   xal4=%lf        \n",xal1,xal2,xal3,xal4);
		      printf("\n     xbl1=%lf  xbl2=%lf   xbl3=%lf   xbl4=%lf        \n",xbl1,xbl2,xbl3,xbl4);
		      
		      
		      getchar();
		  }
		  
	      }
	    }
	}

	
	LiberarMvetor(IM+2,JM+2,Phin);
	LiberarMvetor(IM+2,JM+2,Phie);
	LiberarMvetor(IM+2,JM+2,Gn);
	LiberarMvetor(IM+2,JM+2,Ge);
	LiberarMvetor(IM+2,JM+2,DeltaEimeio);
	LiberarMvetor(IM+2,JM+2,DeltaNjmeio);
	LiberarX16vetor(IM+2,JM+2,X);
	LiberarX16vetor(IM+2,JM+2,Ximeio);
	LiberarX16vetor(IM+2,JM+2,Xjmeio);
	
  
}
/*-------------------------------------------------------*/






/*-------------------------------------------------------*/
/*                   Condicoes iniciais                  */
/*-------------------------------------------------------*/
void condiniciais(unsigned int IM,unsigned int JM,
		  double *gama,double *CFL,
		  vetor **E,
		  vetor **F,vetor **Q,vetor **Eb,
		  vetor **Fb,vetor **Qb,grade **mJ,
		  grade **mN,grade **mE,grade **mu,
		  grade **mv,grade **mp,
		  grade **mrho,grade **met,
    		  vetor **Ebfront,vetor **Fbfront,
		  grade **fmu,grade **fmv,grade **fmp,
    		  grade **fmrho,grade **fmet,grade **fma)
{
  double gama_,p,rho,ctegas,T;
  double v,u,et,aux1,M1;
  double e1,e2,e3,e4;
  double f1,f2,f3,f4;
  double q1,q2,q3,q4;
  double Jacob,Ex,Ey,Nx,Ny;
  double CFL_,a_;
  unsigned int I,J;
  
  
	gama_=1.4;
	*gama=gama_;
	ctegas=287.05; /*  constante dos gases (N.m)/kgK   */
	M1=2.0;  /*   Mach  */
	
	
	CFL_=0.2;
	*CFL=CFL_;
	T=300; /* Temperatura em K   */
	p=100000.0; /*  Pa   */
	
	v=0.0;
	rho=(p)/(ctegas*T);
	
	
/*	printf("\n    valor de rho=%lf  \n",rho);
	getchar();
	getchar();*/
	
	a_=sqrt(gama_*((p)/(rho)));/* equacao (12-229)  */
	u=a_*M1;
	
	aux1=((a_)*(a_))/(gama_*(gama_-1.0));
	et=aux1+0.5*((u*u)+(v*v));
	
	for(I=1;I<=IM;I++)
	{
		for(J=1;J<=JM;J++)
		{
			Jacob=mJ[I-1][J-1].x;
			Ex=mE[I-1][J-1].x;
			Ey=mE[I-1][J-1].y;
			Nx=mN[I-1][J-1].x;
			Ny=mN[I-1][J-1].y;
			
/*------------------------------------------------------------------*/
			/*vetor E*/
			e1=rho*u;
			e2=rho*u*u+p;
			e3=rho*u*v;
			e4=(rho*et+p)*u;
			
			/*vetor F*/
			f1=rho*v;
			f2=rho*v*u;
			f3=rho*v*v+p;
			f4=(rho*et+p)*v;	
			
			/*vetor Q*/
			q1=rho;
			q2=rho*u;
			q3=rho*v;
			q4=rho*et;
/*------------------------------------------------------------------*/
			/*vetor Eb*/
			Eb[I-1][J-1].v[1-1]=(Ex*e1+Ey*f1)/(Jacob);
			Eb[I-1][J-1].v[2-1]=(Ex*e2+Ey*f2)/(Jacob);
			Eb[I-1][J-1].v[3-1]=(Ex*e3+Ey*f3)/(Jacob);
			Eb[I-1][J-1].v[4-1]=(Ex*e4+Ey*f4)/(Jacob);
			
			/*vetor Ebfront*/
			Ebfront[I][J].v[1-1]=(Ex*e1+Ey*f1)/(Jacob);
			Ebfront[I][J].v[2-1]=(Ex*e2+Ey*f2)/(Jacob);
			Ebfront[I][J].v[3-1]=(Ex*e3+Ey*f3)/(Jacob);
			Ebfront[I][J].v[4-1]=(Ex*e4+Ey*f4)/(Jacob);
		
			/*vetor Fb*/
			Fb[I-1][J-1].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
			Fb[I-1][J-1].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
			Fb[I-1][J-1].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
			Fb[I-1][J-1].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);
			
			/*vetor Ebfront*/
			Ebfront[I][J].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
			Ebfront[I][J].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
			Ebfront[I][J].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
			Ebfront[I][J].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);

			/*vetor Qb*/
			Qb[I-1][J-1].v[1-1]=(q1)/(Jacob);
			Qb[I-1][J-1].v[2-1]=(q2)/(Jacob);
			Qb[I-1][J-1].v[3-1]=(q3)/(Jacob);
			Qb[I-1][J-1].v[4-1]=(q4)/(Jacob);
/*------------------------------------------------------------------*/
			/*vetor E*/
			E[I-1][J-1].v[1-1]=e1;
			E[I-1][J-1].v[2-1]=e2;
			E[I-1][J-1].v[3-1]=e3;
			E[I-1][J-1].v[4-1]=e4;
		
			/*vetor F*/
			F[I-1][J-1].v[1-1]=f1;
			F[I-1][J-1].v[2-1]=f2;
			F[I-1][J-1].v[3-1]=f3;
			F[I-1][J-1].v[4-1]=f4;
			
			/*vetor Q*/
			Q[I-1][J-1].v[1-1]=q1;
			Q[I-1][J-1].v[2-1]=q2;
			Q[I-1][J-1].v[3-1]=q3;
			Q[I-1][J-1].v[4-1]=q4;
/*------------------------------------------------------------------*/
			mu[I-1][J-1].x=u;
			mv[I-1][J-1].x=v;
			mp[I-1][J-1].x=p;
			mrho[I-1][J-1].x=rho;
			met[I-1][J-1].x=et;
			
			fmu[I][J].x=u;
			fmv[I][J].x=v;
			fmp[I][J].x=p;
			fmrho[I][J].x=rho;
			fmet[I][J].x=et;
			fma[I][J].x=a_;
			
			if(J==1)
			{
			    Jacob=2.0*mJ[I-1][0].x-mJ[I-1][1].x;
			    Ex=2.0*mE[I-1][0].x-mE[I-1][1].x;
			    Ey=2.0*mE[I-1][0].y-mE[I-1][1].y;
			    Nx=2.0*mN[I-1][0].x-mN[I-1][1].x;
			    Ny=2.0*mN[I-1][0].y-mN[I-1][1].y;
			    
			    /*vetor Ebfront*/
			    Ebfront[I][0].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
			    Ebfront[I][0].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
			    Ebfront[I][0].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
			    Ebfront[I][0].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);
			    
			    fmu[I][0].x=u;
			    fmv[I][0].x=v;
			    fmp[I][0].x=p;
			    fmrho[I][0].x=rho;
			    fmet[I][0].x=et;
			    fma[I][0].x=a_;

			}
			if(J==JM)
			{
			    Jacob=2.0*mJ[I-1][JM-1].x-mJ[I-1][JM-2].x;
			    Ex=2.0*mE[I-1][JM-1].x-mE[I-1][JM-2].x;
			    Ey=2.0*mE[I-1][JM-1].y-mE[I-1][JM-2].y;
			    Nx=2.0*mN[I-1][JM-1].x-mN[I-1][JM-2].x;
			    Ny=2.0*mN[I-1][JM-1].y-mN[I-1][JM-2].y;	
			    
			    /*vetor Ebfront*/
			    Ebfront[I][JM+1].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
			    Ebfront[I][JM+1].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
			    Ebfront[I][JM+1].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
			    Ebfront[I][JM+1].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);
			    
			    fmu[I][JM+1].x=u;
			    fmv[I][JM+1].x=v;
			    fmp[I][JM+1].x=p;
			    fmrho[I][JM+1].x=rho;
			    fmet[I][JM+1].x=et;
			    fma[I][JM+1].x=a_;
			}
			if(I==1)
			{
			    Jacob=2.0*mJ[0][J-1].x-mJ[1][J-1].x;
			    Ex=2.0*mE[0][J-1].x-mE[1][J-1].x;
			    Ey=2.0*mE[0][J-1].y-mE[1][J-1].y;
			    Nx=2.0*mN[0][J-1].x-mN[1][J-1].x;
			    Ny=2.0*mN[0][J-1].y-mN[1][J-1].y;
			    
			    /*vetor Ebfront*/
			    Ebfront[0][J].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
			    Ebfront[0][J].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
			    Ebfront[0][J].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
			    Ebfront[0][J].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);
			    
			    fmu[0][J].x=u;
			    fmv[0][J].x=v;
			    fmp[0][J].x=p;
			    fmrho[0][J].x=rho;
			    fmet[0][J].x=et;
			    fma[0][J].x=a_;
			}
			if(I==IM)
			{
			    Jacob=2.0*mJ[IM-1][J-1].x-mJ[IM-2][J-1].x;
			    Ex=2.0*mE[IM-1][J-1].x-mE[IM-2][J-1].x;
			    Ey=2.0*mE[IM-1][J-1].y-mE[IM-2][J-1].y;
			    Nx=2.0*mN[IM-1][J-1].x-mN[IM-2][J-1].x;
			    Ny=2.0*mN[IM-1][J-1].y-mN[IM-2][J-1].y;
			    
			    /*vetor Ebfront*/
			    Ebfront[IM+1][J].v[1-1]=(Nx*e1+Ny*f1)/(Jacob);
			    Ebfront[IM+1][J].v[2-1]=(Nx*e2+Ny*f2)/(Jacob);
			    Ebfront[IM+1][J].v[3-1]=(Nx*e3+Ny*f3)/(Jacob);
			    Ebfront[IM+1][J].v[4-1]=(Nx*e4+Ny*f4)/(Jacob);
			    
			    fmu[IM+1][J].x=u;
			    fmv[IM+1][J].x=v;
			    fmp[IM+1][J].x=p;
			    fmrho[IM+1][J].x=rho;
			    fmet[IM+1][J].x=et;
			    fma[IM+1][J].x=a_;

			}
		}
	}

	for(I=0;I<=IM+1;I++)
	{
		for(J=0;J<=JM+1;J++)
		{
			fmu[I][J].x=u;
			fmv[I][J].x=v;
			fmp[I][J].x=p;
			fmrho[I][J].x=rho;
			fmet[I][J].x=et;
			fma[I][J].x=a_;			
		}
	}

/*	
	printf("\n    valor de rho=%lf  \n",rho);
	getchar();
	getchar();
	*/

}
/*-------------------------------------------------------*/




/*-------------------------------------------------------*/
/*                  Solucao analitica                    */
/*-------------------------------------------------------*/
void solanali(double gama,double mach,double p1,double ctegas,double T)
{
    /*raiz da equacao 12-261*/
    double r=0.6861575525967377;
    double M1n,p2,rho2,rho1,T2,M2;
    double t1,t2,t3,t4;
    
    M2=1.640522229001082;
    
    M1n=mach*sin(r);
    
    
    rho1=(p1)/(ctegas*T);
    
    t1=(2.0*gama*M1n*M1n)/(gama+1.0);
    
    t2=(gama-1.0)/(gama+1.0);
    
    t1=(2.0*gama)/(gama+1.0);
    
    t2=(M1n*M1n-1.0);
    
    p2=p1*(1.0+(t1*t2));

    t1=(gama+1.0)*M1n*M1n;
    
    t2=(gama-1.0)*M1n*M1n+2.0;
    
    rho2=rho1*(t1/t2);
    
    T2=(T*p2*rho1)/(p1*rho2);
    
    t3=(gama-1)/(2);
    t3=t3*mach*mach+1;

    t4=(gama-1)/(2);
    t4=t4*M2*M2+1;
    
    t4=(t3/t4);
    
    t4=pow(t4,(gama)/(gama-1));

    printf("\nvalor de p1=%lf e rho1=%lf \n",p1,rho1);
    
    printf("\nvalor de p2=%lf e rho2=%lf \n",p2,rho2);
    
     printf("\nvalor de T=%lf e T2=%lf \n",T,T2);
     
      printf("\nvalor de razao=%lf e rho2=%lf \n",p2/p1,t4);
    

}
/*-------------------------------------------------------*/

	

/*-------------------------------------------------------*/
/*           Gera arquivos para plotar no visit          */
/*-------------------------------------------------------*/
void arquivoVisit(unsigned int IM,unsigned int JM,unsigned int ZM,
		  float x[],float y[],float z[],int numero,double t)
{
	
	
	unsigned int I,J,K,cont, NX, NY, NZ;
	NX = IM;
	NY = JM;
	NZ = ZM;

	float pts[3*(ZM)*(IM)*(JM)];
	
	/* Curvilinear mesh points stored x0,y0,z0,x1,y1,z1,...*/
	cont=0;
	for(K=1;K<=ZM;K++)
	{
	  for(J=1;J<=JM;J++) 
	  {
	      for(I=1;I<=IM;I++) 
	      {
		  pts[cont]  =x[I-1];
		  pts[cont+1]=y[J-1];
		  pts[cont+2]=z[K-1];
		  cont=cont+3;
	      }
	  }	
	}	

	int dims[] = {NX, NY, NZ};
	/* Zonal and nodal variable data. */
	float vel[NZ][NY][NX];
	/* Info about the variables to pass to visit_writer. */
	int nvars = 1;
	/*int vardims[] = {1, 1, 1, 1, 1, 1, 1, 1, 1};*/
	int vardims[] = {1};
	int centering[] = {0, 1};
	/*const char *varnames[] = {"Ex", "Ey","mNx","mNy","mu","mv","mp","mrho","met"};*/
	const char *varnames[] = {"vel"};
	/*float *vars[] = {(float *)Ex, (float *)Ey, (float *)mNx, (float *)mNy,(float *)mu, (float *)mv, (float *)mp, (float *)mrho, (float *)met};*/
	float *vars[] = {(float *)vel};
	int i,j,k, index = 0;
	/* Create vel variable */
	for(k = 0; k < NZ; ++k)
	for(j = 0; j < NY; ++j)
	for(i = 0; i < NX; ++i)
	vel[k][j][i] = 0.5*exp(sin(t)*t*0.001*((z[k])*(z[k]))-0.012*cos(sin((sin(x[j])*cos(y[i])))));

	char nomedoarquivo[300]="Arquivos_saida_vtk/arqVisitParaview";
	
	sprintf(nomedoarquivo, "%s%d", nomedoarquivo, numero);/*adiciona o numero da estimativa*/
	strcat(nomedoarquivo,".vtk");/*adiciona texto ao final da string nomedoarquivo*/
	
	/* Pass the data to visit_writer to write a binary VTK file. */
	write_curvilinear_mesh(nomedoarquivo, 1, dims, pts, nvars,
	vardims, centering, varnames, vars);	
}
/*-------------------------------------------------------*/



/*-------------------------------------------------------*/
/*              Determina valor de ht                    */
/*-------------------------------------------------------*/
void determinaht(unsigned int IM,unsigned int JM,
		 grade **mN,grade **mE,grade **fmu,
   		 grade **fmv,double *ht,double CFL,
      		 grade **fma)
{
  
    double Ex,Ey,Nx,Ny,ht_,a,vv,uu,aa;
    double u,v,max1,max2,maxautovalor;
    double lambdaE1,lambdaE2,lambdaE3,lambdaE4;
    double lambdaN1,lambdaN2,lambdaN3,lambdaN4;
    unsigned int I,J,guardaI,guardaJ;
    
    maxautovalor=0.0;
    for(I=1;I<=IM;I++)
    {
       for(J=1;J<=JM;J++)
       {
	    Ex=mE[I-1][J-1].x;
	    Ey=mE[I-1][J-1].y;
	    Nx=mN[I-1][J-1].x;
	    Ny=mN[I-1][J-1].y;
	    
	    u=fmu[I][J].x;
	    v=fmv[I][J].x;
	    a=fma[I][J].x;
	    
	    if((Abs(Ex))>1.0e-15)
	    {
		lambdaE1=Ex*u+Ey*v;
		lambdaE2=Ex*u+Ey*v;	    
		lambdaE3=Ex*u+Ey*v+a*sqrt(Ex*Ex+Ey*Ey);
		lambdaE4=Ex*u+Ey*v-a*sqrt(Ex*Ex+Ey*Ey);
	    }
	    else
	    {
		lambdaE1=Ey*v;
		lambdaE2=Ey*v;	    
		lambdaE3=(v+a)*Ey;
		lambdaE4=(v-a)*Ey;
	    }

	    if((Abs(Nx))>1.0e-15)
	    {
		lambdaN1=Nx*u+Ny*v;
		lambdaN2=Nx*u+Ny*v;	    
		lambdaN3=Nx*u+Ny*v+a*sqrt(Nx*Nx+Ny*Ny);
		lambdaN4=Nx*u+Ny*v-a*sqrt(Nx*Nx+Ny*Ny);
	    }
	    else
	    {
		lambdaN1=Ny*v;
		lambdaN2=Ny*v;	    
		lambdaN3=(v+a)*Ny;
		lambdaN4=(v-a)*Ny; 
	    }
	    
	    max1=max(Abs(lambdaE1),Abs(lambdaE2));
	    max2=max(Abs(lambdaE3),Abs(lambdaN1));
	    max1=max(max1,max2);
	    max2=max(Abs(lambdaN2),Abs(lambdaN3));
	    max1=max(max1,max2);
	    
	    if(max1>maxautovalor)
	    {
		maxautovalor=max1;
		guardaI=I;
		guardaJ=J;
		uu=u;
		vv=v;
		aa=a;
	    }
	}
    }
    
	    
    
    
    
    ht_=(CFL)/(maxautovalor);
    *ht=ht_;
    
 /*   printf("\n maior auto valor=%lf     ht_=%lf   I=%d  J=%d \n",maxautovalor,ht_,guardaI,guardaJ);
    printf("\n uu=%lf     vv=%lf   aa=%lf  CFL=%lf \n",uu,vv,aa,CFL);*/
}
/*-------------------------------------------------------*/









#endif
