/* Este e um exemplo de funcao que grava um arquivo de visualizacao 
   no formato vtk para a visualizacao no visit ou paraview. 
   
   E necessario utilizar o arquivo visit_writer.h 
   Para compilar faca make
   Para apagar make clean
   E para executar make run 

*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "visit_writer.h"

#define NX 10 /* numero de pontos na malha na direcao x */
#define NY 10 /* numero de pontos na malha na direcao y */
#define pi = 3.14159265359

int main(int argc, char *argv[]){
  
  int i, j;
  int bin = 0; /* 0 indica que o arquivo sera no formato ascii.*/
               /* 1 indica que o arquivo sera no formato binario.*/
  double hx, hy;
  double a1 = 0.0, b1 = 1.0, a2 = 0.0, b2 = 1.0; 
  double xn, yn, hx2, hy2;
  double x[NX+1], y[NY+1], z[] = {0.0};
 
  /* Malha */
  int dims[] = {NX+1, NY+1, 1};

  hx = (b1 - a1)/(NX);
  hy = (b2 - a2)/(NY);
  
  hx2 = hx/2.0;
  hy2 = hy/2.0;

  for(i = 0; i <= NX; i++){
    x[i] = a1 + i*hx;
  }

  for(j = 0; j <= NY; j++){
    y[j] = a2 + j*hy;
  }

  /* Variavel "zonal" e  "nodal" */

  double zonal[NY][NX], nodal[NY+1][NX+1];
  
  /* Informacoes sobre as variaveis para passar para 
     o "visit_writer" */

  int nvars = 2;
  int vardims[] = {1,1};
  int centering[] = {0,1};
  const char *varnames[] = {"zonal", "nodal"};
  double *vars[] = {(double*)zonal, (double*)nodal};

  
  /* Cria a variavel "zonal" */
  
  for(j = 0; j < NY; j++){
    for(i = 0; i < NX; i++){
      xn = a1 + hx2 + i*hx;
      yn = a2 + hy2 + j*hy;
      zonal[j][i] = -xn*xn - yn*yn + 2.5;
    }
  }
  
  /* Cria a variavel "nodal" */
  for(j = 0; j <= NY; j++){
    for(i = 0; i <= NX; i++){
      nodal[j][i] = -x[i]*x[i] - y[j]*y[j] + 2.5;
    }
  }
  
  /* Passa os dados para o visit_writer para escrever o arquivo vtk. */

  write_rectilinear_mesh1("exemplo2d.vtk", bin, dims, x, y, z, nvars, vardims, centering, varnames, vars);

  return 0;
}
