/* Este e um exemplo de funcao que grava um arquivo de visualizacao 
   no formato vtk para a visualizacao no visit ou paraview. 
   
   E necessario utilizar o arquivo visit_writer.h 
   Para compilar faca make
   Para apagar make clean
   E para executar make run 

*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "visit_writer.h"

#define NX 10 /* numero de pontos na malha na direcao x */
#define NY 10 /* numero de pontos na malha na direcao y */
#define pi 3.14159265359

double min(double x, double y){
  
  double aux;
  aux = x;
  if(x > y) aux = y;
  return aux;
}

double fphi(double x, double y, double t){

  /*return (-x*x - y*y + 2.5)*exp(-t);*/
  return(cos(2.0*pi*x + 2.0*pi*y + 2.0*t));

}

void print_variavel(int bin, int ct, int nx, int ny, double x[], double y[], double phi[][NX+1]){
  
  double z[] = {0.0};

  /* Malha */
  int dims[] = {nx+1, ny+1, 1};
  
  /* Informacoes sobre as variaveis para passar para 
     o "visit_writer" */
  
  int nvars = 1;
  int vardims[] = {1};
  int centering[] = {1};
  const char *varnames[] = {"Temperatura"};
  double *vars[] = {(double*)phi};
  
  char nomedoarquivo[22];

  /*adiciona o numero da estimativa*/
  sprintf(nomedoarquivo, "temperatura_%05d.vtk", ct); /*temperatura_ct.vtk*/
  
  /* Passa os dados para o visit_writer para escrever o arquivo vtk. */
  write_rectilinear_mesh1(nomedoarquivo, bin, dims, x, y, z, nvars, vardims, centering, varnames, vars);
  
}

int main(int argc, char *argv[]){
  
  int i, j;
  int bin = 0; /* 0 indica que o arquivo sera no formato ascii.*/
               /* 1 indica que o arquivo sera no formato binario.*/
  double hx, hy, t, dt;
  double a1 = 0.0, b1 = 1.0, a2 = 0.0, b2 = 1.0; 
  double x[NX+1], y[NY+1];
  double phi[NY+1][NX+1];
  int ct;
 
  t = 0.0;
  hx = (b1 - a1)/(NX);
  hy = (b2 - a2)/(NY);
  
  for(i = 0; i <= NX; i++){
    x[i] = a1 + i*hx;
  }

  for(j = 0; j <= NY; j++){
    y[j] = a2 + j*hy;
  }

  dt = min(hx,hy);

  for(ct = 1; ct <= 200; ct++){

    /* Cria a variavel temperatura */
    for(j = 0; j <= NY; j++){
      for(i = 0; i <= NX; i++){
	phi[j][i] = fphi(x[i], y[j], t);
	
      }
    }
    
    /*Imprime o arquivo a cada dez passos*/
    if((ct%10)== 0){
      
      print_variavel(bin, ct, NX, NY, x, y, phi);
    }

    t += dt;
    
  }  
  
  return 0;
}
