/*
    Documento : visualizar_exame.js
    Criado em : 18/03/2009, 18:16:00
    Autor     : Victor Williams Stafusa da Silva

    Simuquiz - http://www.simuquiz.com.br
*/

var prova = null;

CarregadorDeTela.executors["visualizar_exame"] = function(area, contexto) {

  function telaCriarQuestao() {
    var dados = $("#form_visualizar_exame").serializeJSON();
    chamarTela("cadastrar_questao", dados);
  }

  function alterarExame() {
    chamarTela2("cadastrar_exame", "alterar_exame", contexto.exame);
  }

  function visualizarUsuario() {
    invocarTelaRemota("visualizar_usuario", "./WebServlet/usuario/" + $("#form_id_proprietario").val());
  }

  function invocarServletListarQuestoes(url) {
    ler(null, url, function(retorno) {
      if (retorno.sucesso) {
        retorno.questoes.each(popularQuestao);
        //trabalharDivMaisQuestoes(retorno);
      } else {
        mostrarErros(retorno.problemas.erro, "mostrar_mensagens_privadas_erros_gerais");
      }
    });
  }

  function listarQuestoes() {
    var idExame = $("#form_id_exame").val();
    invocarServletListarQuestoes("./WebServlet/exame/" + idExame + "/questoes/listar");
    //$(area).find("#botao_listar_questoes").val("Listar mais questes");
  }

  function mostrarQuestao(idQuestao) {
    ler(null, "./WebServlet/questoes/" + idQuestao, function(retorno) {
      retorno.alternativas = new Array();
      retorno.corretas = new Array();
      var a = 0;
      retorno.questao.versaoEmUso.alternativas.each(function(elem, i) {
        retorno.alternativas[i] = elem.texto;
        if (elem.correta) {
          retorno.corretas[a] = i;
          a++;
        }
      });
      retorno.idQuestao = idQuestao;
      retorno.idExame = $("#form_id_exame").val();
      retorno.maxCorretas = retorno.questao.versaoEmUso.maxCorretas;
      retorno.minCorretas = retorno.questao.versaoEmUso.minCorretas;
      retorno.maxAlternativas = retorno.questao.versaoEmUso.maxAlternativas;
      retorno.minAlternativas = retorno.questao.versaoEmUso.minAlternativas;
      retorno.enunciado = retorno.questao.versaoEmUso.enunciado;

      //if (retorno.sucesso) {
        chamarTela2("cadastrar_questao", "alterar_questao", retorno);
      //} else {
        //mostrarErros(retorno.problemas.erro, "mostrar_mensagens_privadas_erros_gerais");
      //}
    });
  }

  function popularQuestao(questao) {
    var t = new CarregadorDeTela();
    t.setNotificarAguarde(false);
    t.setContexto(questao);
    t.setNome("lista_questoes");
    t.setCallback(function() {
      var novo = $(t.getTexto());
      $("#questoes_exame").append(novo);
      var id = novo.children(".lista_questoes_id").html();
      novo.click(function() { mostrarQuestao(id); });
    });
    t.carregarXhtml();
  }

  function iniciarProva() {
    var idExame = $("#form_id_exame").val();
    enviar(null, "./WebServlet/exame/" + idExame + "/prova", function(retorno) {
      prova = retorno;

      prova.questaoAtual = 0;
      prova.questionario = new Array();

      var idx = 0;
      for (elem in prova.questoes) {
          var questao = new Object();
          prova.questionario[idx] = questao;
          questao.enunciado = prova.questoes[elem].enunciado;
          questao.numero = prova.questoes[elem].numeroOrdem;
          var alternativas = new Array();
          questao.alternativas = alternativas;
          for (i = 0; i < prova.questoes[elem].textosAlternativas.length; i++) {
              var alternativa = new Object();
              alternativas[i] = alternativa;
              alternativa.texto = prova.questoes[elem].textosAlternativas[i];
              alternativa.chave = prova.questoes[elem].chavesAlternativas[i];
              alternativa.marcada = false;
          }
          idx++;
      }

      chamarTela("questao_prova", prova.questionario[0]);
    });
  }

  $(area).find("#botao_fazer_prova").click(iniciarProva);
  $(area).find("#botao_criar_questao").click(telaCriarQuestao);
  $(area).find("#botao_listar_questoes").click(listarQuestoes);
  $(area).find("#botao_alterar_exame").click(alterarExame);
  $(area).find("#visualiar_exame_link_proprietario").click(visualizarUsuario);
};