/*
    Documento : menu.js
    Criado em : 03/05/2009, 23:29
    Autor     : Victor Williams Stafusa da Silva

    Simuquiz - http://www.simuquiz.com.br
*/

CarregadorDeTela.executors["menu"] = function(area, contexto) {

  function logout() {
    enviar("", "./WebServlet/usuario/logout", function(resposta) {
      var t = new CarregadorDeTela();
      t.setNotificarAguarde(true);
      t.setNome("login");
      t.setCallback(t.carregarDestino("div_login"));
      t.setContexto(resposta);
      t.carregarXhtml();

      $("#menu_visitantes").show();
      $("#menu_usuarios").hide();
      usuarioLogado = null;
      telaMensagem(" ");
    });
  }

  $(area).find("#menu_cadastrar_usuario")
      .click(function() { chamarTela('cadastrar_usuario', {problemas: {}}); });

  $(area).find("#menu_buscar_exames")
      .click(function() { chamarTela('buscar_exames', null); });

  $(area).find("#menu_criar_exame")
      .click(function() { chamarTela('cadastrar_exame', null); });

  $(area).find("#menu_listar_mps")
      .click(function() { chamarTela('mostrar_mensagens_privadas', null); });

  $(area).find("#menu_alterar_usuario")
      .click(function() {
        usuarioLogado.confirmacaoEmail = usuarioLogado.email;
        chamarTela2('cadastrar_usuario', 'alterar_usuario', { entrada: usuarioLogado });
      });

  $(area).find("#menu_listar_provas")
      .click(function() {
        invocarTelaRemota("lista_prova", "./WebServlet/provas");
      });

  $(area).find("#menu_logout")
      .click(logout);
};