/*
    Documento : js_pre_proc.js
    Criado em : 25/03/2009 22:20
    Autor     : Victor Williams Stafusa da Silva

    Simuquiz - http://www.simuquiz.com.br
 */

function JsPreProcCallable(func) {
  this.invoke = func;
}

function interpretar(__resultado__, __contexto__) {

  // Executa a funo annima criada.
  try {
    alert(__resultado__);
    return eval(__resultado__);
  } catch (er) {
    alert(er.toString());
    alert(__resultado__);
    throw er;
  }
}

/**
 * Faz a avaliao de uma template em javascript.
 * @param template O texto da template a ser processada.
 * @param __contexto__ Objeto contendo atributos a serem usados no processamento
 * do template.
 * @return String resultante do processamento do template, com as expresses
 * e blocos javascript j processadas.
 */
function processarTemplate(template, __contexto__) {

  /**
   * Construtor de um objeto que representa um autmato finito.
   * Deve ser criado depois que os estados e as transies so criadas.
   * Os estados se tornam acessveis ao autmato navegando atravs de
   * transies, iniciando no estado inicial.
   * @param estadoInicial O estado inicial do autmato.
   */
  function Automato(estadoInicial) {
    this.executar = function(entrada) {
      var estado = estadoInicial;
      for (var i = 0; i < entrada.length; i++) {
        if (estado == null) throw new Error("No h estado definido.");
        estado = estado.executarTransicao(entrada.charAt(i));
      }
      return estado;
    };
  }

  /**
   * Construtor de um objeto que representa um estado de um autmato finito.
   * @param nome O nome dado ao estado. No interfere no funcionamento do
   * autmato, mas ajuda no debug.
   */
  function Estado(nome) {
    var transicoes = new Object();
    var transicaoDefault = null;

    this.getNome = function() {
      return nome;
    };

    this.addTransicao = function(transicao) {
      transicoes[transicao.getEntrada()] = transicao;
    };

    this.getTransicao = function(c) {
      return transicoes[c];
    };

    this.setTransicaoDefault = function(novaTransicaoDefault) {
      transicaoDefault = novaTransicaoDefault;
    };

    this.getTransicaoDefault = function() {
      return transicaoDefault;
    };

    var transicaoParaFazer = function(c) {
      var transicao = transicoes[c];
      if (transicao == null || transicao == undefined) {
        if (transicaoDefault != null) return transicaoDefault;
        throw new Error("Erro lxico: No h destino para " + c + " no estado " + nome + ".");
      }
      return transicao;
    }

    this.executarTransicao = function(c) {
      return transicaoParaFazer(c).executar(c);
    };
  }

  /**
   * Construtor de um objeto que representa uma transio entre estados em um
   * autmato finito.
   * @param destino O estado de destino da transio.
   * @param entrada Caractere que ativa a transio.
   * @param acao Callback executado quando a transio  acionada.
   */
  function Transicao(destino, entrada, acao) {
    this.getEntrada = function() { return entrada; };
    this.executar = function(c) { if (acao != null) acao(c); return destino; };
  }

  /**
   * Construtor de um objeto que representa a transio padro entre estados
   * de um autmato finito. Esta transio  usada quando no h nenhuma
   * transieso no estado que sirva para o caractere de entrada.
   * @param destino O estado de destino da transio.
   * @param acao Callback executado quando a transio  acionada.
   */
  function TransicaoDefault(destino, acao) {
    this.executar = function(c) { if (acao != null) acao(c); return destino; };
  }

  // Para que o contexto seja acessvel em uma funo annima dentro do eval,
  // realiza-se o seguinte truque: Cada elemento do contexto se torna um
  // parmetro da funo, e esta  invocada utilizando-se o contedo das
  // variveis. Neste trecho, obtm-se os parmetros reais e os parmetros
  // formais do objeto.
  var paramReais = "";
  var paramFormais = "";
  var primeiro = true;
  for (var elemento in __contexto__) {
    if (primeiro) {
      primeiro = false;
    } else {
      paramReais += ",";
      paramFormais += ",";
    }
    paramReais += "__contexto__." + elemento;
    paramFormais += elemento;
  }

  // Cria o cabealho da funo annima a ser usada para fazer o processamento.
  var resultado = "(new JsPreProcCallable(function(" + paramFormais + ") { var __resposta__ = \"";

  // Define funes callback para as transies.
  function concatenaTexto(c) {
    if (c == '\n') c = "\\n";
    else if (c == '\t') c = "\\t";
    else if (c < ' ') c = " ";
    resultado += c;
  }
  function concatenaBruto(c) { resultado += c; }
  function concatenaAspas(c) { resultado += "\\\""; }
  function concatenaFechaChavesMais(c) { resultado += '}'; concatenaTexto(c); }
  function concatenaMaiorMais(c) { resultado += '>'; concatenaTexto(c); }
  function concatenaBarra(c) { resultado += "\\\\"; }
  function concatenaTil(c) { resultado += "\\~"; }
  function concatenaQuebraLinha(c) { resultado += "\\n"; }
  function concatenaTab(c) { resultado += "\\t"; }
  function concatenaFechaChaves(c) { resultado += '}'; }
  function concatenaMaior(c) { resultado += '>'; }
  function comecaExpressao(c) { resultado += "\"; try { __resposta__ += ("; }
  function terminaExpressao(c) { resultado += "); } catch (e) {} __resposta__ += \""; }
  function comecaScript(c) { resultado += "\"; "; }
  function terminaScript(c) { resultado += "; __resposta__ += \""; }

  // Cria os estados do autmato que faz o processamento da template.
  var texto = new Estado("Texto");
  var escapeTexto = new Estado("Escape de texto");
  var til = new Estado("Til");
  var expressao = new Estado("Expresso");
  var escapeExpressao = new Estado("Escape na expresso");
  var saindoExpressao = new Estado("Saindo da expresso");
  var script = new Estado("Script");
  var escapeScript = new Estado("Escape em script");
  var saindoScript = new Estado("Saindo do script");

  // Cria as transies do autmato que faz o processamento da template.
  texto.setTransicaoDefault(new TransicaoDefault(texto, concatenaTexto));
  texto.addTransicao(new Transicao(texto, '\"', concatenaAspas));
  texto.addTransicao(new Transicao(til, '~', null));
  texto.addTransicao(new Transicao(escapeTexto, '\\', null));

  escapeTexto.addTransicao(new Transicao(texto, '\\', concatenaBarra));
  escapeTexto.addTransicao(new Transicao(texto, '~', concatenaTil));
  escapeTexto.addTransicao(new Transicao(texto, 'n', concatenaQuebraLinha));
  escapeTexto.addTransicao(new Transicao(texto, 't', concatenaTab));

  til.addTransicao(new Transicao(expressao, '{', comecaExpressao));
  til.addTransicao(new Transicao(script, '<', comecaScript));

  expressao.setTransicaoDefault(new TransicaoDefault(expressao, concatenaTexto));
  expressao.addTransicao(new Transicao(expressao, '\n', concatenaBruto));
  expressao.addTransicao(new Transicao(expressao, '\t', concatenaBruto));
  expressao.addTransicao(new Transicao(escapeExpressao, '\\', null));
  expressao.addTransicao(new Transicao(escapeExpressao, '~', null));
  expressao.addTransicao(new Transicao(saindoExpressao, '}', null));

  escapeExpressao.addTransicao(new Transicao(expressao, '\\', concatenaBarra));
  escapeExpressao.addTransicao(new Transicao(expressao, '~', concatenaTil));
  escapeExpressao.addTransicao(new Transicao(expressao, '\"', concatenaAspas));
  escapeExpressao.addTransicao(new Transicao(expressao, 'n', concatenaQuebraLinha));
  escapeExpressao.addTransicao(new Transicao(expressao, 't', concatenaTab));

  saindoExpressao.setTransicaoDefault(new TransicaoDefault(expressao, concatenaFechaChavesMais));
  saindoExpressao.addTransicao(new Transicao(escapeExpressao, '\\', concatenaFechaChaves));
  saindoExpressao.addTransicao(new Transicao(texto, '~', terminaExpressao));
  saindoExpressao.addTransicao(new Transicao(saindoExpressao, '}', concatenaFechaChaves));

  script.setTransicaoDefault(new TransicaoDefault(script, concatenaTexto));
  script.addTransicao(new Transicao(script, '\n', concatenaBruto));
  script.addTransicao(new Transicao(script, '\t', concatenaBruto));
  script.addTransicao(new Transicao(escapeScript, '\\', null));
  script.addTransicao(new Transicao(escapeScript, '~', null));
  script.addTransicao(new Transicao(saindoScript, '>', null));

  escapeScript.addTransicao(new Transicao(script, '\\', concatenaBarra));
  escapeScript.addTransicao(new Transicao(script, '~', concatenaTil));
  escapeScript.addTransicao(new Transicao(script, '\"', concatenaAspas));
  escapeScript.addTransicao(new Transicao(script, 'n', concatenaQuebraLinha));
  escapeScript.addTransicao(new Transicao(script, 't', concatenaTab));

  saindoScript.setTransicaoDefault(new TransicaoDefault(script, concatenaMaiorMais));
  saindoScript.addTransicao(new Transicao(escapeScript, '\\', concatenaMaior));
  saindoScript.addTransicao(new Transicao(texto, '~', terminaScript));
  saindoScript.addTransicao(new Transicao(saindoScript, '}', concatenaMaior));

  // Cria o autmato que constroi o corpo da funo annima que processa o
  // template e o executa.
  var estadoFinal = new Automato(texto).executar(template);
  if (estadoFinal != texto) throw new Error("Fim inesperado do texto.");

  // Finaliza a funo annima que avalia o template.
  resultado += "\"; return __resposta__;}).invoke(" + paramReais + "))";

  // Executa a funo annima criada.
  //interpretar(resultado, contexto);
  try {
    //alert(resultado);
    return eval(resultado);
  } catch (er) {
    alert(er.toString());
    alert(resultado);
    throw er;
  }
}