/*
 * 19/05/2009, 08:49.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.testes.web;

import br.com.simuquiz.testes.TesteDoTeste;
import br.com.simuquiz.web.Mapeador;
import br.com.simuquiz.web.ParametrosRequisicao;
import org.junit.Test;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class MocksMapeadores {
    public MocksMapeadores() {}

    @Test
    public void autoTeste() {
        TesteDoTeste.verificarSeTodosOsMocksSaoEstaticos();
    }

    /**
     * Mock que no faz nada, mas funciona.
     */
    public static class MapeadorNaoFazNada implements Mapeador {
        @Override
        public void executar(ParametrosRequisicao requisicao) {}
    }

    /**
     * Mock que no funciona. Mapeadores devem ser concretos.
     */
    public static abstract class MapeadorZoadoAbstrato implements Mapeador {}

    /**
     * Mock que no funciona. Mapeadores devem ser concretos.
     */
    public static interface MapeadorZoadoInterface extends Mapeador {}

    /**
     * Mock que no funciona. Mapeadores devem ser pblicos.
     */
    static class MapeadorZoadoPackagePrivate implements Mapeador {
        @Override
        public void executar(ParametrosRequisicao requisicao) {}
    }

    /**
     * Mock que no funciona. Mapeadores devem ter construtores pblicos.
     */
    public static class MapeadorZoadoComConstrutorPrivado implements Mapeador {
        private MapeadorZoadoComConstrutorPrivado() {}

        @Override
        public void executar(ParametrosRequisicao requisicao) {}
    }

    /**
     * Mock que no funciona. Mapeadores no devem lanar excees no construtor.
     */
    public static class MapeadorZoadoComExcecaoNoConstrutor implements Mapeador {
        public MapeadorZoadoComExcecaoNoConstrutor() {
            throw new MockException();
        }

        @Override
        public void executar(ParametrosRequisicao requisicao) {}
    }

    /**
     * Mock que no funciona. O construtor vlido no tem parmetros.
     */
    public static class MapeadorZoadoComConstrutorErrado implements Mapeador {
        public MapeadorZoadoComConstrutorErrado(String x) {}

        @Override
        public void executar(ParametrosRequisicao requisicao) {}
    }
}
