/*
 * 07/02/2009, 20:22.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */

package br.com.simuquiz.testes.entidades;

import br.com.simuquiz.conexao.Database;
import br.com.simuquiz.entidades.Usuario;
import br.com.simuquiz.testes.TesteDoTeste;
import org.junit.After;
import static org.junit.Assert.*;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

/**
 * @author Victor Williams Stafusa da Silva
 * @author Andr Luiz Pereira lvares
 */
public class TestaUsuario {

    @Test
    public void autoTeste() {
        TesteDoTeste.verificarSeNaoEsqueceuAnotacaoTest();
    }

    private static final String LOGIN_TESTE = "abc";
    private static final String SENHA_TESTE = "xyz";
    private static final String NOME_TESTE = "Z";
    private static final String EMAIL_TESTE = "a@a.com";
    private static final String LOGIN_SENHA_LIXO = "xxxxxx";

    @Before
    public void subir() {
        Database.init();
    }

    @After
    public void descer() {
        Database.close();
    }

    private Usuario criarUmNovoUsuario() {
        return Usuario.novo(NOME_TESTE, LOGIN_TESTE, SENHA_TESTE, EMAIL_TESTE);
    }

    private void criarVariosNovosUsuariosInuteis() {
        Usuario.novo("Aaaa", "Bbbb", "Cccc", "d@d.com");
        Usuario.novo("Eeee", "Ffff", "Gggg", "h@h.com");
        Usuario.novo("Iiii", "Jjjj", "Kkkk", "l@l.com");
        Usuario.novo("Mmmm", "Nnnn", "Oooo", "p@p.com");
    }

    private Usuario criarVariosUsuariosInuteisEUmInteressante() {
        Usuario.novo("Aaaa", "Bbbb", "Cccc", "d@d.com");
        Usuario.novo("Eeee", "Ffff", "Gggg", "h@h.com");
        Usuario interessante = criarUmNovoUsuario();
        Usuario.novo("Iiii", "Jjjj", "Kkkk", "l@l.com");
        Usuario.novo("Mmmm", "Nnnn", "Oooo", "p@p.com");
        return interessante;
    }

    /*@Test
    public void x() {
        Usuario.listarTudo();
    }*/

    @Test
    public void testaNovo() {
        Usuario u = criarUmNovoUsuario();
        assertNotNull(u);
    }

    @Test
    public void testaSeIdFoiCriado() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        assertNotSame(0L, u.getIdUsuario());
    }

    @Test
    public void testaSeLoginFoiCriadoCerto() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        assertEquals(LOGIN_TESTE, u.getLogin());
    }

    @Test
    public void testaSeSenhaFoiCriadaCerta() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        assertEquals(SENHA_TESTE, u.getSenha());
    }

    @Test
    public void testaSeNomeFoiCriadaCerto() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        assertEquals(NOME_TESTE, u.getNome());
    }

    @Test
    public void testaSeEmailFoiCriadoCerto() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        assertEquals(EMAIL_TESTE, u.getEmail());
    }

    @Test
    public void testaPesquisaPorId() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        long id = u.getIdUsuario();
        Usuario v = Usuario.pesquisarPorId(id);
        assertSame(u, v);
    }

    @Test
    public void testaPesquisaPorIdErrado() {
        criarVariosNovosUsuariosInuteis();
        Usuario v = Usuario.pesquisarPorId(-1L);
        assertNull(v);
    }

    @Test
    public void testaPesquisaComLoginESenha() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        Usuario v = Usuario.login(LOGIN_TESTE, SENHA_TESTE);
        assertSame(u, v);
    }

    @Test
    public void testaPesquisaComLoginESenhaComSenhaErrada() {
        criarVariosNovosUsuariosInuteis();
        Usuario v = Usuario.login(LOGIN_TESTE, LOGIN_SENHA_LIXO);
        assertNull(v);
    }

    @Test
    public void testaPesquisaPorLogin() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        Usuario v = Usuario.pesquisarPorLogin(LOGIN_TESTE);
        assertSame(u, v);
    }

    @Test
    public void testaPesquisaPorLoginInexistente() {
        criarVariosNovosUsuariosInuteis();
        Usuario v = Usuario.pesquisarPorLogin(LOGIN_SENHA_LIXO);
        assertNull(v);
    }

    @Test
    public void testaMudaNome() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        u.atualizar("Florentina", u.getLogin(), u.getSenha(), u.getEmail());
        Usuario v = Usuario.pesquisarPorId(u.getIdUsuario());
        assertEquals("Florentina", v.getNome());
    }

    @Test
    public void testaMudaLogin() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        u.atualizar(u.getNome(), "Tiririca", u.getSenha(), u.getEmail());
        Usuario v = Usuario.pesquisarPorId(u.getIdUsuario());
        assertEquals("Tiririca", v.getLogin());
    }

    @Test
    public void testaMudaSenha() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        u.atualizar(u.getNome(), u.getLogin(), "Bundalele", u.getEmail());
        Usuario v = Usuario.pesquisarPorId(u.getIdUsuario());
        assertEquals("Bundalele", v.getSenha());
    }

    @Test
    public void testaMudaEmail() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        u.atualizar(u.getNome(), u.getLogin(), u.getSenha(), "naomandespam@gmail.com");
        Usuario v = Usuario.pesquisarPorId(u.getIdUsuario());
        assertEquals("naomandespam@gmail.com", v.getEmail());
    }

    @Test
    public void testaPesquisarLoginAntigoAposMudar() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        String loginAntigo = u.getLogin();
        u.atualizar(u.getNome(), "Tiririca", u.getSenha(), u.getEmail());
        Usuario v = Usuario.pesquisarPorLogin(loginAntigo);
        assertNull(v);
    }

    @Test
    public void testaLogarAposMudarLogin() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        String loginAntigo = u.getLogin();
        u.atualizar(u.getNome(), "Tiririca", u.getSenha(), u.getEmail());
        Usuario v = Usuario.login(loginAntigo, u.getSenha());
        assertNull(v);
    }

    @Test
    public void testaLogarAposMudarSenha() {
        Usuario u = criarVariosUsuariosInuteisEUmInteressante();
        String senhaAntiga = u.getSenha();
        u.atualizar(u.getNome(), u.getLogin(), "Esqueci a senha", u.getEmail());
        Usuario v = Usuario.login(u.getLogin(), senhaAntiga);
        assertNull(v);
    }

    @Test(expected=RuntimeException.class)
    @Ignore // No valida se j existe. Isso deveria ficar para o cadastro ou para a entidade?
    public void testaNovoUsuarioLoginDuplicado() {
        Usuario.novo(NOME_TESTE, LOGIN_TESTE, SENHA_TESTE, EMAIL_TESTE);
        Usuario.novo(NOME_TESTE + "$", LOGIN_TESTE, SENHA_TESTE + "$", EMAIL_TESTE + "$");
    }

    @Test(expected=RuntimeException.class)
    @Ignore // No valida se j existe. Isso deveria ficar para o cadastro ou para a entidade?
    public void testaNovoUsuarioDuplicado() {
        Usuario.novo(NOME_TESTE, LOGIN_TESTE, SENHA_TESTE, EMAIL_TESTE);
        Usuario.novo(NOME_TESTE, LOGIN_TESTE, SENHA_TESTE, EMAIL_TESTE);
    }
}
