/*
 * 19/05/2009, 11:21.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.testes;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class TesteDoTeste {

    private static final String ESTA_CLASSE = TesteDoTeste.class.getName();

    private TesteDoTeste() {}

    private static Class<?> quemMeChamou() {

        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        String nome = null;
        for (StackTraceElement ste : stackTrace) {
            nome = ste.getClassName();
            if (!nome.startsWith("java.lang") && !nome.equals(ESTA_CLASSE)) break;
        }
        try {
            return Class.forName(nome);
        } catch (Throwable t) {
            throw new AssertionError(t);
        }
    }

    /**
     * Isso aqui  para garantir que o teste no est errado simplesmente porque
     * foi esquecido de colocar-se a anotao Test em algum mtodo a ser
     * testado ou se esta foi colocada em algum mtodo no-pblico. Assume que
     * todos os mtodos pblicos no estticos deveriam ter a anotao Test e
     * que nenhum mtodo no pblico deveria t-la.
     * No  preciso especificar a classe a ser verificada. Assume ser a classe
     * chamadora deste mtodo, que  obtida olhando-se no stack trace.
     */
    public static void verificarSeNaoEsqueceuAnotacaoTest() {
        Class<?> chamou = quemMeChamou();

        for (Method m : chamou.getMethods()) {
            if (!m.isAnnotationPresent(Test.class)
                    && m.getDeclaringClass() != Object.class
                    && !m.isAnnotationPresent(Before.class)
                    && !m.isAnnotationPresent(After.class)
                    && !m.isAnnotationPresent(Ignore.class)
                    && !m.isAnnotationPresent(BeforeClass.class)
                    && !m.isAnnotationPresent(AfterClass.class)
                    && !m.isSynthetic()) {
                fail(m.getName());
            }
        }

        for (Method m : chamou.getDeclaredMethods()) {
            int modifiers = m.getModifiers();
            if (!Modifier.isPublic(modifiers) && m.isAnnotationPresent(Test.class)) {
                fail(m.getName());
            }
        }
    }

    /**
     * Isto  para evitar um bug que surgiu durante o desenvolvimento por causa
     * de testes que falhavam, ou que passavam erronemente por causa de classes
     * mock que no haviam sido definidas corretamente.
     * No  preciso especificar a classe a ser verificada. Assume ser a classe
     * chamadora deste mtodo, que  obtida olhando-se no stack trace.
     */
    public static void verificarSeTodosOsMocksSaoEstaticos() {
        for (Class<?> c : quemMeChamou().getDeclaredClasses()) {
            int modifiers = c.getModifiers();
            if (!Modifier.isStatic(modifiers)) fail(c.getSimpleName());
            if (c.isAnonymousClass()) fail(c.getSimpleName());
            if (c.isLocalClass()) fail(c.getSimpleName());
            if (Modifier.isPrivate(modifiers)) fail(c.getSimpleName());
            if (!Modifier.isPublic(modifiers) && !c.getName().contains("PackagePrivate")) fail(c.getSimpleName());
        }
    }
}
