/*
 * 07/02/2009, 20:24.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */

package br.com.simuquiz.testes;

import br.com.simuquiz.conexao.Database;
import static org.junit.Assert.*;
import org.junit.Test;

/**
 * @author Victor Williams Stafusa da Silva
 * @author Andr Luiz Pereira lvares
 */
public class TesteConexao {

    @Test
    public void autoTeste() {
        TesteDoTeste.verificarSeNaoEsqueceuAnotacaoTest();
    }

    /**
     * Testa se consegue fazer todo o mapeamento objeto-relacional e
     * inicializar e fechar o BD corretamente.
     * Embora isso seja muita coisa para um s teste,  muito difcil separar
     * essas etapas.
     */
    @Test
    public void testarConexao() {
        Database.init();
        assertNotNull(Database.getEntityManager());
        Database.close();
        assertNull(Database.getEntityManager());
    }

    /**
     * Testa se consegue abrir e fechar o BD vrias vezes.
     */
    @Test
    public void testarAbrirFechar() {
        testarConexao();
        testarConexao();
        testarConexao();
    }

    /**
     * Testa se fechar o Database sem abr-lo causa problemas ou no.
     */
    @Test
    public void testarNaoAberta() {
        Database.close();
    }
}
