/*
 * 20/05/2009, 07:13.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class RegistroCaminho<E> {

    private class Nodo {
        private final Nodo pai;
        private final Map<String, Nodo> filhos;
        private final String nome;
        private List<String> caminhoOriginal;
        private E valor;

        public Nodo() {
            this("", null);
        }

        private Nodo(String nome, Nodo pai) {
            this.pai = pai;
            this.filhos = new HashMap<String, Nodo>();
            this.nome = nome;
        }

        public boolean put(List<String> lista, E web) {
            return put(lista.iterator(), web, Collections.unmodifiableList(lista));
        }

        private boolean put(Iterator<String> it, E web, List<String> caminhoOriginal) {
            if (!it.hasNext()) {
                if (valor != null) return false;
                this.valor = web;
                this.caminhoOriginal = caminhoOriginal;
                return true;
            }

            String v = it.next();
            String u = (v.startsWith("?") ? "?" : v);

            Nodo filho = filhos.get(u);
            if (filho == null) {
                filho = new Nodo(v, this);
                filhos.put(u, filho);
            }

            return filho.put(it, web, caminhoOriginal);
        }

        public E get(Iterable<String> it) {
            return get(it.iterator());
        }

        public E get(Iterator<String> it) {
            if (!it.hasNext()) return this.valor;
            Nodo filho = traverse(it.next());
            return (filho == null) ? null : filho.get(it);
        }

        public List<String> caminhoOriginal(Iterator<String> it) {
            if (!it.hasNext()) return this.caminhoOriginal;
            Nodo filho = traverse(it.next());
            return (filho == null) ? null : filho.caminhoOriginal(it);
        }

        @Override
        public String toString() {
            return pai == null ? "" : (pai.toString() + "/" + nome);
        }

        public Nodo traverse(String v) {
            Nodo filho = filhos.get(v);
            if (filho == null) filho = filhos.get("?");
            return filho;
        }

        private String nomeOriginal() {
            if (this.caminhoOriginal == null) return "";
            StringBuilder sb = new StringBuilder(" - ");
            for (String s : this.caminhoOriginal) {
                sb.append("? ").append(s);
            }
            return sb.toString();
        }
        public void dump() {
            System.out.println((valor == null ? "  " : "* ") + toString() + nomeOriginal());
            for (Nodo filho : filhos.values()) {
                filho.dump();
            }
        }
    }

    private boolean vazio;
    private final Nodo raiz;

    public RegistroCaminho() {
        this.raiz = new Nodo();
        this.vazio = true;
    }

    public boolean isEmpty() {
        return vazio;
    }

    public boolean put(E func, List<String> caminho) {
        boolean resultado = raiz.put(caminho, func);
        if (resultado) this.vazio = false;
        return resultado;
    }

    public boolean permite(HttpMethod metodo) {
        return raiz.traverse(metodo.name()) != null;
    }

    public E get(List<String> lista) {
        return raiz.get(lista);
    }

    public Map<String, String> coringas(List<String> lista) {

        List<String> caminhoOriginal = raiz.caminhoOriginal(lista.iterator());
        if (caminhoOriginal == null) return null;
        if (lista.isEmpty()) return Collections.emptyMap();

        Map<String, String> destino = new HashMap<String, String>();

        Iterator<String> it1 = lista.iterator();
        Iterator<String> it2 = caminhoOriginal.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            String e1 = it1.next();
            String e2 = it2.next();
            if (e2.startsWith("?")) destino.put(e2.substring(1), e1);
        }
        return destino;
    }

    public void dump() {
        raiz.dump();
    }
}
