/*
 * 20/05/2009, 18:13.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.web;

import br.com.simuquiz.util.ReflectionUtils;
import br.com.simuquiz.util.ReflectionUtils.StringParseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class ParametrosRequisicao {

    private final Map<ParamSource, Map<String, Object>> parametrosReais;
    private final Map<ParamSource, Map<String, Type>> parametrosFormais;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final FuncionalidadeRest web;
    private final Object instancia;
    private Integer codigoStatus = null;

    public ParametrosRequisicao(Object instancia, FuncionalidadeRest web, HttpServletRequest request, HttpServletResponse response, Map<String, String> coringas) throws StringParseException {
        this.parametrosFormais = web.tiposParametros();
        this.request = request;
        this.response = response;
        this.web = web;
        this.instancia = instancia;

        parametrosReais = new EnumMap<ParamSource, Map<String, Object>>(ParamSource.class);
        for (ParamSource ps : ParamSource.values()) {
            parametrosReais.put(ps, new HashMap<String, Object>());
        }

        // L os parmetros da requisio.
        preencherParametrosRequest();

        // L os parmetros cookies.
        //preencherParametrosCookies();

        // L os parmetros da sesso.
        if (request.getSession(false) != null) {
            preencherParametrosSession();
        }

        // L os parmetros da URL.
        preencherParametrosURL(coringas);
    }

    public Map<ParamSource, Map<String, Object>> getParametrosReais() {
        return parametrosReais;
    }

    public Map<ParamSource, Map<String, Type>> getParametrosFormais() {
        return parametrosFormais;
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public HttpServletResponse getResponse() {
        return response;
    }

    public FuncionalidadeRest getFuncionalidade() {
        return web;
    }

    public Object getInstancia() {
        return instancia;
    }

    public Integer getCodigoStatus() {
        return codigoStatus;
    }

    public Object executar() throws InvocationTargetException {
        try {
            Object retorno = web.invocar(instancia, parametrosReais);
            codigoStatus = web.statusSucessoDefault();
            response.setStatus(codigoStatus);
            return retorno;
        } catch (InvocationTargetException e) {
            e.printStackTrace();
            codigoStatus = web.codigoErro(e.getCause());
            response.setStatus(codigoStatus);
            throw e;
        }
    }

    private void preencherParametrosRequest() throws StringParseException {

        Map<String, Type> parametros = parametrosFormais.get(ParamSource.REQUEST);

        @SuppressWarnings("unchecked")
        Map<String, String[]> reaisRequest = (Map<String, String[]>) request.getParameterMap();

        for (Map.Entry<String, String[]> entry : reaisRequest.entrySet()) {
            Type formal = parametros.get(entry.getKey());
            if (formal == null) continue; // Parmetro irrelevante enviado a mais. Provavelmente lixo.
            adicionarParametroRequest(entry.getKey(), entry.getValue());
        }
    }

    public void adicionarParametroRequest(String nome, String[] valor) throws StringParseException {
        Type formal = parametrosFormais.get(ParamSource.REQUEST).get(nome);
        Object real = ReflectionUtils.representarComoRequest(formal, valor);
        parametrosReais.get(ParamSource.REQUEST).put(nome, real);
    }

    private void preencherParametrosSession() {
        HttpSession session = request.getSession(false);
        if (session == null) throw new IllegalStateException();

        @SuppressWarnings("unchecked")
        Enumeration<String> nomes = (Enumeration<String>) session.getAttributeNames();

        Map<String, Type> parametros = parametrosFormais.get(ParamSource.SESSION);
        Map<String, Object> reais = parametrosReais.get(ParamSource.SESSION);

        while (nomes.hasMoreElements()) {
            String nome = nomes.nextElement();
            Type formal = parametros.get(nome);
            if (formal == null) continue; // Varivel de sesso irrelevante.
            reais.put(nome, session.getAttribute(nome));
        }
    }

    public void adicionarParametroSession(String nome, Object valor) {
        HttpSession session = request.getSession(false);
        if (session == null) throw new IllegalStateException();
        Type formal = parametrosFormais.get(ParamSource.SESSION).get(nome);
        if (formal == null) throw new IllegalArgumentException();
        parametrosReais.get(ParamSource.SESSION).put(nome, valor);
        session.setAttribute(nome, valor);
    }

    /*private void preencherParametrosCookies() throws StringParseException {

        Map<String, Type> parametros = parametrosFormais.get(ParamSource.COOKIE);

        Cookie[] cookies = request.getCookies();

        for (Cookie cookie : cookies) {
            Type formal = parametros.get(cookie.getName());
            if (formal == null) continue; // Parmetro irrelevante enviado a mais. Provavelmente lixo.
            if (formal != Cookie.class) throw new IllegalStateException();
            adicionarParametroCookie(cookie.getName(), cookie);
        }
    }

    public void adicionarParametroCookie(String nome, Cookie cookie) throws StringParseException {
        Type formal = parametrosFormais.get(ParamSource.COOKIE).get(nome);
        if (formal == null) throw new IllegalArgumentException();
        parametrosReais.get(ParamSource.COOKIE).put(nome, cookie);
    }*/

    private void preencherParametrosURL(Map<String, String> coringas) throws StringParseException {
        for (Map.Entry<String, String> p : coringas.entrySet()) {
            adicionarParametroURL(p.getKey(), p.getValue());
        }
    }

    public void adicionarParametroURL(String nome, Object valor) throws StringParseException {
        Type formal = parametrosFormais.get(ParamSource.URL).get(nome);
        if (formal == null) {
            throw new IllegalArgumentException();
        }
        Object real = ReflectionUtils.representarComoURL(formal, valor == null ? null : valor.toString());
        parametrosReais.get(ParamSource.URL).put(nome, real);
    }
}
