/*
 * 20/05/2009, 23:00.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.web;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class MapeadorPlainText implements Mapeador {

    @Override
    public void executar(ParametrosRequisicao requisicao) throws IOException {
        HttpServletResponse response = requisicao.getResponse();

        try {
            Object resposta = requisicao.executar();

            // Escreve a resposta.
            response.setContentType("text/plain; charset=ISO-8859-1");
            response.setHeader("Cache-Control", "no-cache");
            response.getWriter().write(resposta.toString());
        } catch (InvocationTargetException e) {
            // No faz nada. Um status de erro j deve ter sido setado.
        }
    }
}
