/*
 * 20/05/2009, 20:38.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.servlets;

import br.com.simuquiz.entidades.Exame;
import br.com.simuquiz.entidades.MensagemPrivada;
import br.com.simuquiz.entidades.Prova;
import br.com.simuquiz.entidades.Usuario;
import br.com.simuquiz.funcionalidades.exame.FuncionalidadeAlterarExame;
import br.com.simuquiz.funcionalidades.exame.FuncionalidadeCadastrarExame;
import br.com.simuquiz.funcionalidades.exame.FuncionalidadeExibirExame;
import br.com.simuquiz.funcionalidades.exame.busca.FuncionalidadeBuscarExames;
import br.com.simuquiz.funcionalidades.mensagemprivada.FuncionalidadeEnviarMensagemPrivada;
import br.com.simuquiz.funcionalidades.mensagemprivada.FuncionalidadeListarMensagensPrivadas;
import br.com.simuquiz.funcionalidades.questao.FuncionalidadeCadastrarQuestao;
import br.com.simuquiz.funcionalidades.questao.FuncionalidadeListarQuestoes;
import br.com.simuquiz.funcionalidades.questao.FuncionalidadeVisualizarQuestao;
import br.com.simuquiz.funcionalidades.usuario.FuncionalidadeLogin;
import br.com.simuquiz.funcionalidades.usuario.FuncionalidadeVisualizarUsuario;
import br.com.simuquiz.funcionalidades.usuario.cadastro.FuncionalidadeCadastrarUsuario;
import br.com.simuquiz.util.JsonObject;
import br.com.simuquiz.web.FuncionalidadeHttp;
import br.com.simuquiz.web.Mapeador;
import br.com.simuquiz.web.MapeadorPlainText;
import br.com.simuquiz.web.ObjetoHttp;
import br.com.simuquiz.web.Param;
import br.com.simuquiz.web.ParametrosRequisicao;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import static br.com.simuquiz.web.ParamSource.*;
import static br.com.simuquiz.web.HttpMethod.*;
import static br.com.simuquiz.util.MathUtils.*;
import static br.com.simuquiz.util.StringUtils.*;

/**
 * Esta classe vai ser refatorada em classes mais simples e coesas assim que a
 * classe FuncionalidadeRest for refatorada.
 *
 * @author Victor Williams Stafusa da Silva
 */
@ObjetoHttp(MapeadorPlainText.class)
public class FuncionalidadesSimuquiz {

    private Integer[] calcularRange(String valorBruto) {
        // Retorna um array vazio se no houver range.
        if (vazio(valorBruto)) return new Integer[3];

        String[] partes = valorBruto.split("-");
        Integer inicio = tryParseInt(partes[0]);
        Integer fim = tryParseInt(partes[1]);
        Integer quantidade = (fim == null ? null : fim - inicio + 1);
        return new Integer[] {inicio, fim, quantidade};
    }

    /*@ObjetoHttp(MapeadorPlainText.class)
    @FuncionalidadeHttp
    public String hello() {
        return "Hello World";
    }*/

    // Usurio:

    @FuncionalidadeHttp(caminhos="usuario/?id", tipo=GET)
    public JsonObject exibirUsuario(@Param(tipo=URL, value="id") long idUsuario) {
        return JsonObject.serializar(new FuncionalidadeVisualizarUsuario(idUsuario));
    }

    @FuncionalidadeHttp(caminhos="usuario/novo", tipo=POST)
    public JsonObject novoUsuario(
            @Param("login") String login,
            @Param("senha") String senha,
            @Param("confirmacao_senha") String confirmacaoSenha,
            @Param("email") String email,
            @Param("confirmacao_email") String confirmacaoEmail,
            @Param("nome") String nome
    ) {
        return JsonObject.serializar(FuncionalidadeCadastrarUsuario.incluir(login, senha, confirmacaoSenha, email, confirmacaoEmail, nome));
    }

    @FuncionalidadeHttp(caminhos="usuario/alterar", tipo={POST, PUT})
    public JsonObject alterarUsuario(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param("login") String login,
            @Param("senha") String senha,
            @Param("confirmacao_senha") String confirmacaoSenha,
            @Param("email") String email,
            @Param("confirmacao_email") String confirmacaoEmail,
            @Param("nome") String nome
    ) {
        return JsonObject.serializar(FuncionalidadeCadastrarUsuario.alterar(usuario, login, senha, confirmacaoSenha, email, confirmacaoEmail, nome));
    }

    // Exame:

    @FuncionalidadeHttp(caminhos="exame/?id", tipo=GET)
    public JsonObject exibirExame(@Param(tipo=URL, value="id") Long idExame) {
        FuncionalidadeExibirExame f = new FuncionalidadeExibirExame(idExame);
        double ranking = f.getExame().ranking();
        JsonObject json = JsonObject.serializar(new FuncionalidadeExibirExame(idExame));
        json.put("ranking", String.valueOf(ranking));
        return json;
    }

    @FuncionalidadeHttp(caminhos="exame/novo", tipo=POST)
    public JsonObject novoExame(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param("nome") String nome,
            @Param("descricao_curta") String descricaoCurta,
            @Param("descricao_completa") String descricaoCompleta
    ) {
        return JsonObject.serializar(new FuncionalidadeCadastrarExame(usuario, nome, descricaoCurta, descricaoCompleta));
    }

    @FuncionalidadeHttp(caminhos="exame/?id/alterar", tipo={POST, PUT})
    public JsonObject alterarExame(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="id") Long idExame,
            @Param("nome") String nome,
            @Param("descricao_curta") String descricaoCurta,
            @Param("descricao_completa") String descricaoCompleta
    ) {
        return JsonObject.serializar(new FuncionalidadeAlterarExame(usuario, idExame, nome, descricaoCurta, descricaoCompleta));
    }

    @FuncionalidadeHttp(caminhos="exame/busca/", tipo=GET)
    public JsonObject buscarExame(@Param("busca") String busca) {
        return JsonObject.serializar(FuncionalidadeBuscarExames.buscarPorTexto(busca, null, null));
    }

    @FuncionalidadeHttp(caminhos="exame/busca/?range", tipo=GET)
    public JsonObject buscarExame(
            @Param("busca") String busca,
            @Param(tipo=URL, value="range") String range
    ) {
        Integer[] intRange = calcularRange(range);
        return JsonObject.serializar(FuncionalidadeBuscarExames.buscarPorTexto(busca, intRange[0], intRange[2]));
    }

    @FuncionalidadeHttp(caminhos="exame/meus/", tipo=GET)
    public JsonObject buscarMeusExames(@Param(tipo=SESSION, value="usurio") Usuario usuario) {
        return JsonObject.serializar(FuncionalidadeBuscarExames.buscarPorProprietario(usuario, null, null));
    }

    @FuncionalidadeHttp(caminhos="exame/meus/?range", tipo=GET)
    public JsonObject buscarMeusExames(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="range") String range
    ) {
        Integer[] intRange = calcularRange(range);
        return JsonObject.serializar(FuncionalidadeBuscarExames.buscarPorProprietario(usuario, intRange[0], intRange[2]));
    }

    // Questes:

    @FuncionalidadeHttp(caminhos="exame/?idExame/questoes/novo", tipo=POST)
    public JsonObject cadastrarQuestao(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idExame") Long idExame,
            @Param("enunciado") String enunciado,
            @Param("alternativas") List<String> alternativas,
            @Param("corretas") Set<Integer> corretas,
            @Param("max_corretas") Integer maxCorretas,
            @Param("min_corretas") Integer minCorretas,
            @Param("max_alternativas") Integer maxAlternativas,
            @Param("min_alternativas") Integer minAlternativas
    ) {
        return JsonObject.serializar(FuncionalidadeCadastrarQuestao.incluir(
                usuario, idExame, enunciado, alternativas, corretas, maxCorretas,
                minCorretas, maxAlternativas, minAlternativas));
    }

    @FuncionalidadeHttp(caminhos="exame/?idExame/questoes/?idQuestao/alterar", tipo=POST)
    public JsonObject alterarQuestao(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idExame") Long idExame,
            @Param(tipo=URL, value="idQuestao") Long idQuestao,
            @Param("enunciado") String enunciado,
            @Param("alternativas") List<String> alternativas,
            @Param("corretas") Set<Integer> corretas,
            @Param("max_corretas") Integer maxCorretas,
            @Param("min_corretas") Integer minCorretas,
            @Param("max_alternativas") Integer maxAlternativas,
            @Param("min_alternativas") Integer minAlternativas
    ) {
        return JsonObject.serializar(FuncionalidadeCadastrarQuestao.alterar(
                usuario, idQuestao, idExame, enunciado, alternativas, corretas, maxCorretas,
                minCorretas, maxAlternativas, minAlternativas));
    }

    @FuncionalidadeHttp(caminhos="questoes/?idQuestao", tipo=GET)
    public JsonObject visualizarQuestao(
            @Param(tipo=URL, value="idQuestao") Long idQuestao
    ) {
        return JsonObject.serializar(new FuncionalidadeVisualizarQuestao(idQuestao));
    }

    @FuncionalidadeHttp(caminhos="exame/?idExame/questoes/listar", tipo=GET)
    public JsonObject listarQuestoes(@Param(tipo=URL, value="idExame") Long idExame) {
        return JsonObject.serializar(new FuncionalidadeListarQuestoes(idExame));
    }

    @FuncionalidadeHttp(caminhos="exame/?idExame/questoes/listar/?range", tipo=GET)
    public JsonObject listarQuestoes(
            @Param(tipo=URL, value="idExame") Long idExame,
            @Param(tipo=URL, value="range") String range
    ) {
        Integer[] intRange = calcularRange(range);
        return JsonObject.serializar(new FuncionalidadeListarQuestoes(idExame, intRange[0], intRange[2]));
    }

    // Mensagens privadas:

    @FuncionalidadeHttp(caminhos="usuario/?idUsuario/enviarMP", tipo=POST)
    public JsonObject enviarMP(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idUsuario") Long idDestinatario,
            @Param("titulo") String titulo,
            @Param("texto") String texto
    ) {
        return JsonObject.serializar(new FuncionalidadeEnviarMensagemPrivada(usuario, idDestinatario, titulo, texto));
    }

    @FuncionalidadeHttp(caminhos="usuario/mensagens/?idMensagem/spam", tipo=POST)
    public JsonObject denunciarSpamMP(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idMensagem") Long idMensagem
    ) {
        MensagemPrivada.pesquisarPorId(idMensagem).sinalizarSpam(usuario, true);
        JsonObject json = new JsonObject();
        json.put("sucesso", true);
        return json;
    }

    @FuncionalidadeHttp(caminhos="usuario/mensagens/?idMensagem/naospam", tipo=POST)
    public JsonObject naoSpamMP(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idMensagem") Long idMensagem
    ) {
        MensagemPrivada.pesquisarPorId(idMensagem).sinalizarSpam(usuario, false);
        JsonObject json = new JsonObject();
        json.put("sucesso", true);
        return json;
    }

    @FuncionalidadeHttp(caminhos="usuario/mensagens", tipo=GET)
    public JsonObject listarMP(@Param(tipo=SESSION, value="usurio") Usuario usuario) {
        return JsonObject.serializar(new FuncionalidadeListarMensagensPrivadas(usuario, null, null));
    }

    @FuncionalidadeHttp(caminhos="usuario/mensagens/?range", tipo=GET)
    public JsonObject listarMP(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="range") String range
    ) {
        Integer[] intRange = calcularRange(range);
        return JsonObject.serializar(new FuncionalidadeListarMensagensPrivadas(usuario, intRange[0], intRange[2]));
    }

    @FuncionalidadeHttp(caminhos="usuario/mensagens/?idMensagem/excluir", tipo=POST)
    public JsonObject excluirMP(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idMensagem") Long idMensagem
    ) {
        MensagemPrivada.pesquisarPorId(idMensagem).excluir(usuario);
        JsonObject json = new JsonObject();
        json.put("sucesso", true);
        return json;
    }

    // Prova:

    @FuncionalidadeHttp(caminhos="exame/?idExame/prova", tipo=POST)
    public JsonObject comecarProva(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idExame") Integer idExame
    ) {
        return JsonObject.serializar(usuario.iniciarProva(Exame.pesquisarPorId(idExame)));
    }

    @FuncionalidadeHttp(caminhos="provas/?idProva/?idQuestao/responder", tipo=POST)
    public JsonObject responderQuestao(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idProva") Integer idProva,
            @Param(tipo=URL, value="idQuestao") Integer idQuestao,
            @Param(value="marcadas") Set<Integer> marcadas
    ) {
        Prova p = Prova.pesquisar(idProva, usuario);
        if (p != null) p.responderQuestao(idQuestao, marcadas);
        JsonObject json = new JsonObject();
        json.put("sucesso", p != null);
        return json;
    }

    @FuncionalidadeHttp(caminhos="provas/?idProva/finalizar", tipo=POST)
    public JsonObject finalizarProva(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idProva") Integer idProva
    ) {
        Prova p = Prova.pesquisar(idProva, usuario);
        if (p != null) p.finalizar();
        JsonObject json = ((p == null) ? new JsonObject() : JsonObject.serializar(p));
        json.put("sucesso", p != null);
        return json;
    }

    @FuncionalidadeHttp(caminhos="provas/?idProva/gabarito", tipo=GET)
    public JsonObject gabaritoProva(
            @Param(tipo=SESSION, value="usurio") Usuario usuario,
            @Param(tipo=URL, value="idProva") Integer idProva
    ) {
        Prova p = Prova.pesquisar(idProva, usuario);
        JsonObject json = ((p == null) ? new JsonObject() : JsonObject.serializar(p));
        json.put("sucesso", p != null);
        return json;
    }

    @FuncionalidadeHttp(caminhos="provas", tipo=GET)
    public JsonObject listarProvas(
            @Param(tipo=SESSION, value="usurio") Usuario usuario
    ) {
        JsonObject json = new JsonObject();
        try {
            json.naoVisitar(Prova.class, "usuario");
            json.naoVisitar(Prova.class, "questoes");
            json.naoVisitar(Exame.class, "proprietario");
            json.put("provas", usuario.provasRealizadas());
            json.put("sucesso", true);
        } catch (Throwable t) {
            json.put("sucesso", false);
            t.printStackTrace();
        }
        return json;
    }

    // Login:

    // Esta classe vai ser eliminada depois de um refatoramento na classe
    // FuncionalidadeRest. Para ser sincero, esta classe  uma gambiarra, mas
    // prometo elimin-la assim que possvel. :)
    public static class MapeadorLogin implements Mapeador {
        @Override
        public void executar(ParametrosRequisicao requisicao) throws IOException {
            HttpServletResponse response = requisicao.getResponse();

            try {
                JsonObject resposta = (JsonObject) requisicao.executar();
                HttpSession session = requisicao.getRequest().getSession();
                session.setAttribute("usurio", resposta.get("usuario"));

                // Escreve a resposta.
                response.setContentType("text/plain; charset=ISO-8859-1");
                response.setHeader("Cache-Control", "no-cache");
                response.getWriter().write(resposta.toString());
            } catch (InvocationTargetException e) {
                // No faz nada. Um status de erro j deve ter sido setado.
            }
        }
    }

    @ObjetoHttp(MapeadorLogin.class)
    @FuncionalidadeHttp(caminhos="usuario/login", tipo=POST)
    public JsonObject login(@Param("login") String login, @Param("senha") String senha) {
        return JsonObject.serializar(new FuncionalidadeLogin(login, senha));
    }

    // Esta classe tambm vai ser eliminada. :)
    public static class MapeadorLogout implements Mapeador {
        @Override
        public void executar(ParametrosRequisicao requisicao) throws IOException {
            HttpServletResponse response = requisicao.getResponse();

            try {
                JsonObject resposta = (JsonObject) requisicao.executar();
                requisicao.getRequest().getSession().setAttribute("usurio", null);

                // Escreve a resposta.
                response.setContentType("text/plain; charset=ISO-8859-1");
                response.setHeader("Cache-Control", "no-cache");
                response.getWriter().write(resposta.toString());
            } catch (InvocationTargetException e) {
                // No faz nada. Um status de erro j deve ter sido setado.
            }
        }
    }

    @ObjetoHttp(MapeadorLogout.class)
    @FuncionalidadeHttp(caminhos="usuario/logout", tipo=POST)
    public JsonObject logout(@Param(tipo=SESSION, value="usurio") Usuario usuario) {
        JsonObject json = new JsonObject();
        json.put("sucesso", true);
        return json;
    }
}
