/*
 * 15/05/2009, 17:24.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.usuario.cadastro;

import br.com.simuquiz.entidades.Usuario;
import br.com.simuquiz.util.JsonMarshal;

/**
 * Informa como deve ocorrer o processo de cadastro ou atualizao de usurio.
 *
 * @author Victor Williams Stafusa da Silva
 */
public interface Strategy {
    public boolean exigirVerificarSenha();
    public boolean exigirVerificarLoginExistente();
    public Usuario cadastrar();

    /**
     * Informa os dados de entrada do usurio.
     * @return Os dados digitados/escolhidos pelo usurio.
     */
    public Entrada getEntrada();
}
