/*
 * 15/05/2009, 19:04.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.usuario.cadastro;

import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;

/**
 * Classe imutvel que informa os dados de entrada do usurio no cadastro de
 * usurios.
 * @author Victor Williams Stafusa da Silva
 */
@JsonMarshal
public final class Entrada implements Serializable {

    private static final long serialVersionUID = 2685260098370072140L;

    /** O nome informado pelo usurio. */
    private final String nome;

    /** O login escolhido pelo usurio. */
    private final String login;

    /** A senha escolhida pelo usurio. */
    private final String senha;

    /** Confirmao da senha escolhida pelo usurio. */
    private final String confirmacaoSenha;

    /** O e-mail informado pelo usurio. */
    private final String email;

    /** Confirmao do e-mail informado pelo usurio. */
    private final String confirmacaoEmail;

    public Entrada(String nome, String login, String senha, String confirmacaoSenha, String email, String confirmacaoEmail) {
        this.nome = nome;
        this.login = login;
        this.senha = senha;
        this.confirmacaoSenha = confirmacaoSenha;
        this.email = email;
        this.confirmacaoEmail = confirmacaoEmail;
    }

    /**
     * Informa o contedo do campo "nome" informado pelo usurio, ou seja, o
     * nome do usurio.
     * @return O nome escolhido pelo usurio.
     */
    @JsonMarshal
    public String getNome() {
        return nome;
    }

    /**
     * Informa o contedo do campo "login" informado pelo usurio, ou seja, o
     * login do usurio.
     * @return O login escolhido pelo usurio.
     */
    @JsonMarshal
    public String getLogin() {
        return login;
    }

    /**
     * Informa o contedo do campo "senha" informado pelo usurio, ou seja, a
     * senha do usurio.
     * @return A senha escolhida pelo usurio.
     */
    public String getSenha() {
        return senha;
    }

    /**
     * Informa o contedo do campo "confirmao da senha" informado pelo
     * usurio, que espera-se ser igual ao da senha.
     * @return A senha confirmada pelo usurio.
     */
    public String getConfirmacaoSenha() {
        return confirmacaoSenha;
    }

    /**
     * Informa o contedo do campo "email" informado pelo usurio, ou seja, o
     * e-mail do usurio.
     * @return O e-mail escolhido pelo usurio.
     */
    @JsonMarshal
    public String getEmail() {
        return email;
    }

    /**
     * Informa o contedo do campo "confirmao do e-mail" informado pelo
     * usurio, que espera-se ser igual ao e-mail.
     * @return O e-mail confirmado pelo usurio.
     */
    @JsonMarshal
    public String getConfirmacaoEmail() {
        return confirmacaoEmail;
    }
}
