/*
 * 15/05/2009, 17:32.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.usuario.cadastro;

import static br.com.simuquiz.util.StringUtils.*;
import br.com.simuquiz.entidades.Usuario;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class AlterarUsuarioStrategy implements Strategy {

    private final Usuario usuario;
    private final Entrada entrada;

    public AlterarUsuarioStrategy(Usuario usuario, Entrada entrada) {
        this.usuario = usuario;
        this.entrada = entrada;
    }

    @Override
    public boolean exigirVerificarSenha() {
        return (!vazio(entrada.getSenha()) || !vazio(entrada.getConfirmacaoSenha()));
    }

    @Override
    public boolean exigirVerificarLoginExistente() {
        return !usuario.getLogin().equals(entrada.getLogin());
    }

    @Override
    public Usuario cadastrar() {
        usuario.atualizar(entrada.getNome(), entrada.getLogin(), entrada.getSenha(), entrada.getEmail());
        return usuario;
    }

    @Override
    public Entrada getEntrada() {
        return entrada;
    }
}
