/*
 * 03/05/2009, 20:28.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.questao;

import br.com.simuquiz.entidades.Exame;
import br.com.simuquiz.entidades.Questao;
import br.com.simuquiz.funcionalidades.RelatorioProblemas;
import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;
import java.util.Collection;

/**
 * @author Victor Williams Stafusa da Silva
 */
@JsonMarshal
public final class FuncionalidadeListarQuestoes implements Serializable {

    private static final long serialVersionUID = 7419651121632437890L;

    private final Long idExame;

    private final Exame exame;

    private final Collection<Questao> questoes;

    /** ndice da primeira questo encontrado. */
    private final int primeiro;

    /** Quantidade de questes solicitadas na pgina. */
    private final int quantidade;

    /** Relao de problemas ocorridos. */
    private final RelatorioProblemas<TiposErros> problemas;

    public enum TiposErros { ERRO }

    public FuncionalidadeListarQuestoes(Long idExame) {
        this(idExame, 0, 10);
    }

    public FuncionalidadeListarQuestoes(Long idExame, Integer primeiro, Integer quantidade) {

        if (primeiro == null) primeiro = 0;
        if (quantidade == null) quantidade = 10;

        this.idExame = idExame;
        this.problemas = new RelatorioProblemas<TiposErros>(TiposErros.class);
        this.primeiro = primeiro;
        this.quantidade = quantidade;

        if (idExame == null) {
            problemas.adicionarProblema(TiposErros.ERRO, "O exame deve ser informado.");
        }
        if (primeiro < 0) {
            problemas.adicionarProblema(TiposErros.ERRO, "Posio invlida para o primeiro elemento da pesquisa.");
        }
        if (quantidade < 1) {
            problemas.adicionarProblema(TiposErros.ERRO, "Quantidade de resultados invlida para a pesquisa.");
        }

        Exame e = null;
        Collection<Questao> q = null;
        if (problemas.isVazio()) {
            try {
                e = Exame.pesquisarPorId(idExame);
                q = e.pesquisarQuestoes(primeiro, quantidade);
            } catch (Throwable t) {
                problemas.adicionarProblema(TiposErros.ERRO, t);
                t.printStackTrace();
                // TODO: Acrescentar log.
            }
        }
        exame = e;
        questoes = q;

        // Finaliza o processo e se torna apenas um bean.
        problemas.fechar();
    }

    @JsonMarshal
    public int getPrimeiro() {
        return primeiro;
    }

    @JsonMarshal
    public int getQuantidade() {
        return quantidade;
    }

    @JsonMarshal
    public Long getIdExame() {
        return idExame;
    }

    @JsonMarshal
    public RelatorioProblemas getProblemas() {
        return problemas;
    }

    @JsonMarshal
    public boolean isSucesso() {
        return problemas.isVazio();
    }

    @JsonMarshal
    public Exame getExame() {
        return exame;
    }

    @JsonMarshal
    public Collection<Questao> getQuestoes() {
        return questoes;
    }
}
