/*
 * 15/03/2009, 15:15.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.mensagemprivada;

import br.com.simuquiz.entidades.MensagemPrivada;
import br.com.simuquiz.entidades.Usuario;
import br.com.simuquiz.funcionalidades.RelatorioProblemas;
import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;
import static br.com.simuquiz.util.StringUtils.*;

/**
 * Classe responsvel por representar a funcionalidade de enviar mensagens
 * privadas contendo os dados da tela informados pelo usurio.
 *
 * @author Pedro Lopes de Souza
 */
@JsonMarshal
public final class FuncionalidadeEnviarMensagemPrivada implements Serializable {

    private static final long serialVersionUID = -5734516509782304912L;

    /** Usurio que est logado. */
    private final Usuario usuario;

    /** Id do usurio destinatrio da mensagem. */
    private final Long idDestinatario;

    /** Ttulo da mensagem. */
    private final String titulo;

    /** Contedo da mensagem (corpo do texto). */
    private final String textoMensagem;

    /** Relao de problemas ocorridos. */
    private final RelatorioProblemas<TiposErros> problemas;
    
    private final MensagemPrivada mensagem;

    public enum TiposErros { ERRO, TITULO, TEXTO }

    public FuncionalidadeEnviarMensagemPrivada(Usuario usuario, Long idDestinatario, String titulo, String textoMensagem) {

        if (usuario == null) {
            throw new IllegalArgumentException();
        }

        this.usuario = usuario;
        this.idDestinatario = idDestinatario;
        this.titulo = titulo;
        this.textoMensagem = textoMensagem;

        problemas = new RelatorioProblemas<TiposErros>(TiposErros.class);

        if (vazio(titulo)) {
            problemas.adicionarProblema(TiposErros.TITULO, "O ttulo deve ser informado.");
        }

        if (vazio(textoMensagem)){
            problemas.adicionarProblema(TiposErros.TEXTO, "A mensagem no pode ser enviada em branco.");
        }

        if (idDestinatario == null){
            problemas.adicionarProblema(TiposErros.ERRO, "O destinatrio deve ser informado.");
        }

        Usuario destinatario = null;
        if (problemas.isVazio()) {
            try {
                destinatario = Usuario.pesquisarPorId(idDestinatario);
                if (destinatario == null) {
                    problemas.adicionarProblema(TiposErros.ERRO, "Este destinatrio no existe.");
                }
            } catch (Throwable t) {
                problemas.adicionarProblema(TiposErros.ERRO, t);
                t.printStackTrace();
                // TODO: Acrescentar log.
            }
        }

        MensagemPrivada mp = null;
        if (problemas.isVazio()) {
            try {
                mp = MensagemPrivada.novo(usuario, destinatario, textoMensagem, titulo);
            } catch (Throwable t) {
                problemas.adicionarProblema(TiposErros.ERRO, t);
                t.printStackTrace();
                // TODO: Acrescentar log.
            }
        }
        mensagem = mp;

        // Finaliza o processo e se torna apenas um bean.
        problemas.fechar();
    }

    @JsonMarshal
    public Usuario getUsuario() {
        return usuario;
    }

    @JsonMarshal
    public Long getIdDestinatario() {
        return idDestinatario;
    }

    @JsonMarshal
    public String getTitulo() {
        return titulo;
    }

    @JsonMarshal
    public String getTextoMensagem() {
        return textoMensagem;
    }

    @JsonMarshal
    public RelatorioProblemas getProblemas() {
        return problemas;
    }

    @JsonMarshal
    public MensagemPrivada getMensagem() {
        return mensagem;
    }

    @JsonMarshal
    public boolean isSucesso() {
        return problemas.isVazio();
    }
}
