/*
 * 15/05/2009, 20:14.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.exame.busca;

import br.com.simuquiz.entidades.Exame;
import br.com.simuquiz.entidades.Usuario;
import br.com.simuquiz.util.JsonMarshal;
import java.util.Collection;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class MeusExamesStrategy implements Strategy {

    /** Usurio que est logado. */
    private final Usuario usuario;

    private final Entrada entrada = new Entrada() {
        private static final long serialVersionUID = -4028121610269015039L;

        @JsonMarshal
        public Usuario getUsuario() {
            return usuario;
        }
    };

    /**
     * Cria uma estratgia de busca de exames por proprietrio.
     * @param usuario O usurio logado, proprietrio dos exames pesquisados.
     */
    public MeusExamesStrategy(Usuario usuario) {
        this.usuario = usuario;
    }

    @Override
    public Collection<Exame> obterExames(int primeiro, int quantidade) {
        return usuario.listarExamesPossuidos(primeiro, quantidade);
    }

    @Override
    public Entrada getEntrada() {
        return entrada;
    }
}
