/*
 * 15/05/2009, 18:06.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.exame.busca;

import br.com.simuquiz.entidades.Exame;
import br.com.simuquiz.util.JsonMarshal;
import java.util.Collection;
import static br.com.simuquiz.util.StringUtils.*;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class BuscaExamesStrategy implements Strategy {

    /** O texto da busca digitado pelo usurio. */
    private final String busca;

    private final Entrada entrada = new Entrada() {
        private static final long serialVersionUID = 7637915062928521073L;

        @JsonMarshal
        public String getBusca() {
            return busca;
        }
    };

    /**
     * Cria uma estratgia de busca por texto.
     * @param busca A {@linkplain String} utilizada como palavra-chave na busca.
     */
    public BuscaExamesStrategy(String busca) {
        this.busca = busca;
    }

    @Override
    public Collection<Exame> obterExames(int primeiro, int quantidade) {
        return (vazio(busca))
                ? Exame.pesquisarTudo(primeiro, quantidade)
                : Exame.pesquisarPorDescricao(busca, primeiro, quantidade);
    }

    @Override
    public Entrada getEntrada() {
        return entrada;
    }
}