/*
 * 15/03/2009, 23:00.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.exame;

import br.com.simuquiz.entidades.Exame;
import br.com.simuquiz.funcionalidades.RelatorioProblemas;
import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;

/**
 * @author Victor Williams Stafusa da Silva
 */
@JsonMarshal
public final class FuncionalidadeExibirExame implements Serializable {

    private static final long serialVersionUID = 1710927112755604579L;

    private final Long idExame;

    private final Exame exame;

    /** Relao de problemas ocorridos. */
    private final RelatorioProblemas<TiposErros> problemas;

    public enum TiposErros { ERRO }

    public FuncionalidadeExibirExame(Long idExame) {
        this.idExame = idExame;
        this.problemas = new RelatorioProblemas<TiposErros>(TiposErros.class);

        if (idExame == null) {
            problemas.adicionarProblema(TiposErros.ERRO, "O exame deve ser informado.");
        }

        Exame e = null;
        if (problemas.isVazio()) {
            try {
                e = Exame.pesquisarPorId(idExame);
                if (e == null) {
                    problemas.adicionarProblema(TiposErros.ERRO, "Esse exame no existe.");
                }
            } catch (Throwable t) {
                problemas.adicionarProblema(TiposErros.ERRO, t);
                t.printStackTrace();
                // TODO: Acrescentar log.
            }
        }
        exame = e;

        // Finaliza o processo e se torna apenas um bean.
        problemas.fechar();
    }

    @JsonMarshal
    public Long getIdExame() {
        return idExame;
    }

    @JsonMarshal
    public RelatorioProblemas getProblemas() {
        return problemas;
    }

    @JsonMarshal
    public boolean isSucesso() {
        return problemas.isVazio();
    }

    @JsonMarshal
    public Exame getExame() {
        return exame;
    }
}
