/*
 * 17/06/2009, 16:30.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */


package br.com.simuquiz.entidades;

import br.com.simuquiz.conexao.Database;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Query;


/**
 *
 * @author Pedro Lopes de Souza
 */
@Entity
//@JsonMarshal
public class Treinamento implements Serializable {

private static final long serialVersionUID = -8648104903489193105L;

    @Id
    @GeneratedValue
    /** Primary Key **/
    private long idTreinamento;

    /** Classe da mensagem **/
    private String classe;

    /** Texto da mensagem **/
    private String texto;

    /** Construtor unico **/
    public Treinamento() {
    }
    //@JsonMarshal
    public String getTexto() {
        return texto;
    }
    //@JsonMarshal
    public void setTexto(String texto) {
        this.texto = texto;
    }
    //@JsonMarshal
    public String getClasse() {
        return classe;
    }
    //@JsonMarshal
    public void setClasse(String classe) {
        this.classe = classe;
    }

    /**
     * Cadastra um novo treinamento no banco de dados.
     * @param classe A classificacao da mensagem
     * @param texto O texto da mensagem.
     * @return O bean do usuário recém-cadastrado.
     */

    public static Treinamento novo(String classe, String texto){
        Treinamento treinamento = new Treinamento();
        treinamento.classe = classe;
        treinamento.texto = texto;

        Database.persist(treinamento);
        return treinamento;
    }

    /**
     * Procura um Treinamento no banco de dados com a chave primária informada.
     * @param id A chave primária.
     * @return O bean do Treinamento correspondente, ou {@code null} se não existir
     */

    public static Treinamento pesquisarPorId(long id) {
        return Database.getEntityManager().find(Treinamento.class, id);
    }

    @SuppressWarnings("unchecked")
    public static List<Treinamento> listarTudo() {
        Query q = Database.getEntityManager().createQuery("from Treinamento");
        return (List<Treinamento>) q.getResultList();
    }

}
