/*
 * 08/03/2009, 09:51.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.entidades;

import br.com.simuquiz.conexao.Database;
import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Version;

/**
 * @author Victor Williams Stafusa da Silva
 */
@Entity
@JsonMarshal
public class QuestaoProva implements Serializable {

    private static final long serialVersionUID = -6811668589061032573L;

    @Id
    @GeneratedValue
    private long idQuestaoProva;

    @ManyToOne
    @JoinColumn(name="Id_Prova")
    private Prova prova;

    @ManyToOne
    @JoinColumn(name="Id_Questao_Versao")
    private QuestaoVersao questaoVersao;

    private int numeroOrdem;

    /*@ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="Alternativas_Marcadas",
        joinColumns={@JoinColumn(name="Id_Questao_Prova")},
        inverseJoinColumns={@JoinColumn(name="Id_Alternativa")}
    )
    private Collection<Alternativa> alternativasMarcadas;*/

    /*@ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="Alternativas_Presentes",
        joinColumns={@JoinColumn(name="Id_Questao_Prova")},
        inverseJoinColumns={@JoinColumn(name="Id_Alternativa")}
    )
    private Collection<Alternativa> alternativasPresentes;*/

    @OneToMany(fetch=FetchType.EAGER)
    @MapKey(name="ordem")
    private Map<Integer, AlternativaProva> alternativas;

    @Version
    private Integer version;

    public QuestaoProva() {}

    public long getIdQuestaoProva() {
        return idQuestaoProva;
    }

    public void setIdQuestaoProva(long idQuestaoProva) {
        this.idQuestaoProva = idQuestaoProva;
    }

    public Prova getProva() {
        return prova;
    }

    public void setProva(Prova prova) {
        this.prova = prova;
    }

    public QuestaoVersao getQuestaoVersao() {
        return questaoVersao;
    }

    public void setQuestaoVersao(QuestaoVersao questaoVersao) {
        this.questaoVersao = questaoVersao;
    }

    @JsonMarshal
    public int getNumeroOrdem() {
        return numeroOrdem;
    }

    @JsonMarshal
    public Collection<Integer> getChavesAlternativasCorretas() {
        if (prova.getTermino() == null) return null;
        Collection<Integer> valores = new ArrayList<Integer>(alternativas.size());
        for (AlternativaProva a : alternativas.values()) {
            if (!a.isCorreta()) continue;
            valores.add(a.getOrdem());
        }
        return valores;
    }

    @JsonMarshal
    public boolean isCorreta() {
        if (prova.getTermino() == null) return false;
        for (AlternativaProva a : alternativas.values()) {
            if (a.isMarcada() != a.isCorreta()) return false;
        }
        return true;
    }

    @JsonMarshal
    public Collection<Integer> getChavesAlternativasMarcadas() {
        Collection<Integer> valores = new ArrayList<Integer>(alternativas.size());
        for (AlternativaProva a : alternativas.values()) {
            if (!a.isMarcada()) continue;
            valores.add(a.getOrdem());
        }
        return valores;
    }

    @JsonMarshal
    public Collection<String> getTextosAlternativas() {
        Collection<String> textos = new ArrayList<String>(alternativas.size());
        for (AlternativaProva a : alternativas.values()) {
            textos.add(a.getAlternativa().getTexto());
        }
        return textos;
    }

    @JsonMarshal
    public Collection<Integer> getChavesAlternativas() {
        Collection<Integer> valores = new ArrayList<Integer>(alternativas.size());
        for (AlternativaProva a : alternativas.values()) {
            valores.add(a.getOrdem());
        }
        return valores;
    }

    @JsonMarshal
    public String getEnunciado() {
        return questaoVersao.getEnunciado();
    }

    // Visibilidade de pacote. Deve ser usado apenas pela classe Prova.
    void marcarAlternativas(final Set<Integer> escolhidas) {
        Database.efetuarTransacao(new Database.Transacao<Void>() {
            @Override
            public Void efetuarTransacao(EntityManager em) {
                Set<Integer> chaves = (escolhidas == null) ? Collections.<Integer>emptySet() : escolhidas;

                for (AlternativaProva a : alternativas.values()) {
                    a.setMarcada(false);
                }

                for (Integer i : chaves) {
                    AlternativaProva a = alternativas.get(i);
                    a.setMarcada(true);
                    em.merge(a);
                }
                em.merge(QuestaoProva.this);

                return null;
            }
        });
    }

    // Visibilidade de pacote. Deve ser usado apenas pela classe Prova.
    static QuestaoProva novo(EntityManager em, Prova prova, QuestaoVersao questao, int numeroOrdem) {
        QuestaoProva q = new QuestaoProva();
        q.numeroOrdem = numeroOrdem;
        q.prova = prova;
        q.questaoVersao = questao;

        Collection<Alternativa> alternativasQuestao = questao.getAlternativas();
        List<Alternativa> corretas = new ArrayList<Alternativa>(alternativasQuestao.size());
        List<Alternativa> incorretas = new ArrayList<Alternativa>(alternativasQuestao.size());
        for (Alternativa a : alternativasQuestao) {
            (a.isCorreta() ? corretas : incorretas).add(a);
        }

        Random r = new Random();

        int minCorretas = questao.getMinCorretas();
        int maxCorretas = questao.getMaxCorretas();
        int numeroCorretas = r.nextInt(maxCorretas - minCorretas + 1) + minCorretas;
        int minAlternativas = questao.getMinAlternativas();
        int maxAlternativas = questao.getMaxAlternativas();
        int numeroAlternativas = r.nextInt(maxAlternativas - minAlternativas + 1) + minAlternativas;
        int numeroIncorretas = numeroAlternativas - numeroCorretas;

        while (corretas.size() > numeroCorretas) {
            corretas.remove(r.nextInt(corretas.size()));
        }

        while (incorretas.size() > numeroIncorretas) {
            incorretas.remove(r.nextInt(incorretas.size()));
        }

        List<Alternativa> alternativasEscolhidas = new ArrayList<Alternativa>(numeroAlternativas);
        alternativasEscolhidas.addAll(corretas);
        alternativasEscolhidas.addAll(incorretas);
        Collections.shuffle(alternativasEscolhidas);

        q.alternativas = new HashMap<Integer, AlternativaProva>(alternativasEscolhidas.size());
        em.persist(q);

        int i = 0;
        for (Alternativa a : alternativasEscolhidas) {
            AlternativaProva ap = new AlternativaProva();
            ap.setAlternativa(a);
            //ap.setQuestao(q);
            ap.setOrdem(i);
            q.alternativas.put(i, ap);
            i++;
        }

        for (AlternativaProva ap : q.alternativas.values()) {
            em.persist(ap);
        }
        em.merge(q);

        return q;
    }
}
