/*
 * 08/03/2009, 09:41.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.entidades;

import br.com.simuquiz.conexao.Database;
import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author Victor Williams Stafusa da Silva
 */
@Entity
@JsonMarshal
public class Prova implements Serializable {

    private static final long serialVersionUID = -8648104903489193105L;

    @Id
    @GeneratedValue
    private long idProva;

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="Id_Usuario")
    private Usuario usuario;

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="Id_Exame")
    private Exame exame;

    @Temporal(TemporalType.TIMESTAMP)
    private Date inicio;

    @Temporal(TemporalType.TIMESTAMP)
    private Date termino;

    @OneToMany(mappedBy="prova", fetch=FetchType.LAZY)
    @MapKey(name="numeroOrdem")
    private Map<Integer, QuestaoProva> questoes;

    public Prova() {}

    @JsonMarshal
    public long getIdProva() {
        return idProva;
    }

    @JsonMarshal
    public Date getInicio() {
        return inicio;
    }

    @JsonMarshal
    public Date getTermino() {
        return termino;
    }

    @JsonMarshal
    public Map<Integer, QuestaoProva> getQuestoes() {
        return questoes;
    }

    @JsonMarshal
    public Exame getExame() {
        return exame;
    }

    @JsonMarshal
    public int getQuantidadeQuestoes() {
        return questoes.size();
    }

    public void finalizar() {
        termino = new Date();
        Database.merge(this);
    }

    public void responderQuestao(int numeroQuestao, Set<Integer> alternativasMarcadas) {
        QuestaoProva qp = getQuestao(numeroQuestao);
        qp.marcarAlternativas(alternativasMarcadas);
    }

    public QuestaoProva getQuestao(int numeroQuestao) {
        QuestaoProva qp = questoes.get(numeroQuestao);
        if (qp == null) throw new IllegalArgumentException("No h questo de nmero " + numeroQuestao + " na prova.");
        return qp;
    }

    @JsonMarshal
    public boolean isFinalizada() {
        return termino != null;
    }

    @JsonMarshal
    public int getQuantidadeAcertos() {
        if (termino == null) return 0;
        int acertos = 0;
        for (QuestaoProva qp : this.questoes.values()) {
            if (qp.isCorreta()) acertos++;
        }
        return acertos;
    }

    // Visibilidade de pacote. Deve ser usado apenas pela classe Usuario.
    static Prova novo(EntityManager em, Usuario usuario, Exame exame, Collection<Questao> questoes) {
        final Prova p = new Prova();
        p.exame = exame;
        p.usuario = usuario;
        p.questoes = new HashMap<Integer, QuestaoProva>(questoes.size());
        p.inicio = new Date();

        int i = 0;
        for (Questao q : questoes) {
            i++;
            QuestaoProva qp = QuestaoProva.novo(em, p, q.getVersaoEmUso(), i);
            p.questoes.put(i, qp);
        }
        em.persist(p);

        return p;
    }

    public static Prova pesquisar(long idProva, Usuario usuario) {
        Prova p = Database.getEntityManager().find(Prova.class, idProva);
        return (p == null || p.usuario != usuario) ? null : p;
    }
}
