/*
 * 08/03/2009, 10:24.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.entidades;

import br.com.simuquiz.antispam.DocumentReader;
import br.com.simuquiz.conexao.Database;
import br.com.simuquiz.util.JsonMarshal;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author Victor Williams Stafusa da Silva
 */
@Entity
@JsonMarshal
public class MensagemPrivada implements Serializable {

    private static final long serialVersionUID = -7122901302034575269L;

    @Id
    @GeneratedValue
    private long idMensagemPrivada;

    @ManyToOne
    @JoinColumn(name="Id_Usuario_Remetente")
    private Usuario remetente;

    @ManyToOne
    @JoinColumn(name="Id_Usuario_Destinatario")
    private Usuario destinatario;

    @Temporal(TemporalType.TIMESTAMP)
    private Date dataEnvio;

    @Temporal(TemporalType.TIMESTAMP)
    private Date dataLida;

    private String textoMensagem;

    private String titulo;

    private boolean excluidaRemetente;

    private boolean excluidaDestinatario;

    private boolean sinalizadaRemetente;

    private boolean sinalizadaDestinatario;

    private boolean sinalizadaSpam;

    @JsonMarshal
    public long getIdMensagemPrivada() {
        return idMensagemPrivada;
    }

    @JsonMarshal
    public Usuario getRemetente() {
        return remetente;
    }

    @JsonMarshal
    public Usuario getDestinatario() {
        return destinatario;
    }

    @JsonMarshal
    public Date getDataEnvio() {
        return dataEnvio;
    }

    @JsonMarshal
    public Date getDataLida() {
        return dataLida;
    }

    @JsonMarshal
    public String getTextoMensagem() {
        return textoMensagem;
    }

    @JsonMarshal
    public String getTitulo() {
        return titulo;
    }

    @JsonMarshal
    public boolean isExcluidaRemetente() {
        return excluidaRemetente;
    }

    @JsonMarshal
    public boolean isExcluidaDestinatario() {
        return excluidaDestinatario;
    }

    @JsonMarshal
    public boolean isSinalizadaRemetente() {
        return sinalizadaRemetente;
    }

    @JsonMarshal
    public boolean isSinalizadaDestinatario() {
        return sinalizadaDestinatario;
    }

    @JsonMarshal
    public boolean isSinalizadaSpam() {
        return sinalizadaSpam;
    }

    public void sinalizarSpam(Usuario sinalizador, boolean spam) {
        if (sinalizador.getIdUsuario() != destinatario.getIdUsuario()) throw new IllegalArgumentException();
        this.sinalizadaSpam = spam;
        Database.merge(this);
        Treinamento t = Treinamento.novo(spam ? "spam" : "msg", this.titulo + "\n\n" + this.textoMensagem);
        Database.getTrainer().train(t);
    }

    public void excluir(Usuario excluindo) {
        if (excluindo.getIdUsuario() != destinatario.getIdUsuario()) throw new IllegalArgumentException();
        Database.remove(this);
    }

    public static MensagemPrivada novo(Usuario remetente, Usuario destinatario, String textoMensagem, String titulo) {

        MensagemPrivada mp = new MensagemPrivada();

        mp.remetente = remetente;
        mp.destinatario = destinatario;
        mp.textoMensagem = textoMensagem;
        mp.titulo = titulo;
        mp.dataEnvio = new Date();

        Set<String> document = DocumentReader.getDocFeatures(new ByteArrayInputStream((titulo + "\n\n" + textoMensagem).getBytes()));
        mp.sinalizadaSpam = Database.getClassifier().classify(document).getCategoryName().equals("spam");

        EntityManager em = Database.getEntityManager();
        EntityTransaction et = em.getTransaction();

        try {
            et.begin();
            em.persist(mp);
            et.commit();

            return mp;
        } finally {
            if (et.isActive()) et.rollback();
        }
    }

    public static MensagemPrivada pesquisarPorId(long id) {
        return Database.getEntityManager().find(MensagemPrivada.class, id);
    }
}
