/*
 * 17/06/2009, 16:30.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */

package br.com.simuquiz.antispam.classifiers;

import java.util.HashSet;
import java.util.Set;

import br.com.simuquiz.antispam.Category;
import br.com.simuquiz.antispam.Feature;
import java.util.Map;

/**
 * @author Thiago Henrique Coraini
 * @author Israel Lacerra
 * @author Victor Williams Stafusa da Silva
 * @author Pedro Lopes de Souza
 */
public abstract class Classifier {

    protected Map<String, Category> categories;

    protected Map<String, Feature> features;

    protected int totalDocs;

    protected Classifier(Map<String, Category> categories,
            Map<String, Feature> features, int totalDocs) {
        this.categories = categories;
        this.features = features;
        this.totalDocs = totalDocs;
    }

    public abstract Category classify(Set<String> document);

    protected Set<Feature> getFeatures(Set<String> document) {
        Set<Feature> docFeatures = new HashSet<Feature>();
        for (String featureName : document) {
            Feature feature = features.get(featureName);
            if (feature == null)
                feature = new Feature(featureName);
            docFeatures.add(feature);
        }

        return docFeatures;
    }
}
