/*
 * 17/06/2009, 16:30.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */

package br.com.simuquiz.antispam;

import br.com.simuquiz.entidades.Treinamento;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author Thiago Henrique Coraini
 * @author Israel Lacerra
 * @author Victor Williams Stafusa da Silva
 * @author Pedro Lopes de Souza
 */
public class Trainer {

	private Map<String, Category> categories = new HashMap<String, Category>();

	private Map<String, Feature> features = new HashMap<String, Feature>();

    private int totalDocs = 0;

    public void train(Collection<Treinamento> treinamento) {
        for (Treinamento t : treinamento) {
            train(t);
        }
    }

    public void train(Treinamento t) {
        Category category = getCategory(t.getClasse());
        category.addDoc();
        totalDocs++;

        //System.out.println("Parsing " + category.getCategoryName() + " category dir...");

        Set<String> docFeatures = DocumentReader.getDocFeatures(new ByteArrayInputStream(t.getTexto().getBytes()));
        processFeatures(docFeatures, category);
    }

    private void processFeatures(Set<String> docFeatures, Category category) {
        for (String docFeature : docFeatures) {
            Feature feature = getFeature(docFeature);
            feature.addEvent(category);
        }
    }

    private Category getCategory(String categoryName) {
        Category category = categories.get(categoryName);
        if (category == null) {
            category = new Category(categoryName);
            categories.put(categoryName, category);
        }
        return category;
    }

    private Feature getFeature(String docFeature) {
        Feature feature = features.get(docFeature);
        if (feature == null) {
            feature = new Feature(docFeature);
            features.put(docFeature, feature);
        }

        return feature;
    }

    public Map<String, Category> getCategories() {
        return Collections.unmodifiableMap(categories);
    }

    public Map<String, Feature> getFeatures() {
        return Collections.unmodifiableMap(features);
    }

    public int getTotalDocs() {
        return totalDocs;
    }
}
