/*
 * 17/06/2009, 16:30.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */

package br.com.simuquiz.antispam;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Thiago Henrique Coraini
 * @author Israel Lacerra
 * @author Victor Williams Stafusa da Silva
 * @author Pedro Lopes de Souza
 */
public class Feature {

    private String feature;

    private Map<Category, Integer> events = new HashMap<Category, Integer>();

    private int totalEvents = 0;

    public int getTotalEvents() {
        return totalEvents;
    }

    public Feature(String feature) {
        this.feature = feature;
    }

    public int getEvents(Category category) {
        Integer howMany = events.get(category);
        if (howMany == null) return 0;
        return howMany;
    }

    // Visibilidade de pacote. Este mtodo deve ser visvel apenas para a classe Trainer.
    void addEvent(Category category) {
        totalEvents++;
        Integer howMany = events.get(category);
        events.put(category, (howMany == null ? 1 : howMany + 1));
    }

	public String getFeature() {
		return feature;
	}
}
