/*
 * 17/06/2009, 16:30.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.antispam;

/**
 * @author Thiago Henrique Coraini
 * @author Israel Lacerra
 * @author Victor Williams Stafusa da Silva
 * @author Pedro Lopes de Souza
 */
public class Category {

	private final String categoryName;

	private int docs = 0;

	private double min = 0.0;

	public Category(String name) {
        if (name == null) throw new IllegalArgumentException();
		categoryName = name;
	}

	public void setDocs(int docs) {
		this.docs = docs;
	}

	public int getDocs() {
		return docs;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void addDoc() {
		docs++;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((categoryName == null) ? 0 : categoryName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Category other = (Category) obj;
		if (categoryName == null) {
			if (other.categoryName != null)
				return false;
		} else if (!categoryName.equals(other.categoryName))
			return false;
		return true;
	}

	public void setMin(double min) {
		this.min = min;
	}

	public double getMin() {
		return min;
	}

}
