/*
    Documento : mostrar_mensagens_privadas.js
    Criado em : 15/06/2009, 18:00
    Autores     : Victor Williams Stafusa da Silva
                : Pedro Lopes de Souza

    Simuquiz - http://www.simuquiz.com.br
*/

CarregadorDeTela.executors["questao_prova"] = function(area, contexto) {

  function marcarAlternativas() {
    $(".alternativa").each(function(i) {
      prova.questionario[prova.questaoAtual].alternativas[i].marcada = this.checked;
    });
    var dados = $("#form_prova").serialize();
    enviar(dados, "./WebServlet/provas/" + prova.idProva + "/" + prova.questionario[prova.questaoAtual].numero + "/responder", function(retorno) {
      if (!retorno.sucesso) alert("Erro ao enviar alternativas selecionadas ao servidor!");
    });
  }

  function finalizarProva() {
    if (!confirm("Voc tem certeza que quer finalizar a prova?")) return;
    enviar(null, "./WebServlet/provas/" + prova.idProva + "/finalizar", function(retorno) {
      if (!retorno.sucesso) {
        alert("Erro ao avisar o servidor sobre o trmino da prova!");
      } else {
        prova = retorno;
        chamarApenasTela("gabarito", retorno);
      }
    });
  }

  function voltarQuestao() {
    if (prova.questaoAtual == 0) return;
    prova.questaoAtual--;
    chamarTela("questao_prova", prova.questionario[prova.questaoAtual]);
  }

  function proximaQuestao() {
    if (prova.questaoAtual == prova.quantidadeQuestoes - 1) return;
    prova.questaoAtual++;
    chamarTela("questao_prova", prova.questionario[prova.questaoAtual]);
  }

  $(area).find(".alternativa").change(marcarAlternativas);
  $(area).find("#botao_voltar_questao").click(voltarQuestao);
  $(area).find("#botao_proxima_questao").click(proximaQuestao);
  $(area).find("#botao_finalizar_prova").click(finalizarProva);

  $(window).keyup(function(event) {
    if (event.keyCode == 37) {
      event.keyCode = 0;
      voltarQuestao();
    } else if (event.keyCode == 39) {
      event.keyCode = 0;
      proximaQuestao();
    }
  });
};