/*
    Documento : mostrar_mensagens_privadas.js
    Criado em : 21/02/2009, 16:38:28
    Autores   : Adson Carlos Nery Malta
              : Victor Williams Stafusa da Silva
              : Pedro Lopes de Souza

    Simuquiz - http://www.simuquiz.com.br
*/

CarregadorDeTela.executors["mostrar_mensagens_privadas"] = function(area, contexto) {
  mostrarMensagensPrivadas();

  function invocarServletMP(url) {
    ler(null, url, function(retorno) {
      if (retorno.sucesso) {
        retorno.mensagens.each(popularMensagem);
        trabalharDivMaisMensagens(retorno);
      } else {
        mostrarErros(retorno.problemas.erro, "mostrar_mensagens_privadas_erros_gerais");
      }
    });
  }

  function mostrarMensagensPrivadas() {
    limparListaMensagens();
    invocarServletMP("./WebServlet/usuario/mensagens");
  }

  function trabalharDivMaisMensagens(retorno) {
    if (!retorno.temMais) {
      $("#mais_resultados_mensagens_privadas").hide();
      return;
    }

    var dados = "./WebServlet/usuario/mensagens/" + (retorno.primeiro + retorno.quantidade)
          + "-" + (retorno.primeiro + 2 * retorno.quantidade - 1);

    $("#botao_mais_resultados_mostrar_MP").click(function() {
      invocarServletMP(dados);
    });

    $("#mais_resultados_mensagens_privadas").show();
  }

  function limparListaMensagens() {
    $("#resultados_mensagens_privadas").empty();
  }

  function mostrarMensagemPrivada(idMensagemPrivada) {
    alert("Mostrar mensagem ainda no implementado." + idMensagemPrivada);
    //invocarTelaRemota("visualizar_mensagem_privada", "./WebServlet/usuario/mensagens/" + idMensagemPrivada + "/ler");
  }

  function setSpam(spam, idMensagemPrivada, elementoHtml) {
    enviar(null, "./WebServlet/usuario/mensagens/" + idMensagemPrivada + "/" + (spam ? "spam" : "naospam"), function(retorno) {
      if (!retorno.sucesso) {
        alert("Ocorreu um erro ao enviar a solicitao para o servidor.");
        return;
      }
      elementoHtml.find(".mensagem_obrigado").removeClass("invisivel");
      if (spam) {
        elementoHtml.find(".mensagem_spam").removeClass("invisivel");
        elementoHtml.find(".botao_denunciar_spam").addClass("invisivel");
        elementoHtml.find(".botao_nao_spam").removeClass("invisivel");
      } else {
        elementoHtml.find(".mensagem_spam").addClass("invisivel");
        elementoHtml.find(".botao_denunciar_spam").removeClass("invisivel");
        elementoHtml.find(".botao_nao_spam").addClass("invisivel");
      }
    });
  }

  function excluir(idMensagemPrivada, elementoHtml) {
    if (!confirm("Voc tem certeza que deseja excluir esta mensagem?")) return;

    enviar(null, "./WebServlet/usuario/mensagens/" + idMensagemPrivada + "/excluir", function(retorno) {
      if (!retorno.sucesso) {
        alert("Ocorreu um erro ao enviar a solicitao para o servidor.");
        return;
      }
      elementoHtml.hide();
    });
  }

  function visualizarUsuario(id) {
    invocarTelaRemota("visualizar_usuario", "./WebServlet/usuario/" + id);
  }

  function responder(mensagem) {
    chamarTela("enviar_mensagem_privada", {idDestinatario: mensagem.remetente.idUsuario, mensagemOriginal: mensagem});
  }

  function popularMensagem(mensagem) {
    var t = new CarregadorDeTela();
    t.setNotificarAguarde(false);
    t.setContexto(mensagem);
    t.setNome("lista_mensagens_privadas");
    t.setCallback(function() {
      var novo = $(t.getTexto());
      $("#resultados_mensagens_privadas").append(novo);
      var id = mensagem.idMensagemPrivada;
      novo.find(".botao_denunciar_spam").click(function() { setSpam(true, id, novo); });
      novo.find(".botao_nao_spam").click(function() { setSpam(false, id, novo); });
      novo.find(".botao_responder").click(function() { responder(mensagem); });
      novo.find(".botao_excluir").click(function() { excluir(id, novo); });
      novo.find(".link_remetente").click(function() { visualizarUsuario(mensagem.remetente.idUsuario); });
    });
    t.carregarXhtml();
  }
};