/*
    Documento : buscar_exames.js
    Criado em : 15/03/2009 15:13
    Autor     : Victor Williams Stafusa da Silva

    Simuquiz - http://www.simuquiz.com.br
*/

CarregadorDeTela.executors["buscar_exames"] = function(area, contexto) {

  function invocarServletExames(url, meus) {
    ler(null, url, function(retorno) {
      if (retorno.sucesso) {
        retorno.exames.each(function(valor) { popularExame(valor); });
        trabalharDivMaisExames(retorno, meus);
      } else {
        mostrarErros(retorno.problemas.erro, "buscar_exames_erros_gerais");
      }
    });
  }

  function buscarExames() {
    limparListaExames();
    var busca = $("#buscar_exames_busca").val();
    invocarServletExames("./WebServlet/exame/busca?busca=" + encodeURIComponent(busca), false);
  }

  function buscarMeusExames() {
    limparListaExames();
    invocarServletExames("./WebServlet/exame/meus", true);
  }

  function trabalharDivMaisExames(retorno, meus) {
    if (!retorno.temMais) {
      $("#mais_resultados_busca_exames").hide();
      return;
    }

    var dados = (meus ? "./WebServlet/exame/meus/" : "./WebServlet/exame/busca/")
        + (retorno.primeiro + retorno.quantidade) + "-" + (retorno.primeiro + 2 * retorno.quantidade - 1);

    if (!meus) dados += "?busca=" + encodeURIComponent(retorno.busca);

    $("#botao_mais_resultados_busca_exames").click(function() {
      invocarServletExames(dados, meus);
    });

    $("#mais_resultados_busca_exames").show();
  }

  function limparListaExames() {
    $("#resultados_busca_exames").empty();
  }

  function popularExame(exame) {
    var t = new CarregadorDeTela();
    t.setNotificarAguarde(false);
    t.setContexto(exame);
    t.setNome("resultado_busca_exames");
    t.setCallback(function() {
      var novo = $(t.getTexto());
      $("#resultados_busca_exames").append(novo);
      var id = novo.children(".resultado_busca_exames_id").html();
      novo.click(function() { mostrarExame(id); });
    });
    t.carregarXhtml();
  }

  function mostrarExame(idExame) {
    invocarTelaRemota("visualizar_exame", "./WebServlet/exame/" + idExame);
  }

  $(area).find("#botao_buscar_exames").click(buscarExames);
  $(area).find("#botao_meus_exames").click(buscarMeusExames);
};