/*
    Documento : simuquiz_basico.js
    Criado em : 14/03/2009 11:46
    Autor     : Victor Williams Stafusa da Silva

    Simuquiz - http://www.simuquiz.com.br
 */

/**
 * Mostra os erros em um elemento na tela.
 * @param listaErros Os erros a serem mostrados.
 * @param nomeElemento O id do elemento onde os erros sero mostrados.
 */
function mostrarErros(listaErros, nomeElemento) {
  var texto = "";
  for (var i = 0; i < listaErros.length; i++) {
    texto += "<p>" + listaErros[i] + "</p>";
  }

  document.getElementById(nomeElemento).style.display = (vazio ? "none" : "block");
  document.getElementById(nomeElemento).innerHTML = (vazio ? "" : texto);
}

function contemErros(listaErros) {
  return listaErros != undefined && listaErros.length > 0;
}

function formatarData(data) {
  if (data == null || data == "") return data;
  return data.substring(8, 10) + "/" + data.substring(5, 7) + "/" + data.substring(0, 4);
}

function formatarHora(dataHora) {
  if (dataHora == null || dataHora == "") return dataHora;
  return dataHora.substring(11, 13) + ":" + dataHora.substring(14, 16) + ":" + dataHora.substring(17, 19);
}

function formatarDataHora(dataHora) {
  if (dataHora == null || dataHora == "") return dataHora;
  return dataHora.substring(8, 10) + "/" + dataHora.substring(5, 7) + "/" + dataHora.substring(0, 4) + " " +
          dataHora.substring(11, 13) + ":" + dataHora.substring(14, 16) + ":" + dataHora.substring(17, 19);
}

/**
 * Mostra os erros em uma caixa de mensagem.
 * @param listaErros Os erros a serem mostrados.
 */
function alertarErros(listaErros) {
  var texto = "";
  for (var i = 0; i < listaErros.length; i++) {
    texto += listaErros[i] + "\n";
  }
  alert(texto);
}

Array.prototype.each = function(func) {
  if (typeof func != "function") throw new Error("Argumentos invlidos.");
  for (var i = 0; i < this.length; i++) {
    if (i in this) func(this[i], i);
  }
  return this;
}

Array.prototype.contains = function(val) {
  for (var i = 0; i < this.length; i++) {
    if (i in this && this[i] == val) return true;
  }
  return false;
}

$.prototype.serializeJSON = function() {
  var ret = new Object();
  var res = this.serializeArray();
  for (var j = 0; j < res.length; j++) {
    ret[res[j].name] = res[j].value;
  }
  return ret;
};

function CarregadorDeTela() {

  if (CarregadorDeTela.templates == null) {

    /**
     * Map de templates de telas. A chave  o nome da tela e o valor  o (X)HTML
     * da tela.
     */
    CarregadorDeTela.templates = new Object();
    CarregadorDeTela.templates["aguarde"] = "<div><span>Aguarde, carregando...</span></div>";
    CarregadorDeTela.templates["mensagem"] = "<div><span>~{mensagem}~</span></div>";
    CarregadorDeTela.templates["vazio"] = "";

    /**
     * Map de templates de scripts. A chave  o nome da tela e o valor  o
     * javascript da tela.
     */
    CarregadorDeTela.scripts = new Object();

    /**
     * Map de funes a serem chamadas quando uma tela termina de carregar.
     */
    CarregadorDeTela.executors = new Object();
  }

  var notificarAguarde = false;
  var contexto = new Object();
  var texto = "";
  var callback = null;
  var callbackCountdown = -1;
  var nomeXhtml = "";
  var nomeScript = "";

  /**
   * Define se o objeto dever disparar o evento de contedo carregado
   * (o callback) para mensagens de "aguarde" ou no. Caso seja verdadeiro, o
   * evento poder ser disparado com uma mensagem de "aguarde".
   * @param valor Falso para definir que o evento seja disparado somente quando
   * o contedo for carregado. Verdadeiro para definir que o evento seja
   * disparado sempre que mudar o estado.
   * @return Este objeto (this), para permitir encadeamento de chamadas.
   */
  this.setNotificarAguarde = function(valor) {
    notificarAguarde = valor;
    return this;
  };

  /**
   * Define o callback a ser invocado quando o carregamento da tela for
   * completado.
   * @param func O callback que  disparado quando o contedo for carregado, ou
   * null em caso de nenhum.
   * @return Este objeto (this), para permitir encadeamento de chamadas.
   */
  this.setCallback = function(func) {
    callback = func;
    return this;
  };

  /**
   * Define o contexto a ser utilizado para avaliar o texto final aps terminado
   * o carregamento da tela.
   * @param valor O contexto a ser usado.
   * @return Este objeto (this), para permitir encadeamento de chamadas.
   */
  this.setContexto = function(valor) {
    contexto = valor;
    return this;
  };

  /**
   * Retorna o contexto a ser utilizado para avaliar o texto final aps
   * terminado o carregamento da tela.
   * @return O contexto a ser usado para avaliar o texto aps o carregamento da
   * tela.
   */
  this.getContexto = function() { return contexto; };

  /**
   * Retorna o callback a ser invocado quando o carregamento da tela for
   * completado.
   * @return O callback que  disparado quando o contedo for carregado, ou
   * null se no houver nenhum.
   */
  this.getCallback = function() { return callback; };

  /**
   * Indica se o carregamento da tela est completo ou no.
   * @return Verdadeiro se a tela j foi carregada, falso em caso contrrio.
   */
  this.getPronto = function() { return callbackCountdown == 0; };

  /**
   * Indica se o objeto dever disparar o evento de contedo carregado
   * (o callback) para mensagens de "aguarde" ou no.
   * @return Verdadeiro se o evento poder ser disparado com uma mensagm de
   * aguarde, falso em caso contrrio.
   */
  this.getNotificarAguarde = function() { return notificarAguarde; };

  /**
   * Retorna o texto obtido do servidor, j processado.
   * @return O texto, j processado, carregado do servidor.
   */
  this.getTexto = function() { return texto; };

  this.getNomeScript = function() { return nomeScript; };

  this.getNomeXhtml = function() { return nomeXhtml; };

  this.setNomeXhtml = function(valor) {
    nomeXhtml = valor;
    return this;
  }

  this.setNomeScript = function(valor) {
    nomeScript = valor;
    return this;
  }

  this.setNome = function(valor) {
    nomeScript = nomeXhtml = valor;
    return this;
  }

  function notificarMudanca() {
    callbackCountdown--;
    if (callback != null && (notificarAguarde || callbackCountdown == 0)) callback();
  }

  function carregarXhtmlInterno() {
    pronto = false;
    if (CarregadorDeTela.templates[nomeXhtml] != null) {
      texto = processarTemplate(CarregadorDeTela.templates[nomeXhtml], contexto);
      notificarMudanca();
      return;
    }
    texto = CarregadorDeTela.templates["aguarde"];
    if (notificarAguarde) {
      if (callback != null) callback();
    }
    $.get("./telas/" + nomeXhtml + ".jsp", {}, function(resposta) {
      CarregadorDeTela.templates[nomeXhtml] = resposta;
      try {
        texto = processarTemplate(CarregadorDeTela.templates[nomeXhtml], contexto);
      } catch (pau) {
        alert(pau);
      }
      notificarMudanca();
    }, "text");
  }

  function carregarScriptInterno() {
    $.getScript("./scripts/telas/" + nomeScript + ".js", notificarMudanca);
  }

  this.carregarXhtml = function() {
    callbackCountdown = 1;
    carregarXhtmlInterno();
  };

  this.carregarScript = function() {
    callbackCountdown = 1;
    carregarScriptInterno();
  };

  this.carregarXhtmlComScript = function() {
    callbackCountdown = 2;
    carregarScriptInterno();
    carregarXhtmlInterno();
  };

  this.carregarDestino = function(lugar) {
    return function() {
      if (callbackCountdown != 0) {
        try {
          $("#" + lugar).html(texto);
        } catch (pau) {
          alert(pau);
        }
        return;
      }

      var obj = $(texto);
      if (CarregadorDeTela.executors[nomeScript] != null) {
        try {
          CarregadorDeTela.executors[nomeScript](obj, contexto);
        } catch (pau) {
          alert(pau);
        }
      }
      $("#" + lugar).html(obj);
    };
  };
}

function invocarTelaRemota(nome, url) {
  $.ajax({
    data: null,
    url: url,
    type: "GET",
    success: function(contexto) {
      chamarTela(nome, contexto);
    },
    dataType: "json",
    error: function(request, status, error) {
      alert("Erro " + request.status + " (" + status + "): " + request.responseText);
    }
  });
}

function enviar(dados, url, callback) {
  $.ajax({
    data: dados,
    url: url,
    type: "POST",
    success: callback,
    dataType: "json",
    error: function(request, status, error) {
      alert("Erro " + request.status + " (" + status + "): " + request.responseText);
    }
  });
}

function ler(dados, url, callback) {
  $.ajax({
    data: dados,
    url: url,
    type: "GET",
    success: callback,
    dataType: "json",
    error: function(request, status, error) {
      alert("Erro " + request.status + " (" + status + "): " + request.responseText);
    }
  });
}

function chamarApenasTela(nome, contexto) {
  var t = new CarregadorDeTela();
  t.setNotificarAguarde(true);
  t.setNomeXhtml(nome);
  t.setCallback(t.carregarDestino("area_central"));
  if (contexto != null) t.setContexto(contexto);
  t.carregarXhtml();
}

function chamarTela(nome, contexto) {
  var t = new CarregadorDeTela();
  t.setNotificarAguarde(true);
  t.setNome(nome);
  t.setCallback(t.carregarDestino("area_central"));
  if (contexto != null) t.setContexto(contexto);
  t.carregarXhtmlComScript();
}

function chamarTela2(nomeXhtml, nomeScript, contexto) {
  var t = new CarregadorDeTela();
  t.setNotificarAguarde(true);
  t.setNomeXhtml(nomeXhtml);
  t.setNomeScript(nomeScript);
  t.setCallback(t.carregarDestino("area_central"));
  if (contexto != null) t.setContexto(contexto);
  t.carregarXhtmlComScript();
}

function telaMensagem(mensagem) {
  var t = new CarregadorDeTela();
  t.setNotificarAguarde(true);
  t.setNome("mensagem");
  t.setCallback(t.carregarDestino("area_central"));
  t.setContexto({mensagem: mensagem});
  t.carregarXhtml();
}

function iconeAcerto(acerta) {
  if (acerta == -1) return "X"; /* Ningum nunca fez a questo. */
  if (acerta < 0.025) return "skull.png";
  if (acerta < 0.215) return "bolaVermelha.png";
  if (acerta < 0.405) return "bolaLaranja.png";
  if (acerta < 0.595) return "bolaAmarela.png";
  if (acerta < 0.785) return "bolaVerde.png";
  if (acerta < 0.975) return "bolaAzul.png";
  return "victory.png"
}