/*
 * 21/05/2009, 14:40.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.testes.web;

import br.com.simuquiz.testes.TesteDoTeste;
import br.com.simuquiz.web.RegistroCaminho;
import java.util.Arrays;
import java.util.Map;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class TesteRegistroCaminho {

    @Test
    public void autoTeste() {
        TesteDoTeste.verificarSeNaoEsqueceuAnotacaoTest();
        TesteDoTeste.verificarSeTodosOsMocksSaoEstaticos();
    }

    private RegistroCaminho<Integer> prepopuladoSemCoringas() {
        RegistroCaminho<Integer> reg = new RegistroCaminho<Integer>();
        reg.put(1, Arrays.asList("a", "b", "c", "d"));
        reg.put(2, Arrays.asList("a", "x", "y", "z"));
        reg.put(3, Arrays.asList("a", "b", "c"));
        reg.put(4, Arrays.asList("x", "b", "c", "d"));
        reg.put(5, Arrays.asList("x", "b", "c", "f"));
        reg.put(6, Arrays.asList("x", "b"));
        return reg;
    }

    private RegistroCaminho<Integer> prepopuladoComCoringas() {
        RegistroCaminho<Integer> reg = new RegistroCaminho<Integer>();
        reg.put(1, Arrays.asList("a", "?b", "c", "d"));
        reg.put(2, Arrays.asList("a", "x", "y", "z"));
        reg.put(3, Arrays.asList("a", "?b", "c"));
        reg.put(4, Arrays.asList("x", "b", "?c", "?d", "e"));
        reg.put(5, Arrays.asList("x", "b", "?c", "?d"));
        reg.put(6, Arrays.asList("x", "b"));
        return reg;
    }

    @Test
    public void verificarInicialmenteVazio() {
        assertTrue(new RegistroCaminho<Integer>().isEmpty());
    }

    @Test
    public void verificarInclusaoSimples() {
        RegistroCaminho<Integer> reg = new RegistroCaminho<Integer>();
        reg.put(5, Arrays.asList("a", "b", "c", "d"));
        assertEquals((Object) 5, reg.get(Arrays.asList("a", "b", "c", "d")));
    }

    @Test
    public void verificarNaoVazioAposIncluir() {
        RegistroCaminho<Integer> reg = new RegistroCaminho<Integer>();
        reg.put(5, Arrays.asList("a", "b", "c", "d"));
        assertFalse(reg.isEmpty());
    }

    @Test
    public void verificarTentativaDeIncluirDuasVezes() {
        RegistroCaminho<Integer> reg = new RegistroCaminho<Integer>();
        reg.put(5, Arrays.asList("a", "b", "c", "d"));
        assertFalse(reg.put(6, Arrays.asList("a", "b", "c", "d")));
        assertEquals((Object) 5, reg.get(Arrays.asList("a", "b", "c", "d")));
    }

    @Test
    public void verificarInclusaoSimplesComCoringa() {
        RegistroCaminho<Integer> reg = new RegistroCaminho<Integer>();
        reg.put(5, Arrays.asList("a", "?b", "c", "d"));
        assertEquals((Object) 5, reg.get(Arrays.asList("a", "27", "c", "d")));
    }

    @Test
    public void verificarCaminhosMultiplosCoringa1() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        assertEquals((Object) 1, reg.get(Arrays.asList("a", "555", "c", "d")));
        assertEquals((Object) 1, reg.get(Arrays.asList("a", "777", "c", "d")));
    }

    @Test
    public void verificarCoringa1() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        Map<String, String> map = reg.coringas(Arrays.asList("a", "444", "c", "d"));
        assertEquals(1, map.size());
        assertEquals("444", map.get("b"));
    }

    @Test
    public void verificarCaminhosMultiplosCoringa2() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        assertEquals((Object) 3, reg.get(Arrays.asList("a", "555", "c")));
        assertEquals((Object) 3, reg.get(Arrays.asList("a", "777", "c")));
    }

    @Test
    public void verificarCoringa2() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        Map<String, String> map = reg.coringas(Arrays.asList("a", "555", "c"));
        assertEquals(1, map.size());
        assertEquals("555", map.get("b"));
    }

    @Test
    public void verificarCaminhosMultiplosCoringa3() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        assertEquals((Object) 5, reg.get(Arrays.asList("x", "b", "555", "888")));
        assertEquals((Object) 5, reg.get(Arrays.asList("x", "b", "777", "222")));
    }

    @Test
    public void verificarCoringa3() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        Map<String, String> map = reg.coringas(Arrays.asList("x", "b", "555", "888"));
        assertEquals(2, map.size());
        assertEquals("555", map.get("c"));
        assertEquals("888", map.get("d"));
    }

    @Test
    public void verificarCaminhosMultiplosCoringa4() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        assertEquals((Object) 4, reg.get(Arrays.asList("x", "b", "444", "999", "e")));
        assertEquals((Object) 4, reg.get(Arrays.asList("x", "b", "333", "111", "e")));
    }

    @Test
    public void verificarCoringa4() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        Map<String, String> map = reg.coringas(Arrays.asList("x", "b", "555", "888", "e"));
        assertEquals(2, map.size());
        assertEquals("555", map.get("c"));
        assertEquals("888", map.get("d"));
    }

    @Test
    public void verificarCaminhosMultiplosNaoAchaNada() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        assertNull(reg.get(Arrays.asList("x", "b", "444", "999", "e", "f")));
    }

    @Test
    public void verificarCoringaNaoAchaNada() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        Map<String, String> map = reg.coringas(Arrays.asList("x", "b", "555", "888", "e", "f"));
        assertNull(map);
    }

    @Test
    public void testarCoringasIguaisComNomesDiferentesEmSubcaminhos() {
        RegistroCaminho<Integer> reg = prepopuladoComCoringas();
        reg.put(51, Arrays.asList("n", "b", "?c", "?d", "e"));
        reg.put(69, Arrays.asList("n", "b", "?r", "?s"));

        Map<String, String> map = reg.coringas(Arrays.asList("n", "b", "555", "888", "e"));
        assertEquals(2, map.size());
        assertEquals("555", map.get("c"));
        assertEquals("888", map.get("d"));

        map = reg.coringas(Arrays.asList("n", "b", "444", "222"));
        assertEquals(2, map.size());
        assertEquals("444", map.get("r"));
        assertEquals("222", map.get("s"));
    }
}
