/*
 * 16/05/2009, 07:53.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.testes.web;

import br.com.simuquiz.testes.TesteDoTeste;
import br.com.simuquiz.web.MapeamentoInconsistenteException;
import br.com.simuquiz.web.AplicativoRest;
import org.junit.Test;
import static org.junit.Assert.*;
import static br.com.simuquiz.testes.web.MocksWeb.*;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class TesteComportamentoAplicativoRest {

    @Test
    public void autoTeste() {
        TesteDoTeste.verificarSeNaoEsqueceuAnotacaoTest();
    }

    @Test
    public void testaCriacaoMockComMapeadorExcecao() {
        try {
            new AplicativoRest(MockZoadoComMapeadorExcecao.class);
        } catch (MapeamentoInconsistenteException e) {
            // Na classe MockZoadoComMapeadorExcecao, TesteException  lanado.
            if (!(e.getCause() instanceof MockException)) fail();
        }
    }

    @Test
    public void testaCriacaoMockComExcecao() {
        try {
            new AplicativoRest(MockZoadoComExcecaoNoConstrutor.class);
        } catch (MapeamentoInconsistenteException e) {
            // Na classe MockZoadoComExcecaoNoConstrutor, TesteException  lanado.
            if (!(e.getCause() instanceof MockException)) fail();
        }
    }

    @Test(expected=MapeamentoInconsistenteException.class)
    public void testaCriacaoMockNonSense1() {
        new AplicativoRest(String.class);
    }

    @Test(expected=MapeamentoInconsistenteException.class)
    public void testaCriacaoMockNonSense2() {
        new AplicativoRest(this.getClass());
    }
}
