/*
 * 16/05/2009, 02:27.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.testes.util;

import br.com.simuquiz.testes.TesteDoTeste;
import static br.com.simuquiz.util.MathUtils.*;
import static org.junit.Assert.*;
import org.junit.Test;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class TesteMath {

    @Test
    public void autoTeste() {
        TesteDoTeste.verificarSeNaoEsqueceuAnotacaoTest();
    }

    @Test
    public void testaParseIntValido() {
        assertEquals((Object) 42, tryParseInt("42"));
    }

    @Test
    public void testaParseIntLixo() {
        assertEquals((Object) null, tryParseInt("Foo"));
    }

    @Test
    public void testaParseIntNulo() {
        assertEquals((Object) null, tryParseInt(null));
    }

    @Test
    public void testaParseIntNegativo() {
        assertEquals((Object) (-42), tryParseInt("-42"));
    }

    @Test
    public void testaParseIntMuitoGrande() {
        assertEquals((Object) null, tryParseInt("999999999999999999999999999999999999"));
    }

    @Test
    public void testaParseIntMuitoGrandeNegativo() {
        assertEquals((Object) null, tryParseInt("-999999999999999999999999999999999999"));
    }

    @Test
    public void testaParseLongValido() {
        assertEquals((Object) 42L, tryParseLong("42"));
    }

    @Test
    public void testaParseLongLixo() {
        assertEquals((Object) null, tryParseLong("Foo"));
    }

    @Test
    public void testaParseLongNulo() {
        assertEquals((Object) null, tryParseLong(null));
    }

    @Test
    public void testaParseLongNegativo() {
        assertEquals((Object) (-42L), tryParseLong("-42"));
    }

    @Test
    public void testaParseLongMuitoGrande() {
        assertEquals((Object) null, tryParseLong("999999999999999999999999999999999999"));
    }

    @Test
    public void testaParseLongMuitoGrandeNegativo() {
        assertEquals((Object) null, tryParseLong("-999999999999999999999999999999999999"));
    }

    @Test
    public void testaSeNumeroInteiroEhValido() {
        assertTrue(numeroValido("57"));
    }

    @Test
    public void testaSeNumeroNegativoInteiroEhValido() {
        assertTrue(numeroValido("-57"));
    }

    @Test
    public void testaSeNumeroNullEhValido() {
        assertFalse(numeroValido(null));
    }

    @Test
    public void testaSeNumeroLixoEhValido() {
        assertFalse(numeroValido("xyz"));
    }

    @Test
    public void testaSeNumeroComEspacoEhValido() {
        assertFalse(numeroValido(" "));
    }

    @Test
    public void testaSeNumeroComVazioEhValido() {
        assertFalse(numeroValido(""));
    }

    @Test
    public void testaSeNumeroPrecedidoDeEspacoEhValido() {
        assertFalse(numeroValido(" 57"));
    }

    @Test
    public void testaSeNumeroSucedidoDeEspacoEhValido() {
        assertFalse(numeroValido("57 "));
    }

    @Test
    public void testaSeNumeroFracionarioEhValido() {
        assertTrue(numeroValido("42.89"));
    }

    @Test
    public void testaSeNumeroFracionarioNegatioEhValido() {
        assertTrue(numeroValido("-42.89"));
    }

    @Test
    public void testaSeNumeroMenosEhValido() {
        assertFalse(numeroValido("-"));
    }

    @Test
    public void testaSeNumeroTerminandoComPontoEhValido() {
        assertFalse(numeroValido("42."));
    }

    @Test
    public void testaSeNumeroComecandoComPontoEhValido() {
        assertFalse(numeroValido(".89"));
    }

    @Test
    public void testaSeNumeroNegativoComecandoComPontoEhValido() {
        assertFalse(numeroValido("-.89"));
    }

    @Test
    public void testaSeNumeroComEspacoNoMeioEhValido() {
        assertFalse(numeroValido("7 89"));
    }

    @Test
    public void testaSeNumeroNegativoComEspacoNoMeioEhValido() {
        assertFalse(numeroValido("-7 89"));
    }

    @Test
    public void testaSeNumeroNotacaoCienticaEhValido() {
        assertFalse(numeroValido("28e4"));
    }

    @Test
    public void testaSeNumeroNotacaoCienticaComExpoenteNegativoEhValido() {
        assertFalse(numeroValido("28E-4"));
    }

    @Test
    public void testaSeNumeroNegativoNotacaoCienticaEhValido() {
        assertFalse(numeroValido("-28e4"));
    }

    @Test
    public void testaSeNumeroComMenosNoMeioEhValido() {
        assertFalse(numeroValido("4-2"));
    }

    @Test
    public void testaSeNumeroComMenosNoFimEhValido() {
        assertFalse(numeroValido("42-"));
    }
}
