/*
 * 16/03/2009, 13:31.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.testes.util;

import br.com.simuquiz.testes.TesteDoTeste;
import br.com.simuquiz.util.JsonMarshal;
import br.com.simuquiz.util.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class TesteJsonMarshal {

    @Test
    public void autoTeste() {
        TesteDoTeste.verificarSeNaoEsqueceuAnotacaoTest();
        TesteDoTeste.verificarSeTodosOsMocksSaoEstaticos();
    }

    @JsonMarshal
    public static class Mock1 {
        public Mock1() {}

        @JsonMarshal
        public int getX() {
            return 25;
        }

        @JsonMarshal
        public String getBanana() {
            return "azul";
        }

        @JsonMarshal
        public String getNada() {
            return null;
        }

        public int getXxx() {
            return 666;
        }

        @JsonMarshal("coisa louca")
        public Mock2 getCoisa() {
            return new Mock2();
        }
    }

    @JsonMarshal
    public static class Mock2 {
        public Mock2() {}

        @JsonMarshal
        public String getValor1() {
            return "abc";
        }

        @JsonMarshal
        public int getValor2() {
            return 42;
        }

        @JsonMarshal
        public boolean isSucesso() {
            return true;
        }

        @JsonMarshal
        public Collection<Date> getFoo() {
            return Arrays.asList(new Date(), new Date());
        }

        @JsonMarshal
        public Map<String, Object> getNanana() {
            Map<String, Object> m = new HashMap<String, Object>();
            m.put("geladeira", 34);
            m.put("torradeira", "verde");
            m.put("fogao", new Mock3());
            return m;
        }
    }

    @JsonMarshal
    public static class Mock3 {
        public Mock3() {}

        @JsonMarshal
        public int getAaa() {
            return 28;
        }

        @JsonMarshal
        public String getBbb() {
            return "pizza";
        }
    }

    @Test
    public void testeSerializaJson() {
        System.out.println(JsonObject.serializar(new Mock1()));
    }
}
