/*
 * 15/03/2009, 14:38.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.testes.util;

import br.com.simuquiz.testes.TesteDoTeste;
import br.com.simuquiz.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class TesteJsonEscape {

    @Test
    public void autoTeste() {
        TesteDoTeste.verificarSeNaoEsqueceuAnotacaoTest();
    }

    @Test
    public void testeSimples() {
        String x = "aaa";
        Assert.assertEquals("aaa", StringUtils.jsonFormat(x));
    }

    @Test
    public void testeAspas() {
        String x = "aaa\"bbb";
        Assert.assertEquals("aaa\\\"bbb", StringUtils.jsonFormat(x));
    }

    @Test
    public void testeBarra() {
        String x = "aaa\\bbb";
        Assert.assertEquals("aaa\\\\bbb", StringUtils.jsonFormat(x));
    }

    @Test
    public void testeUnicode() {
        String x = "aaa\u0123bbb";
        Assert.assertEquals("aaa\\u0123bbb", StringUtils.jsonFormat(x));
    }

    @Test
    public void testeUnicode2() {
        String x = "aaa\uA8CDbbb";
        Assert.assertEquals("aaa\\uA8CDbbb", StringUtils.jsonFormat(x));
    }

    @Test
    public void testeCompleto() {
        String x = "aaa\"bbb\\ccc\\\u0123\"";
        Assert.assertEquals("aaa\\\"bbb\\\\ccc\\\\\\u0123\\\"", StringUtils.jsonFormat(x));
    }
}
