/*
 * 08/03/2009, 17:12.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.testes.util;

import br.com.simuquiz.testes.TesteDoTeste;
import static br.com.simuquiz.util.StringUtils.*;
import static org.junit.Assert.*;
import org.junit.Test;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class TesteEmail {

    @Test
    public void autoTeste() {
        TesteDoTeste.verificarSeNaoEsqueceuAnotacaoTest();
    }

    @Test
    public void emailSimples() {
        assertTrue(emailValido("naomandespam@simuquiz.com"));
    }

    @Test
    public void emailComUnderscores() {
        assertTrue(emailValido("nao_mande_spam@simuquiz.com"));
    }

    @Test
    public void emailSoComUnderscores() {
        // Bem estranho, mas no h motivo para que seja invlido.
        assertTrue(emailValido("_@_._"));
    }

    @Test
    public void emailSoComUnderscoresDuplos() {
        // Bem estranho, mas no h motivo para que seja invlido.
        assertTrue(emailValido("__.__@__.__"));
    }

    @Test
    public void emailComNumeros() {
        assertTrue(emailValido("nao2mande3spam4@simuquiz5.com6.br"));
    }

    @Test
    public void emailOndeUsuarioEhNumero() {
        assertTrue(emailValido("12345@simuquiz.com"));
    }

    @Test
    public void emailOndeUsuarioEDominioSaoNumeros() {
        // Isso  vlido??? Como no sei, vou assumir que sim.
        assertTrue(emailValido("12345@12345.com"));
    }

    @Test
    public void emailComPontos() {
        assertTrue(emailValido("nao.mande.spam@simuquiz.com.br"));
    }

    @Test
    public void emailComUsurioEmMaiusculas() {
        assertFalse(emailValido("NAOMANDESPAM@simuquiz.com"));
    }

    @Test
    public void emailComDominioEmMaiusculas() {
        assertFalse(emailValido("naomandespam@SIMUQUIZ.COM"));
    }

    @Test
    public void emailComParteDoDominioEmMaiusculas() {
        assertFalse(emailValido("naomandespam@SIMUQUIZ.com"));
    }

    @Test
    public void emailComPrimeiraLetraEmMaiusculas() {
        assertFalse(emailValido("Naomandespam@simuquiz.com"));
    }

    @Test
    public void emailComPrimeiraLetraDoDominioEmMaiusculas() {
        assertFalse(emailValido("naomandespam@Simuquiz.com"));
    }

    @Test
    public void emailComEspacoNoNomeDoUsuario() {
        assertFalse(emailValido("nao mande spam@simuquiz.com.br"));
    }

    @Test
    public void emailComEspacoNoDominio() {
        assertFalse(emailValido("naomandespam@simuquiz.com br"));
    }

    @Test
    public void emailComecandoPorEspaco() {
        assertFalse(emailValido(" naomandespam@simuquiz.com.br"));
    }

    @Test
    public void emailTerminandoComEspaco() {
        assertFalse(emailValido("naomandespam@simuquiz.com.br "));
    }

    @Test
    public void emailComEspacoAntesDoArroba() {
        assertFalse(emailValido("naomandespam @simuquiz.com.br"));
    }

    @Test
    public void emailComEspacoDepoisDoArroba() {
        assertFalse(emailValido("naomandespam@ simuquiz.com.br"));
    }

    @Test
    public void emailSemArroba() {
        assertFalse(emailValido("naomandespam.simuquiz.com.br"));
    }

    @Test
    public void emailSoComArroba() {
        assertFalse(emailValido("@"));
    }

    @Test
    public void emilComDoisArrobas() {
        assertFalse(emailValido("naomande@spam@simuquiz.com.br"));
    }

    @Test
    public void emailComDoisArrobasSeguidos() {
        assertFalse(emailValido("naomandespam@@simuquiz.com.br"));
    }

    @Test
    public void emailComArrobaNoComeco() {
        assertFalse(emailValido("@simuquiz.com"));
    }

    @Test
    public void emailComArrobaNoFinal() {
        assertFalse(emailValido("nao_mande_spam@"));
    }

    @Test
    public void emailSemPonto() {
        assertFalse(emailValido("naomandespam@simuquiz"));
    }

    @Test
    public void emailSemPontoNoDominio() {
        assertFalse(emailValido("nao.mande.spam@simuquiz"));
    }

    @Test
    public void emailComPontoNoInicio() {
        assertFalse(emailValido(".nao.mande.spam@simuquiz.com"));
    }

    @Test
    public void emailComPontoNoFinal() {
        assertFalse(emailValido("nao.mande.spam@simuquiz.com."));
    }

    @Test
    public void emailComDoisPontosSeguidosNoUsuario() {
        assertFalse(emailValido("nao..mande.spam@simuquiz.com"));
    }

    @Test
    public void emailComDoisPontosSeguidosNoDominio() {
        assertFalse(emailValido("nao.mande.spam@simuquiz..com"));
    }

    @Test
    public void emailComPontoAntesDoArroba() {
        assertFalse(emailValido("nao.mande.spam.@simuquiz.com"));
    }

    @Test
    public void emailComPontoDepoisDoArroba() {
        assertFalse(emailValido("nao.mande.spam@.simuquiz.com"));
    }

    @Test
    public void emailComCaracteresInvalido1() {
        assertFalse(emailValido("nao$mande.spam@simuquiz.com"));
    }

    @Test
    public void emailComCaracteresInvalido2() {
        assertFalse(emailValido("nao!mande.spam@simuquiz.com"));
    }

    @Test
    public void emailComCaracteresInvalido3() {
        assertFalse(emailValido("nao[mande.spam@simuquiz.com"));
    }

    @Test
    public void emailComCaracteresInvalido4() {
        assertFalse(emailValido("nao#mande.spam@simuquiz.com"));
    }

    @Test
    public void emailComCaracteresInvalido5() {
        assertFalse(emailValido("nao^mande.spam@simuquiz.com"));
    }

    @Test
    public void emailComCaracteresInvalido6() {
        assertFalse(emailValido("nao${mande}spam@simuquiz.com"));
    }

    @Test
    public void emailEmBranco() {
        assertFalse(emailValido(""));
    }

    @Test
    public void emailSoComEspaco() {
        assertFalse(emailValido(" "));
    }

    @Test
    public void emailComDoisEspacos() {
        assertFalse(emailValido("  "));
    }

    @Test
    public void emailNulo() {
        assertFalse(emailValido(null));
    }

    @Test
    public void emailComAcento1() {
        assertFalse(emailValido("nomandespam@simuquiz.com"));
    }

    @Test
    public void emailComAcento2() {
        assertFalse(emailValido("namndspm@simuquiz.com"));
    }

    @Test
    public void emailComAcento3() {
        assertFalse(emailValido("naomandespam@simquiz.com"));
    }

    @Test
    public void emailComAcento4() {
        assertFalse(emailValido("naomandespam@simuquiz.cm"));
    }
}
