/*
 * 20/05/2009, 20:10.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class RestServlet extends HttpServlet {

    private static final long serialVersionUID = 5720774993746097972L;

    private AplicativoRest web;

    @Override
    public void init() {
        String initParam = this.getInitParameter("classe").trim();
        try {
            web = new AplicativoRest(Class.forName(initParam));
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (web.permite(HttpMethod.HEAD)) {
            web.executar(HttpMethod.HEAD, request, response);
        } else {
            super.doHead(request, response);
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (web.permite(HttpMethod.GET)) {
            web.executar(HttpMethod.GET, request, response);
        } else {
            super.doGet(request, response);
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (web.permite(HttpMethod.POST)) {
            web.executar(HttpMethod.POST, request, response);
        } else {
            super.doPost(request, response);
        }
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (web.permite(HttpMethod.PUT)) {
            web.executar(HttpMethod.PUT, request, response);
        } else {
            super.doPut(request, response);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (web.permite(HttpMethod.DELETE)) {
            web.executar(HttpMethod.DELETE, request, response);
        } else {
            super.doDelete(request, response);
        }
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (web.permite(HttpMethod.OPTIONS)) {
            web.executar(HttpMethod.OPTIONS, request, response);
        } else {
            super.doOptions(request, response);
        }
    }

    @Override
    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (web.permite(HttpMethod.TRACE)) {
            web.executar(HttpMethod.TRACE, request, response);
        } else {
            super.doTrace(request, response);
        }
    }
}
