/*
 * 20/05/2009, 22:17.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.web;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class RegistroMapeador {

    private final Map<Class<? extends Mapeador>, Mapeador> poolMapeadores;
    private final Mapeador mapeadorDefault;

    public RegistroMapeador(Class<? extends Mapeador> classeMapeadorDefault) {
        this.poolMapeadores = new HashMap<Class<? extends Mapeador>, Mapeador>();
        mapeadorDefault = obterMapeador(classeMapeadorDefault);
    }

    public Mapeador getMapeadorDefault() {
        return mapeadorDefault;
    }

    public <E extends Mapeador> E obterMapeador(Class<E> classeMapeador) {

        // Tenta obter uma instancia j existente.
        E mapeador = classeMapeador.cast(poolMapeadores.get(classeMapeador));
        if (mapeador != null) return mapeador;

        // No h instncia. Tenta criar uma e registr-la.
        try {
            mapeador = classeMapeador.getConstructor().newInstance();
            poolMapeadores.put(classeMapeador, mapeador);
            return mapeador;
        } catch (NoSuchMethodException e) {
            throw new MapeamentoInconsistenteException("O mapeador " + classeMapeador.getName()
                    + " no  vlido pois no tem um construtor pblico sem argumentos.");
        } catch (InstantiationException e) {
            throw new MapeamentoInconsistenteException("O mapeador " + classeMapeador.getName()
                    + " no  vlido pois no  uma classe concreta.");
        } catch (IllegalAccessException e) {
            throw new MapeamentoInconsistenteException("O mapeador " + classeMapeador.getName()
                    + " no pde ser instanciado por no ser pblico.");
        } catch (InvocationTargetException e) {
            throw new MapeamentoInconsistenteException("O mapeador " + classeMapeador.getName()
                    + " no pde ser instanciado porque o construtor lanou uma exceo.",
                    e.getCause());
        }
    }
}
