/*
 * 19/05/2009, 05:23.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * @author Victor Williams Stafusa da Silva
 */
public final class Path {

    private final List<String> paths;
    private final int coringas;

    private static List<String> quebrarPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("O caminho no pode ser nulo.");
        }
        path = path.replace('\\', '/');
        if (path.contains("//")) {
            throw new IllegalArgumentException("O caminho no pode conter duas barras consecutivas.");
        }
        if (path.startsWith("/")) path = path.substring(1);
        if (path.endsWith("/")) path = path.substring(0, path.length() - 1);
        return Arrays.asList(path.split("/"));
    }

    public Path(String path) {
        this(quebrarPath(path));
    }

    private Path(List<String> paths) {
        this.paths = Collections.unmodifiableList(paths);
        int interrogacoes = 0;

        for (String p : this.paths) {
            if (p.isEmpty()) continue;

            if ("?".equals(p)) {
                throw new IllegalArgumentException("Sinais de \"?\" devem ser sucedidos de um nome.");
            } else if (p.length() > 1 && p.charAt(0) == '?') {
                if (p.substring(1).contains("?")) {
                    throw new IllegalArgumentException("O sinal de \"?\" deve aparecer apenas antes de um nome.");
                }
                if (p.charAt(1) == ' ') {
                    throw new IllegalArgumentException("O nome aps o sinal de \"?\" deve no pode comear com espao.");
                }
                interrogacoes++;
            }
        }
        this.coringas = interrogacoes;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (String p : paths) {
            hash ^= Integer.rotateLeft(p.hashCode(), 13);
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Path)) return false;

        Path outro = (Path) obj;
        if (outro.paths.size() != this.paths.size()) {
            return false;
        }
        Iterator<String> itA = this.paths.iterator();
        Iterator<String> itB = outro.paths.iterator();
        while (itA.hasNext()) {
            String a = itA.next();
            String b = itB.next();
            if (!a.equals(b)) return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s: paths) {
            sb.append(s).append('/');
        }
        return sb.toString();
    }

    public List<String> elementos() {
        return paths;
    }

    public Path superPath() {
        int qtd = paths.size() - 1;
        if (qtd == -1) return null;

        List<String> superPaths = new ArrayList<String>(qtd);
        for (String p : paths) {
            if (qtd == 0) break;
            superPaths.add(p);
            qtd--;
        }
        return new Path(superPaths);
    }

    public int coringas() {
        return coringas;
    }
}
