/*
 * 03/05/2009, 22:28.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.util;

import java.util.regex.Pattern;

/**
 * Esta classe representa um pacote de funes auxiliares para manipular
 * nmeros e fazer contas matemticas.
 * @author Victor Williams Stafusa da Silva
 */
public final class MathUtils {

    /**
     * Esta classe no  instancivel.
     */
    private MathUtils() {}

    public static Integer tryParseInt(String valor) {
        try {
            return Integer.parseInt(valor);
        } catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long tryParseLong(String valor) {
        try {
            return Long.parseLong(valor);
        } catch (NumberFormatException e) {
            return null;
        }
    }

    /**
     * {@linkplain Pattern} usado internamente para determinar se um nmero 
     * vlido ou no.
     */
    private static final Pattern NUMEROS_PATTERN =
            Pattern.compile("[\\-]?[0-9]+([\\.][0-9]+)?");

    /**
     * Determina se um texto vlido tem o formato de um nmero.
     * @param s O texto a ser testado.
     * @return {@code true} se tiver formato de nmero, {@code false} em caso
     * contrrio.
     */
    public static boolean numeroValido(String s) {
        return s != null && NUMEROS_PATTERN.matcher(s).matches();
    }
}
