/*
 * 16/03/2009, 12:51.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.util;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Anotao que indica quais campos e classes so relevantes para serem
 * serializados em formato JSON.
 * Deve ser utilizada em mtodos getters e em classes. Quando utilizado em
 * classes, indica que a classe tem campos serializveis em formato JSON.
 * Os campos a serem serializados so definidos de acordo com os getters nos
 * quais esta anotao est presente.
 * Os mtodos anotados com {@linkplain JsonMarshal} devem ser pblicos, de
 * instncia, no ter parmetros, devem retornar algo diferente de {@code void}
 * e no devem nunca lanar excees.
 * @author Victor Williams Stafusa da Silva
 */
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface JsonMarshal {

    /**
     * Nome do campo JSON para o qual o mtodo getter ser serializado.
     * No tem efeito se usado em classes.
     * Este atributo  opcional. Caso no seja especificado, o nome do campo
     * JSON ser deduzido a partir da assinatura do mtodo.
     * @return O nome do campo, caso este tenha sido definido, ou uma
     * {@linkplain String} vazia caso este deva ser deduzido a partir da
     * assinatura do mtodo.
     */
    public String value() default "";
}
