/*
 * 10/03/2009, 06:19.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.servlets;

import br.com.simuquiz.conexao.Database;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * Servlet listener responsvel por iniciar e fechar o banco de dados.
 * @author Victor Williams Stafusa da Silva
 */
public class SimuquizServletContextListener implements ServletContextListener {

    /**
     * Inicializa o banco de dados da aplicao.
     * @param sce No  utilizado por esta classe.
     */
    @Override
    public void contextInitialized(ServletContextEvent sce) {
        Database.init();
    }

    /**
     * Fecha o banco de dados da aplicao.
     * @param sce No  utilizado por esta classe.
     */
    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        Database.close();
    }

}
