/*
 * 15/05/2009, 17:27.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.usuario.cadastro;

import br.com.simuquiz.entidades.Usuario;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class IncluirUsuarioStrategy implements Strategy {

    private final Entrada entrada;

    public IncluirUsuarioStrategy(Entrada entrada) {
        this.entrada = entrada;
    }

    @Override
    public boolean exigirVerificarSenha() {
        return true;
    }

    @Override
    public boolean exigirVerificarLoginExistente() {
        return true;
    }

    @Override
    public Usuario cadastrar() {
        return Usuario.novo(entrada.getNome(), entrada.getLogin(), entrada.getSenha(), entrada.getEmail());
    }

    @Override
    public Entrada getEntrada() {
        return entrada;
    }
}
