/*
 * 11/06/2009, 18:46.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.questao;

import br.com.simuquiz.entidades.Questao;
import br.com.simuquiz.funcionalidades.RelatorioProblemas;
import br.com.simuquiz.util.JsonMarshal;

/**
 * @author Victor Williams Stafusa da Silva
 * @author Pedro Lopes de Souza
 */
@JsonMarshal
public class FuncionalidadeVisualizarQuestao {

    private final Long idQuestao;

    /** Relao de problemas ocorridos. */
    private final RelatorioProblemas<TiposErros> problemas;

    private final Questao questao;

    public enum TiposErros {
        ERRO
    }

    public FuncionalidadeVisualizarQuestao(Long idQuestao) {
        this.idQuestao = idQuestao;

        this.problemas = new RelatorioProblemas<TiposErros>(TiposErros.class);

        // Validaes bsicas.
        if (idQuestao == null) {
            problemas.adicionarProblema(TiposErros.ERRO, "A questo deve ser informada.");
        }

        // Em caso de no haver problemas, mostra a questo.
        Questao q = null;
        if (problemas.isVazio()) {
            try {
                q = Questao.pesquisarPorId(idQuestao);
            } catch (Throwable t) {
                problemas.adicionarProblema(TiposErros.ERRO, t);
                t.printStackTrace();
                // TODO: Acrescentar log.
            }
        }
        questao = q;

        // Finaliza o processo e se torna apenas um bean.
        problemas.fechar();
    }

    @JsonMarshal
    public Long getIdQuestao() {
        return idQuestao;
    }

    @JsonMarshal
    public RelatorioProblemas getProblemas() {
        return problemas;
    }

    @JsonMarshal
    public Questao getQuestao() {
        return questao;
    }

    @JsonMarshal
    public boolean isSucesso() {
        return problemas.isVazio();
    }
}
